/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.block;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tauri.dev.jsg.block.JSGAbstractCustomItemBlock;
import tauri.dev.jsg.block.JSGAbstractCustomMetaItemBlock;
import tauri.dev.jsg.block.JSGBlock;
import tauri.dev.jsg.block.beamer.BeamerBlock;
import tauri.dev.jsg.block.dialhomedevice.DHDBlock;
import tauri.dev.jsg.block.dialhomedevice.DHDPegasusBlock;
import tauri.dev.jsg.block.energy.ZPMBlock;
import tauri.dev.jsg.block.energy.ZPMBlockCreative;
import tauri.dev.jsg.block.energy.ZPMHubBlock;
import tauri.dev.jsg.block.energy.ZPMSlotBlock;
import tauri.dev.jsg.block.energy.capacitor.CapacitorBlock;
import tauri.dev.jsg.block.energy.capacitor.CapacitorBlockCreative;
import tauri.dev.jsg.block.energy.capacitor.CapacitorBlockEmpty;
import tauri.dev.jsg.block.invisible.InvisibleBlock;
import tauri.dev.jsg.block.invisible.IrisBlock;
import tauri.dev.jsg.block.machine.AssemblerBlock;
import tauri.dev.jsg.block.machine.CrystalChamberBlock;
import tauri.dev.jsg.block.machine.OreWashingBlock;
import tauri.dev.jsg.block.machine.PCBFabricatorBlock;
import tauri.dev.jsg.block.ore.NaquadahOreBlock;
import tauri.dev.jsg.block.ore.TitaniumOreBlock;
import tauri.dev.jsg.block.ore.TriniumOreBlock;
import tauri.dev.jsg.block.props.AncientSignBlock;
import tauri.dev.jsg.block.props.DestinyCountDownBlock;
import tauri.dev.jsg.block.props.TRPlatformBlock;
import tauri.dev.jsg.block.stargate.StargateClassicMemberBlock;
import tauri.dev.jsg.block.stargate.StargateMilkyWayBaseBlock;
import tauri.dev.jsg.block.stargate.StargateMilkyWayMemberBlock;
import tauri.dev.jsg.block.stargate.StargateOrlinBaseBlock;
import tauri.dev.jsg.block.stargate.StargateOrlinMemberBlock;
import tauri.dev.jsg.block.stargate.StargatePegasusBaseBlock;
import tauri.dev.jsg.block.stargate.StargatePegasusMemberBlock;
import tauri.dev.jsg.block.stargate.StargateUniverseBaseBlock;
import tauri.dev.jsg.block.stargate.StargateUniverseMemberBlock;
import tauri.dev.jsg.block.transportrings.TransportRingsAncientBlock;
import tauri.dev.jsg.block.transportrings.TransportRingsGoauldBlock;
import tauri.dev.jsg.block.transportrings.TransportRingsOriBlock;
import tauri.dev.jsg.block.transportrings.controller.TRControllerGoauldBlock;
import tauri.dev.jsg.creativetabs.JSGCreativeTabsHandler;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.util.BlockHelpers;

@Mod.EventBusSubscriber
public class JSGBlocks {
    public static final InvisibleBlock INVISIBLE_BLOCK = new InvisibleBlock();
    public static final IrisBlock IRIS_BLOCK = new IrisBlock();
    public static final NaquadahOreBlock ORE_NAQUADAH_BLOCK = new NaquadahOreBlock("naquadah_ore", true);
    public static final NaquadahOreBlock ORE_NAQUADAH_BLOCK_STONE = new NaquadahOreBlock("naquadah_ore_stone", false);
    public static final TriniumOreBlock ORE_TRINIUM_BLOCK = new TriniumOreBlock("trinium_ore");
    public static final TitaniumOreBlock ORE_TITANIUM_BLOCK = new TitaniumOreBlock("titanium_ore");
    public static final JSGBlock NAQUADAH_BLOCK_RAW = (JSGBlock)BlockHelpers.createSimpleBlock("naquadah_block_raw", Material.field_151573_f, JSGCreativeTabsHandler.JSG_ORES_CREATIVE_TAB).func_149711_c(3.0f);
    public static final JSGBlock NAQUADAH_BLOCK = (JSGBlock)BlockHelpers.createSimpleBlock("naquadah_block", Material.field_151573_f, JSGCreativeTabsHandler.JSG_ORES_CREATIVE_TAB).func_149711_c(3.0f);
    public static final JSGBlock TRINIUM_BLOCK = (JSGBlock)BlockHelpers.createSimpleBlock("trinium_block", Material.field_151573_f, JSGCreativeTabsHandler.JSG_ORES_CREATIVE_TAB).func_149711_c(3.0f);
    public static final JSGBlock TITANIUM_BLOCK = (JSGBlock)BlockHelpers.createSimpleBlock("titanium_block", Material.field_151573_f, JSGCreativeTabsHandler.JSG_ORES_CREATIVE_TAB).func_149711_c(3.0f);
    public static final StargateMilkyWayBaseBlock STARGATE_MILKY_WAY_BASE_BLOCK = new StargateMilkyWayBaseBlock();
    public static final StargateUniverseBaseBlock STARGATE_UNIVERSE_BASE_BLOCK = new StargateUniverseBaseBlock();
    public static final StargateOrlinBaseBlock STARGATE_ORLIN_BASE_BLOCK = new StargateOrlinBaseBlock();
    public static final StargatePegasusBaseBlock STARGATE_PEGASUS_BASE_BLOCK = new StargatePegasusBaseBlock();
    public static final DHDBlock DHD_BLOCK = new DHDBlock();
    public static final DHDPegasusBlock DHD_PEGASUS_BLOCK = new DHDPegasusBlock();
    public static final TransportRingsGoauldBlock TRANSPORT_RINGS_GOAULD_BLOCK = new TransportRingsGoauldBlock();
    public static final TransportRingsOriBlock TRANSPORT_RINGS_ORI_BLOCK = new TransportRingsOriBlock();
    public static final TransportRingsAncientBlock TRANSPORT_RINGS_ANCIENT_BLOCK = new TransportRingsAncientBlock();
    public static final TRControllerGoauldBlock TR_CONTROLLER_GOAULD_BLOCK = new TRControllerGoauldBlock();
    public static final StargateMilkyWayMemberBlock STARGATE_MILKY_WAY_MEMBER_BLOCK = new StargateMilkyWayMemberBlock();
    public static final StargateUniverseMemberBlock STARGATE_UNIVERSE_MEMBER_BLOCK = new StargateUniverseMemberBlock();
    public static final StargateOrlinMemberBlock STARGATE_ORLIN_MEMBER_BLOCK = new StargateOrlinMemberBlock();
    public static final StargatePegasusMemberBlock STARGATE_PEGASUS_MEMBER_BLOCK = new StargatePegasusMemberBlock();
    public static final CapacitorBlockEmpty CAPACITOR_BLOCK_EMPTY = new CapacitorBlockEmpty();
    public static final CapacitorBlock CAPACITOR_BLOCK = new CapacitorBlock(false);
    public static final BeamerBlock BEAMER_BLOCK = new BeamerBlock();
    public static final TRPlatformBlock TR_PLATFORM_BLOCK = new TRPlatformBlock();
    public static final AssemblerBlock MACHINE_ASSEMBLER = new AssemblerBlock();
    public static final CrystalChamberBlock MACHINE_CHAMBER = new CrystalChamberBlock();
    public static final PCBFabricatorBlock MACHINE_PCB_FABRICATOR = new PCBFabricatorBlock();
    public static final OreWashingBlock MACHINE_ORE_WASHING = new OreWashingBlock();
    public static final ZPMBlock ZPM = new ZPMBlock(false);
    public static final ZPMHubBlock ZPM_HUB = new ZPMHubBlock();
    public static final ZPMSlotBlock ZPM_SLOT = new ZPMSlotBlock();
    public static final JSGBlock DECOR_CRYSTAL_BLOCK = (JSGBlock)BlockHelpers.createSimpleBlock("tokra_crystal_block", Material.field_151576_e, CreativeTabs.field_78030_b, JSGItems.CRYSTAL_TOKRA, 2, 4, 3).func_149711_c(1.5f).func_149715_a(11.0f);
    public static final DestinyCountDownBlock DESTINY_COUNTDOWN_BLOCK = new DestinyCountDownBlock();
    public static final AncientSignBlock ANCIENT_SIGN_BLOCK = new AncientSignBlock();
    public static final CapacitorBlockCreative CAPACITOR_BLOCK_CREATIVE = new CapacitorBlockCreative();
    public static final ZPMBlockCreative ZPM_CREATIVE = new ZPMBlockCreative();
    public static final JSGBlock[] RINGS_BLOCKS = new JSGBlock[]{TRANSPORT_RINGS_GOAULD_BLOCK, TRANSPORT_RINGS_ORI_BLOCK, TRANSPORT_RINGS_ANCIENT_BLOCK};
    public static final JSGBlock[] STARGATE_BASE_BLOCKS = new JSGBlock[]{STARGATE_PEGASUS_BASE_BLOCK, STARGATE_MILKY_WAY_BASE_BLOCK, STARGATE_UNIVERSE_BASE_BLOCK, STARGATE_ORLIN_BASE_BLOCK};
    public static final JSGBlock[] STARGATE_CLASSIC_BASE_BLOCKS = new JSGBlock[]{STARGATE_PEGASUS_BASE_BLOCK, STARGATE_MILKY_WAY_BASE_BLOCK, STARGATE_UNIVERSE_BASE_BLOCK};
    public static final JSGBlock[] CAMO_BLOCKS_BLACKLIST = new JSGBlock[]{CAPACITOR_BLOCK, CAPACITOR_BLOCK_EMPTY, DHD_PEGASUS_BLOCK, DHD_BLOCK, TR_CONTROLLER_GOAULD_BLOCK, TRANSPORT_RINGS_GOAULD_BLOCK, TRANSPORT_RINGS_ORI_BLOCK, TRANSPORT_RINGS_ANCIENT_BLOCK, TR_PLATFORM_BLOCK, BEAMER_BLOCK, MACHINE_ASSEMBLER, MACHINE_CHAMBER, ZPM, ZPM_HUB, ZPM_SLOT, CAPACITOR_BLOCK_CREATIVE, ZPM_CREATIVE};
    public static final JSGBlock[] BEAMER_BREAK_BLACKLIST = new JSGBlock[]{DHD_PEGASUS_BLOCK, DHD_BLOCK, BEAMER_BLOCK, STARGATE_MILKY_WAY_BASE_BLOCK, STARGATE_MILKY_WAY_MEMBER_BLOCK, STARGATE_UNIVERSE_BASE_BLOCK, STARGATE_UNIVERSE_MEMBER_BLOCK, STARGATE_PEGASUS_BASE_BLOCK, STARGATE_PEGASUS_MEMBER_BLOCK, STARGATE_ORLIN_BASE_BLOCK, STARGATE_ORLIN_MEMBER_BLOCK};
    public static final JSGBlock[] BLOCKS = new JSGBlock[]{ORE_NAQUADAH_BLOCK_STONE, ORE_NAQUADAH_BLOCK, ORE_TITANIUM_BLOCK, ORE_TRINIUM_BLOCK, NAQUADAH_BLOCK_RAW, NAQUADAH_BLOCK, TITANIUM_BLOCK, TRINIUM_BLOCK, STARGATE_MILKY_WAY_BASE_BLOCK, STARGATE_MILKY_WAY_MEMBER_BLOCK, STARGATE_UNIVERSE_BASE_BLOCK, STARGATE_UNIVERSE_MEMBER_BLOCK, STARGATE_PEGASUS_BASE_BLOCK, STARGATE_PEGASUS_MEMBER_BLOCK, STARGATE_ORLIN_BASE_BLOCK, STARGATE_ORLIN_MEMBER_BLOCK, DHD_BLOCK, DHD_PEGASUS_BLOCK, TRANSPORT_RINGS_GOAULD_BLOCK, TRANSPORT_RINGS_ORI_BLOCK, TRANSPORT_RINGS_ANCIENT_BLOCK, TR_CONTROLLER_GOAULD_BLOCK, TR_PLATFORM_BLOCK, CAPACITOR_BLOCK_EMPTY, CAPACITOR_BLOCK, BEAMER_BLOCK, INVISIBLE_BLOCK, IRIS_BLOCK, MACHINE_ASSEMBLER, MACHINE_CHAMBER, MACHINE_PCB_FABRICATOR, MACHINE_ORE_WASHING, ZPM, ZPM_HUB, ZPM_SLOT, DECOR_CRYSTAL_BLOCK, DESTINY_COUNTDOWN_BLOCK, ANCIENT_SIGN_BLOCK, CAPACITOR_BLOCK_CREATIVE, ZPM_CREATIVE};

    public static boolean isInBlocksArray(Block block, Block[] array) {
        for (Block b : array) {
            if (block != b) continue;
            return true;
        }
        return false;
    }

    public static void load() {
    }

    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.registerAll((IForgeRegistryEntry[])BLOCKS);
        for (JSGBlock block : BLOCKS) {
            if (!block.hasTileEntity(block.func_176223_P())) continue;
            Class<? extends TileEntity> tileEntityClass = block.getTileEntityClass();
            ResourceLocation key = block.getRegistryName();
            if (key == null || tileEntityClass == null) continue;
            GameRegistry.registerTileEntity(tileEntityClass, (ResourceLocation)key);
        }
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        for (JSGBlock block : BLOCKS) {
            if (block instanceof StargateClassicMemberBlock) {
                registry.register((IForgeRegistryEntry)((StargateClassicMemberBlock)block).getItemBlock());
                continue;
            }
            if (block instanceof JSGAbstractCustomItemBlock) {
                registry.register((IForgeRegistryEntry)((JSGAbstractCustomItemBlock)block).getItemBlock());
                continue;
            }
            if (block.getRegistryName() == null) continue;
            registry.register((IForgeRegistryEntry)((Item)new ItemBlock((Block)block).setRegistryName(block.getRegistryName())));
        }
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        for (JSGBlock block : BLOCKS) {
            Map<Integer, String> values;
            JSGBlock b;
            if (block instanceof StargateClassicMemberBlock) {
                b = (StargateClassicMemberBlock)block;
                values = ((StargateClassicMemberBlock)b).getAllMetaTypes();
                for (Integer meta : values.keySet()) {
                    ModelLoader.setCustomModelResourceLocation((Item)ItemBlock.func_150898_a((Block)b), (int)meta, (ModelResourceLocation)new ModelResourceLocation(values.get(meta)));
                }
                continue;
            }
            if (block instanceof JSGAbstractCustomMetaItemBlock) {
                b = (JSGAbstractCustomMetaItemBlock)block;
                values = ((JSGAbstractCustomMetaItemBlock)b).getAllMetaTypes();
                for (Integer meta : values.keySet()) {
                    ModelLoader.setCustomModelResourceLocation((Item)ItemBlock.func_150898_a((Block)b), (int)meta, (ModelResourceLocation)new ModelResourceLocation(values.get(meta)));
                }
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)ItemBlock.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(block.getRegistryName()), "inventory"));
        }
    }

    @Nullable
    public static Block remapBlock(String oldBlockName, boolean searchInRegistry) {
        switch (oldBlockName) {
            case "aunis:stargatebase_block": {
                return STARGATE_MILKY_WAY_BASE_BLOCK;
            }
            case "aunis:stargate_member_block": {
                return STARGATE_MILKY_WAY_MEMBER_BLOCK;
            }
            case "aunis:stargatebase_orlin_block": {
                return STARGATE_ORLIN_BASE_BLOCK;
            }
            case "aunis:stargatemember_orlin_block": {
                return STARGATE_ORLIN_MEMBER_BLOCK;
            }
            case "aunis:transportrings_block": {
                return TRANSPORT_RINGS_GOAULD_BLOCK;
            }
            case "aunis:transportrings_controller_block": {
                return TR_CONTROLLER_GOAULD_BLOCK;
            }
            case "jsg:stargate_assembler": 
            case "jsg:stargate_assembler_block": {
                return MACHINE_ASSEMBLER;
            }
            case "aunis:zpm": 
            case "aunis:zpmhub_block": 
            case "aunis:connector_zpm": 
            case "aunis:holder_zpm": 
            case "aunis:circuit_control_zpm": {
                return Blocks.field_150350_a;
            }
        }
        if (searchInRegistry && oldBlockName.startsWith("aunis:")) {
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("jsg", oldBlockName.replaceAll("aunis:", "")));
        }
        return null;
    }

    @SubscribeEvent
    public static void onMissingSoundMappings(RegistryEvent.MissingMappings<SoundEvent> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.toString().startsWith("aunis:") && !mapping.key.toString().startsWith("jsg:")) continue;
            mapping.ignore();
        }
    }

    @SubscribeEvent
    public static void onMissingEntityMappings(RegistryEvent.MissingMappings<EntityEntry> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.toString().startsWith("aunis:") && !mapping.key.toString().startsWith("jsg:")) continue;
            mapping.ignore();
        }
    }

    @SubscribeEvent
    public static void onMissingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            Block newBlock = JSGBlocks.remapBlock(mapping.key.toString(), true);
            if (newBlock == null) continue;
            mapping.remap((IForgeRegistryEntry)newBlock);
        }
    }

    @SubscribeEvent
    public static void onMissingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            Item newItem;
            String oldName = mapping.key.toString();
            if (oldName.startsWith("aunis:")) {
                newItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("jsg", oldName.replaceAll("aunis:", "")));
                if (newItem == null) {
                    newItem = ItemBlock.func_150898_a((Block)Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("jsg", oldName.replaceAll("aunis:", "")))));
                }
            } else {
                Block newBlock = JSGBlocks.remapBlock(oldName, false);
                newItem = newBlock != null ? ItemBlock.func_150898_a((Block)newBlock) : JSGItems.remapItem(oldName);
            }
            if (newItem == null) continue;
            mapping.remap((IForgeRegistryEntry)newItem);
        }
    }
}

