/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.beamer;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.block.stargate.StargateClassicBaseBlock;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.stargate.StargateSizeEnum;
import tauri.dev.jsg.tileentity.BeamerTile;
import tauri.dev.jsg.tileentity.stargate.StargateClassicBaseTile;
import tauri.dev.jsg.util.FacingHelper;
import tauri.dev.jsg.util.main.JSGProps;

public class BeamerLinkingHelper {
    private static final int SIDE = JSGConfig.Stargate.stargateSize != StargateSizeEnum.EXTRA_LARGE ? 2 : 4;
    private static final int DOWN = JSGConfig.Stargate.stargateSize != StargateSizeEnum.EXTRA_LARGE ? 6 : 9;

    public static void findGateInFrontAndLink(World world, BlockPos pos, EnumFacing blockFacing) {
        EnumFacing left = blockFacing.func_176735_f();
        EnumFacing right = blockFacing.func_176746_e();
        Iterable blocks = BlockPos.func_177975_b((BlockPos)pos.func_177967_a(left, SIDE).func_177979_c(DOWN).func_177967_a(blockFacing, 1), (BlockPos)pos.func_177967_a(right, SIDE).func_177977_b().func_177967_a(blockFacing, JSGConfig.Beamer.mechanics.reach));
        for (BlockPos.MutableBlockPos scanPos : blocks) {
            StargateClassicBaseTile gateTile;
            BlockPos vec;
            IBlockState state = world.func_180495_p((BlockPos)scanPos);
            if (!(state.func_177230_c() instanceof StargateClassicBaseBlock) || state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL) != blockFacing.func_176734_d()) continue;
            EnumFacing baseFacing = (EnumFacing)state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL);
            Rotation rotation = FacingHelper.getRotation(baseFacing);
            if (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) {
                rotation = rotation.func_185830_a(Rotation.CLOCKWISE_180);
            }
            if (Math.abs((vec = pos.func_177973_b((Vec3i)scanPos).func_190942_a(rotation)).func_177958_n()) == 2 && (vec.func_177956_o() == 1 || vec.func_177956_o() == 6) || !(gateTile = (StargateClassicBaseTile)world.func_175625_s((BlockPos)scanPos)).isMerged()) continue;
            ((BeamerTile)world.func_175625_s(pos)).setLinkedGate((BlockPos)scanPos, vec);
            gateTile.addLinkedBeamer(pos);
        }
    }

    public static void findBeamersInFront(World world, BlockPos pos, EnumFacing blockFacing) {
        EnumFacing left = blockFacing.func_176735_f();
        EnumFacing right = blockFacing.func_176746_e();
        Iterable blocks = BlockPos.func_177975_b((BlockPos)pos.func_177967_a(left, SIDE).func_177981_b(DOWN).func_177967_a(blockFacing, 1), (BlockPos)pos.func_177967_a(right, SIDE).func_177984_a().func_177967_a(blockFacing, 9));
        for (BlockPos.MutableBlockPos scanPos : blocks) {
            BlockPos vec;
            IBlockState state = world.func_180495_p((BlockPos)scanPos);
            if (state.func_177230_c() != JSGBlocks.BEAMER_BLOCK || state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL) != blockFacing.func_176734_d()) continue;
            EnumFacing beamerFacing = (EnumFacing)state.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL);
            Rotation rotation = FacingHelper.getRotation(beamerFacing);
            if (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) {
                rotation = rotation.func_185830_a(Rotation.CLOCKWISE_180);
            }
            if (Math.abs((vec = scanPos.func_177973_b((Vec3i)pos).func_190942_a(rotation)).func_177958_n()) == 2 && (vec.func_177956_o() == 1 || vec.func_177956_o() == 6)) continue;
            ((BeamerTile)world.func_175625_s((BlockPos)scanPos)).setLinkedGate(pos, vec);
            ((StargateClassicBaseTile)world.func_175625_s(pos)).addLinkedBeamer((BlockPos)scanPos);
        }
    }
}

