/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.beamer;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityBeaconRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import tauri.dev.jsg.beamer.BeamerModeEnum;
import tauri.dev.jsg.beamer.BeamerRoleEnum;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.tileentity.BeamerTile;
import tauri.dev.jsg.util.FacingHelper;
import tauri.dev.jsg.util.FluidColors;
import tauri.dev.jsg.util.JSGAxisAlignedBB;
import tauri.dev.jsg.util.JSGTextureLightningHelper;
import tauri.dev.jsg.util.main.JSGDamageSources;

public class BeamerBeam {
    public float angleX;
    public float angleY;
    public double beamLength;
    public float beamRadius;
    public float beamMaxRadius;

    public BeamerBeam(float angleX, float angleY, double beamLength, float beamRadius) {
        this(angleX, angleY, beamLength, beamRadius, beamRadius);
    }

    public BeamerBeam(float angleX, float angleY, double beamLength, float beamRadius, float beamMaxRadius) {
        this.angleX = angleX;
        this.angleY = angleY;
        this.beamLength = beamLength;
        this.beamRadius = beamRadius;
        this.beamMaxRadius = beamMaxRadius;
    }

    @Nonnull
    public static BeamerBeam getBeam(int offsetZFromTarget, int offsetZTargetFromGate, int offsetXFromTarget, int offsetYFromTarget, float beamRadius, float beamMaxRadius, @Nonnull EnumFacing facing) {
        double t1 = (double)offsetXFromTarget / (double)offsetZFromTarget;
        double angY = Math.toDegrees(Math.atan(t1));
        double beamerLengthTemp = Math.sqrt(Math.pow(offsetZFromTarget, 2.0) + Math.pow(offsetXFromTarget, 2.0));
        double t2 = (double)offsetYFromTarget / beamerLengthTemp;
        double angX = Math.toDegrees(Math.atan(t2));
        double beamerLength = Math.sqrt(Math.pow(beamerLengthTemp, 2.0) + Math.pow(offsetYFromTarget, 2.0)) - (double)offsetZTargetFromGate;
        if (beamerLength < 0.0) {
            beamerLength = -beamerLength;
        }
        return new BeamerBeam((float)angX * -1.0f, (float)angY * (float)(facing == EnumFacing.SOUTH || facing == EnumFacing.WEST ? -1 : 1), beamerLength += 0.2, beamRadius, beamMaxRadius);
    }

    public static boolean isSomethingInBeam(BeamerTile beamer, boolean destroyBlocks, boolean hitEntities) {
        if (!JSGConfig.Beamer.mechanics.damageEntities) {
            hitEntities = false;
        }
        if (!JSGConfig.Beamer.mechanics.destroyBlocks) {
            destroyBlocks = false;
        }
        boolean debug = false;
        BlockPos pos = beamer.func_174877_v();
        World world = beamer.func_145831_w();
        EnumFacing facing = beamer.getFacing();
        int beamXOffset = beamer.beamOffsetFromTargetX;
        int beamYOffset = beamer.beamOffsetFromTargetY;
        int beamZOffset = beamer.beamOffsetFromTargetZ;
        int targetOffset = beamer.beamOffsetFromGateTarget;
        int currentOffsetFromGate = beamZOffset - targetOffset;
        if (currentOffsetFromGate < 0) {
            currentOffsetFromGate *= -1;
        }
        for (int off = 1; off < currentOffsetFromGate; ++off) {
            BeamerBeam beam = BeamerBeam.getBeam(beamZOffset, targetOffset, beamXOffset, beamYOffset, -1.0f, -1.0f, beamer.getFacing());
            double lengthXZ = (double)off / Math.cos(Math.toRadians(beam.angleY));
            double offX = Math.tan(Math.toRadians(beam.angleY)) * (double)off;
            double offY = Math.tan(Math.toRadians(beam.angleX)) * lengthXZ;
            for (int i = 0; i < 9; ++i) {
                double y = i < 3 ? Math.ceil(offY) : (i < 6 ? (double)Math.round(offY) : Math.floor(offY));
                double x = i % 3 == 0 ? Math.floor(offX) : ((i - 1) % 3 == 0 ? (double)Math.round(offX) : Math.ceil(offX));
                BlockPos stepPos = new BlockPos(x, y, (double)off).func_190942_a(FacingHelper.getRotation(facing));
                if ((stepPos = stepPos.func_177971_a((Vec3i)pos)).equals((Object)pos)) continue;
                Block targetBlock = world.func_180495_p(stepPos).func_177230_c();
                IBlockState targetBlockState = world.func_180495_p(stepPos);
                if (!debug) {
                    if (destroyBlocks && !JSGBlocks.isInBlocksArray(targetBlock, JSGBlocks.BEAMER_BREAK_BLACKLIST) && targetBlockState.func_185887_b(world, stepPos) >= 0.0f) {
                        world.func_175698_g(stepPos);
                    } else if (!destroyBlocks && (!targetBlock.isAir(targetBlockState, (IBlockAccess)world, pos) && !targetBlock.func_176200_f((IBlockAccess)world, pos) && targetBlockState.func_185914_p() || targetBlock == JSGBlocks.IRIS_BLOCK)) {
                        return true;
                    }
                } else {
                    world.func_175656_a(stepPos, Blocks.field_150348_b.func_176223_P());
                }
                if (!hitEntities || world.func_82737_E() % 20L != 0L) continue;
                List entities = world.func_72872_a(Entity.class, (AxisAlignedBB)new JSGAxisAlignedBB(stepPos.func_177982_a(-1, -1, -1), stepPos.func_177982_a(1, 1, 1)));
                for (Entity entity : entities) {
                    entity.func_70097_a(JSGDamageSources.DAMAGE_BEAMER, (float)(beamer.getMode() == BeamerModeEnum.LASER ? 5 : 2));
                }
            }
        }
        return false;
    }

    public void render(float partialTicks, long tick, BeamerRoleEnum teRole, float[] colors, boolean transferringFluid, Fluid lastFluidTransferred) {
        FluidColors.FloatColors fluidColors;
        if (transferringFluid && JSGConfig.Beamer.visual.enableFluidBeamColorization && lastFluidTransferred != null && (fluidColors = FluidColors.getAverageColor(lastFluidTransferred)) != null) {
            colors = fluidColors.colors;
        }
        GlStateManager.func_179114_b((float)this.angleY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-90.0f + this.angleX), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        JSGTextureLightningHelper.lightUpTexture(1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TileEntityBeaconRenderer.field_147523_b);
        float lengthAnimCoefficient = this.beamRadius / this.beamMaxRadius;
        BeamerBeam.renderBeamSegment(partialTicks, teRole == BeamerRoleEnum.TRANSMIT ? 1 : -1, tick, this.beamLength * (double)lengthAnimCoefficient, colors, this.beamRadius, this.beamRadius + 0.05f);
    }

    private static void renderBeamSegment(double partialTicks, double textureScale, double totalWorldTime, double height, float[] colors, double beamRadius, double glowRadius) {
        GlStateManager.func_179094_E();
        JSGTextureLightningHelper.lightUpTexture(1.0f);
        double i = 0.0 + height;
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        double d0 = totalWorldTime + partialTicks;
        double d1 = height < 0.0 ? d0 : -d0;
        double d2 = MathHelper.func_181162_h((double)(d1 * 0.2 - (double)MathHelper.func_76128_c((double)(d1 * 0.1))));
        float f = colors[0];
        float f1 = colors[1];
        float f2 = colors[2];
        double d3 = d0 * 0.025 * -1.5;
        double d4 = 0.5 + Math.cos(d3 + 2.356194490192345) * beamRadius;
        double d5 = 0.5 + Math.sin(d3 + 2.356194490192345) * beamRadius;
        double d6 = 0.5 + Math.cos(d3 + 0.7853981633974483) * beamRadius;
        double d7 = 0.5 + Math.sin(d3 + 0.7853981633974483) * beamRadius;
        double d8 = 0.5 + Math.cos(d3 + 3.9269908169872414) * beamRadius;
        double d9 = 0.5 + Math.sin(d3 + 3.9269908169872414) * beamRadius;
        double d10 = 0.5 + Math.cos(d3 + 5.497787143782138) * beamRadius;
        double d11 = 0.5 + Math.sin(d3 + 5.497787143782138) * beamRadius;
        double d13 = -1.0 + d2;
        double d14 = -1.0 + d2;
        double d15 = height * textureScale * (0.5 / beamRadius) + d14;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-0.5 + d4, -0.3 + i, -0.5 + d5).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d4, -0.3, -0.5 + d5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d6, -0.3, -0.5 + d7).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d6, -0.3 + i, -0.5 + d7).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d10, -0.3 + i, -0.5 + d11).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d10, -0.3, -0.5 + d11).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d8, -0.3, -0.5 + d9).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d8, -0.3 + i, -0.5 + d9).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d6, -0.3 + i, -0.5 + d7).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d6, -0.3, -0.5 + d7).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d10, -0.3, -0.5 + d11).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d10, -0.3 + i, -0.5 + d11).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d8, -0.3 + i, -0.5 + d9).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d8, -0.3, -0.5 + d9).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d4, -0.3, -0.5 + d5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d4, -0.3 + i, -0.5 + d5).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179132_a((boolean)false);
        d3 = 0.5 - glowRadius;
        d4 = 0.5 - glowRadius;
        d5 = 0.5 + glowRadius;
        d6 = 0.5 - glowRadius;
        d7 = 0.5 - glowRadius;
        d8 = 0.5 + glowRadius;
        d9 = 0.5 + glowRadius;
        d10 = 0.5 + glowRadius;
        d14 = height * textureScale + d13;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b(-0.5 + d3, -0.3 + i, -0.5 + d4).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d3, -0.3, -0.5 + d4).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d5, -0.3, -0.5 + d6).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d5, -0.3 + i, -0.5 + d6).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d9, -0.3 + i, -0.5 + d10).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d9, -0.3, -0.5 + d10).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d7, -0.3, -0.5 + d8).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d7, -0.3 + i, -0.5 + d8).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d5, -0.3 + i, -0.5 + d6).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d5, -0.3, -0.5 + d6).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d9, -0.3, -0.5 + d10).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d9, -0.3 + i, -0.5 + d10).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d7, -0.3 + i, -0.5 + d8).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d7, -0.3, -0.5 + d8).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d3, -0.3, -0.5 + d4).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5 + d3, -0.3 + i, -0.5 + d4).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }
}

