/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg;

import java.io.File;
import java.io.IOException;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import org.apache.logging.log4j.Logger;
import tauri.dev.jsg.block.JSGBlocks;
import tauri.dev.jsg.command.JSGCommands;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.stargate.StargateDimensionConfig;
import tauri.dev.jsg.integration.OCWrapperInterface;
import tauri.dev.jsg.loader.ReloadListener;
import tauri.dev.jsg.proxy.IProxy;
import tauri.dev.jsg.util.main.loader.JSGInit;
import tauri.dev.jsg.util.main.loader.JSGPreInit;

@Mod(modid="jsg", name="Just Stargate Mod", version="1.12.2-4.11.0.8", acceptedMinecraftVersions="1.12.2", dependencies="after:cofhcore@[4.6.0,);after:opencomputers;after:thermalexpansion;after:tconstruct;after:fluidlogged_api")
@Mod.EventBusSubscriber
public class JSG {
    public static final String MOD_ID = "jsg";
    public static final String MOD_NAME = "Just Stargate Mod";
    public static final String MOD_VERSION = "1.12.2-4.11.0.8";
    public static final int DATA_VERSION = 25;
    public static final String CONFIG_GENERAL_VERSION = "3.1";
    public static final String CONFIG_CRAFTINGS_VERSION = "1.1";
    public static final String CONFIG_STRUCTURES_VERSION = "1.0";
    public static final String CONFIG_DIMENSIONS_VERSION = "1.1";
    public static final String MC_VERSION = "1.12.2";
    public static final String CLIENT = "tauri.dev.jsg.proxy.ProxyClient";
    public static final String SERVER = "tauri.dev.jsg.proxy.ProxyServer";
    public static final String AGS_DEFAULT_PATH = "pastebin run pAqHB264";
    public static SoundCategory JSG_SOUNDS;
    public static Logger logger;
    public static File modConfigDir;
    public static OCWrapperInterface ocWrapper;
    public static File clientModPath;
    public static File modsDirectory;
    @SidedProxy(clientSide="tauri.dev.jsg.proxy.ProxyClient", serverSide="tauri.dev.jsg.proxy.ProxyServer")
    public static IProxy proxy;
    @Mod.Instance(value="jsg")
    public static JSG instance;
    public static final String[] WELCOME_MESS;
    public static BlockPos lastPlayerPosInWorld;

    public static void displayWelcomeMessage() {
        for (String s : WELCOME_MESS) {
            JSG.info(s);
        }
    }

    public static void info(String string) {
        logger.info(string);
    }

    public static void info(Object ... o) {
        logger.info((Object)o);
    }

    public static void info(String string, Exception e) {
        logger.info(string, (Throwable)e);
    }

    public static void warn(String string) {
        logger.warn(string);
        ++ReloadListener.LoadingStats.warnings;
    }

    public static void warn(Object ... p) {
        logger.warn((Object)p);
        ++ReloadListener.LoadingStats.warnings;
    }

    public static void warn(String string, Exception e) {
        logger.warn(string, (Throwable)e);
        ++ReloadListener.LoadingStats.warnings;
    }

    public static void error(String string) {
        logger.error(string);
        ++ReloadListener.LoadingStats.errors;
    }

    public static void error(Object ... o) {
        logger.error((Object)o);
        ++ReloadListener.LoadingStats.errors;
    }

    public static void error(String string, Exception e) {
        logger.error(string, (Throwable)e);
        ++ReloadListener.LoadingStats.errors;
    }

    public static void debug(String string) {
        logger.debug(string);
        if (JSGConfig.General.debug.logDebugAsInfo) {
            JSG.info("[DEBUG] " + string);
        }
    }

    public static void debug(Object ... o) {
        logger.debug((Object)o);
        if (JSGConfig.General.debug.logDebugAsInfo) {
            JSG.info("[DEBUG] ", o);
        }
    }

    public static void debug(String string, Exception e) {
        logger.debug(string, (Throwable)e);
        if (JSGConfig.General.debug.logDebugAsInfo) {
            JSG.info("[DEBUG] " + string, e);
        }
    }

    public static String getInProgress() {
        return TextFormatting.AQUA + "Work In Progress Item!";
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        JSGBlocks.load();
        JSGPreInit.preInit(event);
        proxy.preInit(event);
        Runtime.getRuntime().addShutdownHook(new Thread(JSG::shutDown));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) throws IOException {
        if (Loader.isModLoaded((String)"aunis")) {
            Loader.instance().runtimeDisableMod("aunis");
            throw new LoaderException("Found two same mods! Just Stargate Mod and The Aunis mod are the SAME mods!");
        }
        JSGInit.init(event);
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        JSG.info("Just Stargate Mod loading completed!");
        proxy.loadCompleted();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        JSGCommands.registerCommands(event);
        JSG.info("Successfully registered Commands!");
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) throws IOException {
        StargateDimensionConfig.update();
        JSG.info("Server started!");
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
    }

    public static void shutDown() {
        proxy.shutDown();
        JSG.info("Good bye! Thank you for using Just Stargate Mod :)");
    }

    static {
        WELCOME_MESS = new String[]{"=======================================", "   $$$$$\\  $$$$$$\\   $$$$$$\\", "   \\__$$ |$$  __$$\\ $$  __$$\\", "      $$ |$$ /  \\__|$$ /  \\__|", "      $$ |\\$$$$$$\\  $$ |$$$$\\", "$$\\   $$ | \\____$$\\ $$ |\\_$$ |", "$$ |  $$ |$$\\   $$ |$$ |  $$ |", "\\$$$$$$  |\\$$$$$$  |\\$$$$$$  |", " \\______/  \\______/  \\______/", "", " Authors: MineDragonCZ_, matousss, Fredyman_95, MrJake222", " Wiki: https://justsgmod.eu/wiki", " Version: 1.12.2-4.11.0.8", "======================================="};
        FluidRegistry.enableUniversalBucket();
        lastPlayerPosInWorld = new BlockPos(0, 0, 0);
    }
}

