/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.particle;

import com.teammetallurgy.atum.client.particle.IAtumParticleFactory;
import com.teammetallurgy.atum.client.particle.ParticleBase;
import javax.annotation.Nonnull;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="atum", value={Side.CLIENT})
public class ParticleSwirl
extends ParticleBase {
    private static final ResourceLocation ANUBIS = new ResourceLocation("atum", "particle/anubis");
    private static final ResourceLocation ANUBIS_SKULL = new ResourceLocation("atum", "particle/anubis_skull");
    private static final ResourceLocation GAS = new ResourceLocation("atum", "particle/gas");
    private static final ResourceLocation GEB = new ResourceLocation("atum", "particle/geb");
    private static final ResourceLocation HORUS = new ResourceLocation("atum", "particle/shu");
    private static final ResourceLocation ISIS = new ResourceLocation("atum", "particle/isis");
    private static final ResourceLocation NUIT_BLACK = new ResourceLocation("atum", "particle/nuit_black");
    private static final ResourceLocation NUIT_WHITE = new ResourceLocation("atum", "particle/nuit_white");
    private static final ResourceLocation SHU = new ResourceLocation("atum", "particle/shu");
    private float scale;

    protected ParticleSwirl(World world, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed) {
        super(world, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed);
        this.field_187129_i = this.field_187129_i * (double)0.01f + xSpeed;
        this.field_187130_j = this.field_187130_j * (double)0.01f + ySpeed;
        this.field_187131_k = this.field_187131_k * (double)0.01f + zSpeed;
        this.field_187126_f += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.field_187127_g += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.field_187128_h += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.scale = this.field_70544_f;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
    }

    public void func_187110_a(double x, double y, double z) {
        this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        this.func_187118_j();
    }

    public void func_180434_a(BufferBuilder buffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float f = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        this.field_70544_f = this.scale * (1.0f - f * f * 0.5f);
        super.func_180434_a(buffer, entity, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= (double)0.96f;
        this.field_187130_j *= (double)0.96f;
        this.field_187131_k *= (double)0.96f;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        ParticleSwirl.registerSprite(ANUBIS);
        ParticleSwirl.registerSprite(ANUBIS_SKULL);
        ParticleSwirl.registerSprite(GAS);
        ParticleSwirl.registerSprite(GEB);
        ParticleSwirl.registerSprite(HORUS);
        ParticleSwirl.registerSprite(ISIS);
        ParticleSwirl.registerSprite(NUIT_BLACK);
        ParticleSwirl.registerSprite(NUIT_WHITE);
        ParticleSwirl.registerSprite(SHU);
    }

    @SideOnly(value=Side.CLIENT)
    public static class Shu
    implements IAtumParticleFactory {
        @Override
        public Particle createParticle(String name, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleSwirl particle = new ParticleSwirl(world, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.func_187117_a(ParticleBase.getSprite(SHU));
            return particle;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class NuitWhite
    implements IAtumParticleFactory {
        @Override
        public Particle createParticle(String name, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleSwirl particle = new ParticleSwirl(world, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.func_187117_a(ParticleBase.getSprite(NUIT_WHITE));
            return particle;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class NuitBlack
    implements IAtumParticleFactory {
        @Override
        public Particle createParticle(String name, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleSwirl particle = new ParticleSwirl(world, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.func_187117_a(ParticleBase.getSprite(NUIT_BLACK));
            return particle;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Isis
    implements IAtumParticleFactory {
        @Override
        public Particle createParticle(String name, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleSwirl particle = new ParticleSwirl(world, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.func_187117_a(ParticleBase.getSprite(ISIS));
            particle.scale = 0.6f;
            return particle;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Horus
    implements IAtumParticleFactory {
        @Override
        public Particle createParticle(String name, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleSwirl particle = new ParticleSwirl(world, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.func_187117_a(ParticleBase.getSprite(HORUS));
            return particle;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Geb
    implements IAtumParticleFactory {
        @Override
        public Particle createParticle(String name, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleSwirl particle = new ParticleSwirl(world, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.func_187117_a(ParticleBase.getSprite(GEB));
            return particle;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Gas
    implements IAtumParticleFactory {
        @Override
        public Particle createParticle(String name, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleSwirl particle = new ParticleSwirl(world, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.func_187117_a(ParticleBase.getSprite(GAS));
            particle.scale = 0.8f;
            return particle;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class AnubisSkull
    implements IAtumParticleFactory {
        @Override
        public Particle createParticle(String name, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleSwirl particle = new ParticleSwirl(world, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.func_187117_a(ParticleBase.getSprite(ANUBIS_SKULL));
            return particle;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Anubis
    implements IAtumParticleFactory {
        @Override
        public Particle createParticle(String name, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleSwirl particle = new ParticleSwirl(world, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.func_187117_a(ParticleBase.getSprite(ANUBIS));
            return particle;
        }
    }
}

