/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.wood;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.blocks.base.BlockAtumSlab;
import com.teammetallurgy.atum.blocks.wood.BlockAtumPlank;
import com.teammetallurgy.atum.items.ItemAtumSlab;
import com.teammetallurgy.atum.utils.AtumRegistry;
import com.teammetallurgy.atum.utils.IOreDictEntry;
import com.teammetallurgy.atum.utils.OreDictHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockAtumWoodSlab
extends BlockAtumSlab
implements IOreDictEntry {
    private static final Map<BlockAtumPlank.WoodType, Block> SLABS = Maps.newEnumMap(BlockAtumPlank.WoodType.class);
    private final BlockAtumPlank.WoodType type;

    private BlockAtumWoodSlab(BlockAtumPlank.WoodType type) {
        super(Material.field_151575_d);
        this.type = type;
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.field_149783_u = true;
    }

    @Nonnull
    public MapColor func_180659_g(IBlockState state, IBlockAccess blockAccess, BlockPos blockPos) {
        return this.type.getMapColor();
    }

    public static void registerSlabs() {
        for (BlockAtumPlank.WoodType type : BlockAtumPlank.WoodType.values()) {
            BlockAtumWoodSlab woodSlab = new BlockAtumWoodSlab(type);
            SLABS.put(type, woodSlab);
            AtumRegistry.registerBlock((Block)woodSlab, (Item)new ItemAtumSlab(woodSlab, woodSlab), type.func_176610_l() + "_slab");
        }
    }

    public static Block getSlab(BlockAtumPlank.WoodType type) {
        return SLABS.get((Object)type);
    }

    @Override
    public void getOreDictEntries() {
        OreDictHelper.add(this, "slabWood");
    }
}

