/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.thaumicjei.event;

import com.buuz135.thaumicjei.ThaumcraftJEIPlugin;
import com.buuz135.thaumicjei.category.IHasResearch;
import com.buuz135.thaumicjei.config.ThaumicConfig;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.research.ResearchEvent;

@Mod.EventBusSubscriber(modid="thaumicjei", value={Side.CLIENT})
public class ResearchManager {
    private static int timeToSync = -1;

    @SubscribeEvent
    public static void onResearch(ResearchEvent.Research event) {
        Minecraft.func_71410_x().func_152344_a(() -> ResearchManager.sync(event.getResearchKey()));
    }

    @SubscribeEvent
    public static void onJoin(WorldEvent.Load event) {
        if (event.getWorld() instanceof WorldClient) {
            timeToSync = 20;
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (timeToSync >= 0 && event.phase == TickEvent.Phase.END) {
            if (timeToSync == 0) {
                ResearchManager.sync("");
            }
            --timeToSync;
        }
    }

    private static void sync(String current) {
        if (!ThaumicConfig.hideRecipesIfMissingResearch) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null || ThaumcraftJEIPlugin.runtime == null) {
            timeToSync = 20;
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g.hasCapability(ThaumcraftCapabilities.KNOWLEDGE, null)) {
            for (String uuid : new String[]{ThaumcraftJEIPlugin.arcaneWorkbenchCategory.getUid(), ThaumcraftJEIPlugin.crucibleCategory.getUid(), ThaumcraftJEIPlugin.infusionCategory.getUid()}) {
                if (ThaumcraftJEIPlugin.runtime.getRecipeRegistry().getRecipeCategory(uuid) == null) continue;
                for (Object o : ThaumcraftJEIPlugin.runtime.getRecipeRegistry().getRecipeWrappers(ThaumcraftJEIPlugin.runtime.getRecipeRegistry().getRecipeCategory(uuid))) {
                    if (o == null) continue;
                    ThaumcraftJEIPlugin.runtime.getRecipeRegistry().hideRecipe((IRecipeWrapper)o, uuid);
                }
            }
            IPlayerKnowledge knowledge = (IPlayerKnowledge)Minecraft.func_71410_x().field_71439_g.getCapability(ThaumcraftCapabilities.KNOWLEDGE, null);
            if (knowledge == null) {
                timeToSync = 100;
                return;
            }
            for (IRecipeWrapper recipeWrapper : ThaumcraftJEIPlugin.recipes.keySet()) {
                if (!(recipeWrapper instanceof IHasResearch)) continue;
                boolean hasAll = true;
                block3: for (String research : ((IHasResearch)recipeWrapper).getResearch()) {
                    for (String subResearch : research.split("&&")) {
                        if (current.equalsIgnoreCase(subResearch) || knowledge.isResearchComplete(subResearch)) continue;
                        hasAll = false;
                        continue block3;
                    }
                }
                if (!hasAll) continue;
                ThaumcraftJEIPlugin.runtime.getRecipeRegistry().unhideRecipe(recipeWrapper, ThaumcraftJEIPlugin.recipes.get(recipeWrapper));
            }
        }
    }
}

