/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.detail;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import wile.engineersdecor.ModEngineersDecor;

public class Networking {
    private static SimpleNetworkWrapper snw = null;

    public static void init() {
        if (snw != null) {
            return;
        }
        int discr = -1;
        snw = NetworkRegistry.INSTANCE.newSimpleChannel("engineersdecor");
        snw.registerMessage(PacketTileNotify.ServerHandler.class, PacketTileNotify.class, ++discr, Side.SERVER);
        snw.registerMessage(PacketTileNotify.ClientHandler.class, PacketTileNotify.class, ++discr, Side.CLIENT);
    }

    public static class PacketTileNotify
    implements IMessage {
        NBTTagCompound nbt = null;
        BlockPos pos = BlockPos.field_177992_a;

        public static void sendToServer(TileEntity te, NBTTagCompound nbt) {
            if (te != null && nbt != null) {
                snw.sendToServer((IMessage)new PacketTileNotify(te, nbt));
            }
        }

        public static void sendToPlayer(EntityPlayer player, TileEntity te, NBTTagCompound nbt) {
            if (player instanceof EntityPlayerMP && te != null && nbt != null) {
                snw.sendTo((IMessage)new PacketTileNotify(te, nbt), (EntityPlayerMP)player);
            }
        }

        public PacketTileNotify(TileEntity te, NBTTagCompound nbt) {
            this.nbt = nbt;
            this.pos = te.func_174877_v();
        }

        public PacketTileNotify() {
        }

        public void fromBytes(ByteBuf buf) {
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeLong(this.pos.func_177986_g());
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
        }

        public static class ClientHandler
        implements IMessageHandler<PacketTileNotify, IMessage> {
            public IMessage onMessage(PacketTileNotify pkt, MessageContext ctx) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    try {
                        World world = ModEngineersDecor.proxy.getWorlClientSide();
                        if (!(world instanceof World)) {
                            return;
                        }
                        TileEntity te = world.func_175625_s(pkt.pos);
                        if (!(te instanceof IPacketReceiver)) {
                            return;
                        }
                        ((IPacketReceiver)te).onServerPacketReceived(pkt.nbt);
                    }
                    catch (Throwable ex) {
                        ModEngineersDecor.logger.error("Failed to process TE notify packet: " + ex.getMessage());
                    }
                });
                return null;
            }
        }

        public static class ServerHandler
        implements IMessageHandler<PacketTileNotify, IMessage> {
            public IMessage onMessage(PacketTileNotify pkt, MessageContext ctx) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
                world.func_152344_a(() -> ServerHandler.lambda$onMessage$0(world, pkt, (EntityPlayer)player));
                return null;
            }

            private static /* synthetic */ void lambda$onMessage$0(WorldServer world, PacketTileNotify pkt, EntityPlayer player) {
                try {
                    if (!world.func_175667_e(pkt.pos)) {
                        return;
                    }
                    TileEntity te = world.func_175625_s(pkt.pos);
                    if (!(te instanceof IPacketReceiver)) {
                        return;
                    }
                    ((IPacketReceiver)te).onClientPacketReceived(player, pkt.nbt);
                }
                catch (Throwable ex) {
                    ModEngineersDecor.logger.error("Failed to process TE notify packet: " + ex.getMessage());
                }
            }
        }
    }

    public static interface IPacketReceiver {
        default public void onServerPacketReceived(NBTTagCompound nbt) {
        }

        default public void onClientPacketReceived(EntityPlayer player, NBTTagCompound nbt) {
        }
    }
}

