/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.detail;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorBreaker;
import wile.engineersdecor.blocks.BlockDecorChair;
import wile.engineersdecor.blocks.BlockDecorCraftingTable;
import wile.engineersdecor.blocks.BlockDecorDropper;
import wile.engineersdecor.blocks.BlockDecorFloorGrating;
import wile.engineersdecor.blocks.BlockDecorFluidFunnel;
import wile.engineersdecor.blocks.BlockDecorFurnace;
import wile.engineersdecor.blocks.BlockDecorFurnaceElectrical;
import wile.engineersdecor.blocks.BlockDecorHalfSlab;
import wile.engineersdecor.blocks.BlockDecorHopper;
import wile.engineersdecor.blocks.BlockDecorHorizontalSupport;
import wile.engineersdecor.blocks.BlockDecorLadder;
import wile.engineersdecor.blocks.BlockDecorMilker;
import wile.engineersdecor.blocks.BlockDecorMineralSmelter;
import wile.engineersdecor.blocks.BlockDecorPassiveFluidAccumulator;
import wile.engineersdecor.blocks.BlockDecorPipeValve;
import wile.engineersdecor.blocks.BlockDecorPlacer;
import wile.engineersdecor.blocks.BlockDecorSlab;
import wile.engineersdecor.blocks.BlockDecorSolarPanel;
import wile.engineersdecor.blocks.BlockDecorStairs;
import wile.engineersdecor.blocks.BlockDecorStraightPole;
import wile.engineersdecor.blocks.BlockDecorTreeCutter;
import wile.engineersdecor.blocks.BlockDecorWall;
import wile.engineersdecor.blocks.BlockDecorWasteIncinerator;
import wile.engineersdecor.blocks.BlockDecorWindow;
import wile.engineersdecor.detail.ModAuxiliaries;
import wile.engineersdecor.detail.ModRecipes;

@Config(modid="engineersdecor")
@Config.LangKey(value="engineersdecor.config.title")
public class ModConfig {
    @Config.Comment(value={"Allows disabling specific features."})
    @Config.Name(value="Feature opt-outs")
    public static final SettingsOptouts optout = new SettingsOptouts();
    @Config.Comment(value={"Settings for beta testing and trouble shooting. Some of the settings may be moved to other categories after testing."})
    @Config.Name(value="Miscellaneous")
    public static final SettingsZTesting zmisc = new SettingsZTesting();
    @Config.Comment(value={"Tweaks and block behaviour adaptions."})
    @Config.Name(value="Tweaks")
    public static final SettingsTweaks tweaks = new SettingsTweaks();
    private static final ArrayList<String> includes_ = new ArrayList();
    private static final ArrayList<String> excludes_ = new ArrayList();
    private static final NBTTagCompound server_config_ = new NBTTagCompound();

    public static final void onPreInit() {
        ModConfig.startup_apply();
    }

    public static final void onPostInit(FMLPostInitializationEvent event) {
        for (Block e : ModContent.getRegisteredBlocks()) {
            ModConfig.isOptedOut(e, true);
        }
        ModConfig.apply();
    }

    public static final NBTTagCompound getServerConfig() {
        return server_config_;
    }

    public static final boolean isWithoutOptOutRegistration() {
        return zmisc != null && ModConfig.zmisc.without_optout_registration;
    }

    public static final boolean isWithoutRecipes() {
        return zmisc == null || ModConfig.zmisc.without_recipes;
    }

    public static boolean noToolTips() {
        return ModConfig.optout.without_tooltips;
    }

    public static final boolean isOptedOut(@Nullable Block block) {
        return ModConfig.isOptedOut(block, false);
    }

    public static final boolean isOptedOut(@Nullable Block block, boolean with_log_details) {
        if (block == null || optout == null) {
            return true;
        }
        if (block == ModContent.SIGN_MODLOGO) {
            return true;
        }
        if (!ModConfig.zmisc.with_experimental && block instanceof ModAuxiliaries.IExperimentalFeature) {
            return true;
        }
        String rn = block.getRegistryName().func_110623_a();
        try {
            for (String e : includes_) {
                if (!rn.matches(e)) continue;
                if (with_log_details) {
                    ModEngineersDecor.logger.info("Optout force include: " + rn);
                }
                return false;
            }
            for (String e : excludes_) {
                if (!rn.matches(e)) continue;
                if (with_log_details) {
                    ModEngineersDecor.logger.info("Optout force exclude: " + rn);
                }
                return true;
            }
        }
        catch (Throwable ex) {
            ModEngineersDecor.logger.error("optout include pattern failed, disabling.");
            includes_.clear();
            excludes_.clear();
        }
        if (block instanceof BlockDecorHalfSlab) {
            return ModConfig.optout.without_halfslabs;
        }
        if (block instanceof BlockDecorLadder) {
            return ModConfig.optout.without_ladders;
        }
        if (block instanceof BlockDecorWindow) {
            return ModConfig.optout.without_windows;
        }
        if (block instanceof BlockDecorHorizontalSupport) {
            return ModConfig.optout.without_hsupports;
        }
        if (block instanceof BlockDecorFloorGrating) {
            return ModConfig.optout.without_floor_grating;
        }
        if (block instanceof BlockDecorCraftingTable) {
            return ModConfig.optout.without_crafting_table;
        }
        if (block instanceof BlockDecorFurnaceElectrical) {
            return ModConfig.optout.without_electrical_furnace;
        }
        if (block instanceof BlockDecorFurnace && !(block instanceof BlockDecorFurnaceElectrical)) {
            return ModConfig.optout.without_lab_furnace;
        }
        if (block instanceof BlockDecorPassiveFluidAccumulator) {
            return ModConfig.optout.without_passive_fluid_accumulator;
        }
        if (block instanceof BlockDecorWasteIncinerator) {
            return ModConfig.optout.without_waste_incinerator;
        }
        if (block instanceof BlockDecorDropper) {
            return ModConfig.optout.without_factory_dropper;
        }
        if (block instanceof BlockDecorHopper) {
            return ModConfig.optout.without_factory_hopper;
        }
        if (block instanceof BlockDecorPlacer) {
            return ModConfig.optout.without_factory_placer;
        }
        if (block instanceof BlockDecorBreaker) {
            return ModConfig.optout.without_block_breaker;
        }
        if (block instanceof BlockDecorSolarPanel) {
            return ModConfig.optout.without_solar_panel;
        }
        if (block instanceof BlockDecorFluidFunnel) {
            return ModConfig.optout.without_fluid_funnel;
        }
        if (block instanceof BlockDecorMineralSmelter) {
            return ModConfig.optout.without_mineral_smelter;
        }
        if (block instanceof BlockDecorMilker) {
            return ModConfig.optout.without_milker;
        }
        if (block instanceof BlockDecorPipeValve) {
            return ModConfig.optout.without_valves;
        }
        if (block instanceof BlockDecorTreeCutter) {
            return ModConfig.optout.without_treecutter;
        }
        if (ModConfig.optout.without_slabs && block instanceof BlockDecorSlab) {
            return true;
        }
        if (ModConfig.optout.without_stairs && block instanceof BlockDecorStairs) {
            return true;
        }
        if (ModConfig.optout.without_walls && block instanceof BlockDecorWall) {
            return true;
        }
        if (ModConfig.optout.without_poles && block instanceof BlockDecorStraightPole) {
            return true;
        }
        if (ModConfig.optout.without_clinker_bricks && rn.startsWith("clinker_brick_")) {
            return true;
        }
        if (ModConfig.optout.without_slag_bricks && rn.startsWith("slag_brick_")) {
            return true;
        }
        if (ModConfig.optout.without_rebar_concrete && rn.startsWith("rebar_concrete")) {
            return true;
        }
        if (ModConfig.optout.without_gas_concrete && rn.startsWith("gas_concrete")) {
            return true;
        }
        if (ModConfig.optout.without_ie_concrete_wall && rn.startsWith("concrete_wall")) {
            return true;
        }
        if (ModConfig.optout.without_panzer_glass && rn.startsWith("panzerglass_")) {
            return true;
        }
        if (ModConfig.optout.without_light_sources && rn.endsWith("_light")) {
            return true;
        }
        if (ModConfig.optout.without_sign_plates && rn.startsWith("sign_")) {
            return true;
        }
        if (ModConfig.optout.without_treated_wood_furniture) {
            if (block instanceof BlockDecorChair) {
                return true;
            }
            if (rn.equals("treated_wood_table")) {
                return true;
            }
            if (rn.equals("treated_wood_side_table")) {
                return true;
            }
            if (rn.equals("treated_wood_stool")) {
                return true;
            }
            if (rn.equals("treated_wood_windowsill")) {
                return true;
            }
            if (rn.equals("treated_wood_broad_windowsill")) {
                return true;
            }
            if (rn.equals("steel_table")) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isOptedOut(@Nullable Item item) {
        if (item == null || optout == null) {
            return true;
        }
        if (item instanceof ItemBlock) {
            return ModConfig.isOptedOut(((ItemBlock)item).func_179223_d());
        }
        return false;
    }

    public static final void startup_apply() {
        int i;
        ModRecipes.furnaceRecipeOverrideReset();
        if (ModConfig.tweaks.furnace_smelts_nuggets) {
            ModRecipes.furnaceRecipeOverrideSmeltsOresToNuggets();
        }
        ModConfig.optout.includes = ModConfig.optout.includes.toLowerCase().replaceAll("engineersdecor:", "").replaceAll("[^*_,a-z0-9]", "");
        if (!ModConfig.optout.includes.isEmpty()) {
            ModEngineersDecor.logger.info("Pattern includes: '" + ModConfig.optout.includes + "'");
        }
        String[] incl = ModConfig.optout.includes.split(",");
        includes_.clear();
        for (i = 0; i < incl.length; ++i) {
            incl[i] = incl[i].replaceAll("[*]", ".*?");
            if (incl[i].isEmpty()) continue;
            includes_.add(incl[i]);
        }
        ModConfig.optout.excludes = ModConfig.optout.excludes.toLowerCase().replaceAll("engineersdecor:", "").replaceAll("[^*_,a-z0-9]", "");
        if (!ModConfig.optout.excludes.isEmpty()) {
            ModEngineersDecor.logger.info("Pattern excludes: '" + ModConfig.optout.excludes + "'");
        }
        String[] excl = ModConfig.optout.excludes.split(",");
        excludes_.clear();
        for (i = 0; i < excl.length; ++i) {
            excl[i] = excl[i].replaceAll("[*]", ".*?");
            if (excl[i].isEmpty()) continue;
            excludes_.add(excl[i]);
        }
    }

    public static final void apply() {
        BlockDecorFurnace.on_config(ModConfig.tweaks.furnace_smelting_speed_percent, ModConfig.tweaks.furnace_fuel_efficiency_percent, ModConfig.tweaks.furnace_boost_energy_consumption);
        BlockDecorChair.on_config(ModConfig.optout.without_chair_sitting, ModConfig.optout.without_mob_chair_sitting, ModConfig.tweaks.chair_mob_sitting_probability_percent, ModConfig.tweaks.chair_mob_standup_probability_percent);
        BlockDecorLadder.on_config(ModConfig.optout.without_ladder_speed_boost);
        BlockDecorCraftingTable.on_config(ModConfig.optout.without_crafting_table_history, false, ModConfig.tweaks.with_crafting_quickmove_buttons, ModConfig.tweaks.without_crafting_mouse_scrolling);
        BlockDecorPipeValve.on_config(ModConfig.tweaks.pipevalve_max_flowrate, ModConfig.tweaks.pipevalve_redstone_slope);
        BlockDecorFurnaceElectrical.on_config(ModConfig.tweaks.e_furnace_speed_percent, ModConfig.tweaks.e_furnace_power_consumption, false);
        BlockDecorSolarPanel.on_config(ModConfig.tweaks.solar_panel_peak_power, 128);
        BlockDecorBreaker.on_config(ModConfig.tweaks.block_breaker_power_consumption, ModConfig.tweaks.block_breaker_reluctance, ModConfig.tweaks.block_breaker_min_breaking_time, ModConfig.tweaks.block_breaker_requires_power);
        BlockDecorTreeCutter.on_config(ModConfig.tweaks.tree_cuttter_energy_consumption, ModConfig.tweaks.tree_cuttter_cutting_time_needed, ModConfig.tweaks.tree_cuttter_requires_power);
        BlockDecorMilker.on_config(ModConfig.tweaks.milker_energy_consumption);
        BlockDecorPlacer.BTileEntity.on_config();
        server_config_.func_74757_a("tree_cuttter_requires_power", ModConfig.tweaks.tree_cuttter_requires_power);
        server_config_.func_74757_a("block_breaker_requires_power", ModConfig.tweaks.block_breaker_requires_power);
    }

    @Mod.EventBusSubscriber(modid="engineersdecor")
    private static final class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (!event.getModID().equals("engineersdecor")) {
                return;
            }
            ConfigManager.sync((String)"engineersdecor", (Config.Type)Config.Type.INSTANCE);
            ModConfig.apply();
        }
    }

    public static final class SettingsTweaks {
        @Config.Comment(value={"Smelts ores to nuggets that are normally smelted to ingots, if detectable in the Forge ore dict. Prefers IE recipe results. The value can be changed on-the-fly for testing or age progression."})
        @Config.Name(value="Furnace: Nugget smelting")
        public boolean furnace_smelts_nuggets = false;
        @Config.Comment(value={"Defines, in percent, how fast the lab furnace smelts compared to a vanilla furnace. 100% means vanilla furnace speed, 150% means the lab furnace is faster. The value can be changed on-the-fly for tuning."})
        @Config.Name(value="Furnace: Smelting speed %")
        @Config.RangeInt(min=50, max=500)
        public int furnace_smelting_speed_percent = 130;
        @Config.Comment(value={"Defines, in percent, how fuel efficient the lab furnace is, compared to a vanilla furnace. 100% means vanilla furnace consumiton, 200% means the lab furnace needs about half the fuel of a vanilla furnace, The value can be changed on-the-fly for tuning."})
        @Config.Name(value="Furnace: Fuel efficiency %")
        @Config.RangeInt(min=50, max=250)
        public int furnace_fuel_efficiency_percent = 100;
        @Config.Comment(value={"Defines the energy consumption (per tick) for speeding up the smelting process. If IE is installed, an external heater has to be inserted into an auxiliary slot of the lab furnace. The power source needs to be able to provide at least 4 times this consumption (fixed threshold value). The value can be changed on-the-fly for tuning. The default value corresponds to the IE heater consumption."})
        @Config.Name(value="Furnace: Boost energy")
        @Config.RangeInt(min=16, max=256)
        public int furnace_boost_energy_consumption = 24;
        @Config.Comment(value={"Defines, in percent, how high the probability is that a mob sits on a chair when colliding with it. Can be changed on-the-fly for tuning."})
        @Config.Name(value="Chairs: Sitting chance %")
        @Config.RangeDouble(min=0.0, max=80.0)
        public double chair_mob_sitting_probability_percent = 10.0;
        @Config.Comment(value={"Defines, in percent, probable it is that a mob leaves a chair when sitting on it. The 'dice is rolled' about every 20 ticks. There is also a minimum Sitting time of about 3s. The config value can be changed on-the-fly for tuning."})
        @Config.Name(value="Chairs: Stand up chance %")
        @Config.RangeDouble(min=0.001, max=10.0)
        public double chair_mob_standup_probability_percent = 1.0;
        @Config.Comment(value={"Disables increasing/decreasing the crafting grid items by scrolling over the crafting result slot."})
        @Config.Name(value="Crafting table: Move buttons")
        public boolean with_crafting_quickmove_buttons = false;
        @Config.Comment(value={"Enables small quick-move arrows from/to player/block storage. Makes the UI a bit too busy, therefore disabled by default."})
        @Config.Name(value="Crafting table: Mouse scrolling")
        public boolean without_crafting_mouse_scrolling = false;
        @Config.Comment(value={"Defines how many millibuckets can be transferred (per tick) through the valves. That is technically the 'storage size' specified for blocks that want to fill fluids into the valve (the valve has no container and forward that to the output block), The value can be changed on-the-fly for tuning. "})
        @Config.Name(value="Valves: Max flow rate")
        @Config.RangeInt(min=1, max=10000)
        public int pipevalve_max_flowrate = 1000;
        @Config.Comment(value={"Defines how many millibuckets per redstone signal strength can be transferred per tick through the analog redstone controlled valves. Note: power 0 is always off, power 15 is always the max flow rate. Between power 1 and 14 this scaler will result in a flow = 'redstone slope' * 'current redstone power'. The value can be changed on-the-fly for tuning. "})
        @Config.Name(value="Valves: Redstone slope")
        @Config.RangeInt(min=1, max=10000)
        public int pipevalve_redstone_slope = 20;
        @Config.Comment(value={"Defines, in percent, how fast the electrical furnace smelts compared to a vanilla furnace. 100% means vanilla furnace speed, 150% means the electrical furnace is faster. The value can be changed on-the-fly for tuning."})
        @Config.Name(value="E-furnace: Smelting speed %")
        @Config.RangeInt(min=50, max=500)
        public int e_furnace_speed_percent = 200;
        @Config.Comment(value={"Defines how much RF per tick the the electrical furnace consumed (average) for smelting. The feeders transferring items from/to adjacent have this consumption/8 for each stack transaction. The default value is only slightly higher than a furnace with an IE external heater (and no burning fuel inside).The config value can be changed on-the-fly for tuning."})
        @Config.Name(value="E-furnace: Power consumption")
        @Config.RangeInt(min=10, max=256)
        public int e_furnace_power_consumption = 16;
        @Config.Comment(value={"Defines the peak power production (at noon) of the Small Solar Panel. Note that the agerage power is much less, as no power is produced at all during the night, and the power curve is nonlinear rising/falling during the day. Bad weather conditions also decrease the production. The config value can be changed on-the-fly for tuning."})
        @Config.Name(value="Solar panel: Peak power")
        @Config.RangeInt(min=5, max=128)
        public int solar_panel_peak_power = 32;
        @Config.Comment(value={"Defines how much RF power the Small Block Breaker requires to magnificently increase the processing speed. The config value can be changed on-the-fly for tuning."})
        @Config.Name(value="Block Breaker: Power consumption")
        @Config.RangeInt(min=16, max=512)
        public int block_breaker_power_consumption = 64;
        @Config.Comment(value={"Defines how much time the Small Block Breaker needs per block hardness, means: 'reluctance' * hardness + min_time, you change the 'reluctance' here.The unit is ticks/hardness. The config value can be changed on-the-fly for tuning."})
        @Config.Name(value="Block Breaker: Breaking reluctance")
        @Config.RangeInt(min=5, max=50)
        public int block_breaker_reluctance = 17;
        @Config.Comment(value={"Defines how much time the Small Block Breaker needs at least, better said it's an offset: 'reluctance' * hardness + min_time, you change the 'min_time' here, value in ticks.The config value can be changed on-the-fly for tuning."})
        @Config.Name(value="Block Breaker: Min breaking time")
        @Config.RangeInt(min=10, max=100)
        public int block_breaker_min_breaking_time = 15;
        @Config.Comment(value={"Defines if the Small Block Breaker does not work without RF power."})
        @Config.Name(value="Block Breaker: Power required")
        public boolean block_breaker_requires_power = false;
        @Config.Comment(value={"Defines how much RF power the Small Tree Cutter requires to magnificently increase the processing speed. The config value can be changed on-the-fly for tuning."})
        @Config.Name(value="Tree Cutter: Power consumption")
        @Config.RangeInt(min=16, max=512)
        public int tree_cuttter_energy_consumption = 64;
        @Config.Comment(value={"Defines how much time the Small Tree Cutter needs to cut a tree without RF power. The value is in seconds. With energy it is 6 times faster. The config value can be changed on-the-fly for tuning."})
        @Config.Name(value="Tree Cutter: Cutting time")
        @Config.RangeInt(min=10, max=240)
        public int tree_cuttter_cutting_time_needed = 60;
        @Config.Comment(value={"Defines if the Small Tree Cutter does not work without RF power."})
        @Config.Name(value="Tree Cutter: Power required")
        public boolean tree_cuttter_requires_power = false;
        @Config.Comment(value={"Defines how much RF power the milking machine needs to work. Note this is a permanent standby consumption (not only when the machine does something). If zero, the machine does not need power at all to function.The config value can be changed on-the-fly for tuning."})
        @Config.Name(value="Milker: Power consumption")
        @Config.RangeInt(min=0, max=128)
        public int milker_energy_consumption = 0;
    }

    public static final class SettingsZTesting {
        @Config.Comment(value={"Enables experimental features. Use at own risk."})
        @Config.Name(value="With experimental")
        @Config.RequiresMcRestart
        public boolean with_experimental = false;
        @Config.Comment(value={"Disable all internal recipes, allowing to use alternative pack recipes."})
        @Config.Name(value="Without recipes")
        @Config.RequiresMcRestart
        public boolean without_recipes = false;
        @Config.Comment(value={"Disable registration of opt'ed out blocks. That is normally not a good idea. Your choice."})
        @Config.Name(value="Without opt-out registration")
        @Config.RequiresMcRestart
        public boolean without_optout_registration = false;
    }

    public static final class SettingsOptouts {
        @Config.Comment(value={"Opt-out any block by its registry name ('*' wildcard matching, comma separated list, whitespaces ignored. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' excludes everything that has 'wood' or 'steel' in the registry name. The matching result is also traced in the log file. "})
        @Config.Name(value="Pattern excludes")
        @Config.RequiresMcRestart
        public String excludes = "";
        @Config.Comment(value={"Prevent blocks from being opt'ed by registry name ('*' wildcard matching, comma separated list, whitespaces ignored. Evaluated before all other opt-out checks. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' includes everything that has 'wood' or 'steel' in the registry name.The matching result is also traced in the log file."})
        @Config.Name(value="Pattern includes")
        @Config.RequiresMcRestart
        public String includes = "";
        @Config.Comment(value={"Disable CTRL-SHIFT item tooltip display."})
        @Config.Name(value="Without tooltips")
        public boolean without_tooltips = false;
        @Config.Comment(value={"Disable all tile entity special renderers."})
        @Config.Name(value="Without TESRs")
        public boolean without_tesrs = false;
        @Config.Comment(value={"Disable clinker bricks and derived blocks."})
        @Config.Name(value="Without clinker bricks")
        @Config.RequiresMcRestart
        public boolean without_clinker_bricks = false;
        @Config.Comment(value={"Disable slag bricks and derived blocks."})
        @Config.Name(value="Without slag bricks")
        @Config.RequiresMcRestart
        public boolean without_slag_bricks = false;
        @Config.Comment(value={"Disable rebar concrete and derived blocks."})
        @Config.Name(value="Without rebar concrete")
        @Config.RequiresMcRestart
        public boolean without_rebar_concrete = false;
        @Config.Comment(value={"Disable gas concrete and derived blocks."})
        @Config.Name(value="Without gas concrete")
        @Config.RequiresMcRestart
        public boolean without_gas_concrete = false;
        @Config.Comment(value={"Disable all mod wall blocks."})
        @Config.Name(value="Without walls")
        @Config.RequiresMcRestart
        public boolean without_walls = false;
        @Config.Comment(value={"Disable all mod stairs blocks."})
        @Config.Name(value="Without stairs")
        @Config.RequiresMcRestart
        public boolean without_stairs = false;
        @Config.Comment(value={"Disable IE concrete wall."})
        @Config.Name(value="Without concrete wall")
        @Config.RequiresMcRestart
        public boolean without_ie_concrete_wall = false;
        @Config.Comment(value={"Disable panzer glass and derived blocks."})
        @Config.Name(value="Without panzer glass")
        @Config.RequiresMcRestart
        public boolean without_panzer_glass = false;
        @Config.Comment(value={"Disable ladders"})
        @Config.Name(value="Without ladders")
        @Config.RequiresMcRestart
        public boolean without_ladders = false;
        @Config.Comment(value={"Disable treated wood table, stool, windowsill, etc."})
        @Config.Name(value="Without tr. wood furniture")
        @Config.RequiresMcRestart
        public boolean without_treated_wood_furniture = false;
        @Config.Comment(value={"Disable treated wood window, etc."})
        @Config.Name(value="Without windows")
        @Config.RequiresMcRestart
        public boolean without_windows = false;
        @Config.Comment(value={"Disable light sources"})
        @Config.Name(value="Without lights")
        @Config.RequiresMcRestart
        public boolean without_light_sources = false;
        @Config.Comment(value={"Disable horizontal half-block slab."})
        @Config.Name(value="Without slabs")
        @Config.RequiresMcRestart
        public boolean without_slabs = false;
        @Config.Comment(value={"Disable stackable 1/8 block slices."})
        @Config.Name(value="Without slab slices")
        @Config.RequiresMcRestart
        public boolean without_halfslabs = false;
        @Config.Comment(value={"Disable poles of any material."})
        @Config.Name(value="Without poles")
        @Config.RequiresMcRestart
        public boolean without_poles = false;
        @Config.Comment(value={"Disable horizontal supports like the double-T support."})
        @Config.Name(value="Without h. supports")
        @Config.RequiresMcRestart
        public boolean without_hsupports = false;
        @Config.Comment(value={"Disable decorative sign plates (caution, hazards, etc)."})
        @Config.Name(value="Without signs")
        @Config.RequiresMcRestart
        public boolean without_sign_plates = false;
        @Config.Comment(value={"Disable the Floor Grating."})
        @Config.Name(value="Without floor gratings")
        @Config.RequiresMcRestart
        public boolean without_floor_grating = false;
        @Config.Comment(value={"Disable treated wood crafting table."})
        @Config.Name(value="Without crafting table")
        @Config.RequiresMcRestart
        public boolean without_crafting_table = false;
        @Config.Comment(value={"Disable small lab furnace."})
        @Config.Name(value="Without lab furnace")
        @Config.RequiresMcRestart
        public boolean without_lab_furnace = false;
        @Config.Comment(value={"Disable small electrical pass-through furnace."})
        @Config.Name(value="Without electrical furnace")
        @Config.RequiresMcRestart
        public boolean without_electrical_furnace = false;
        @Config.Comment(value={"Disable check valve, and redstone controlled valves."})
        @Config.Name(value="Without valves")
        @Config.RequiresMcRestart
        public boolean without_valves = false;
        @Config.Comment(value={"Disable the passive fluid accumulator."})
        @Config.Name(value="Without fluid accumulator")
        @Config.RequiresMcRestart
        public boolean without_passive_fluid_accumulator = false;
        @Config.Comment(value={"Disable item disposal/trash/void incinerator device."})
        @Config.Name(value="Without waste incinerator")
        @Config.RequiresMcRestart
        public boolean without_waste_incinerator = false;
        @Config.Comment(value={"Disable the factory dropper."})
        @Config.Name(value="Without factory dropper")
        @Config.RequiresMcRestart
        public boolean without_factory_dropper = false;
        @Config.Comment(value={"Disable the factory hopper."})
        @Config.Name(value="Without factory hopper")
        @Config.RequiresMcRestart
        public boolean without_factory_hopper = false;
        @Config.Comment(value={"Disable the Factory Block Placer."})
        @Config.Name(value="Without block placer")
        @Config.RequiresMcRestart
        public boolean without_factory_placer = false;
        @Config.Comment(value={"Disable the Small Block Breaker."})
        @Config.Name(value="Without block breaker")
        @Config.RequiresMcRestart
        public boolean without_block_breaker = false;
        @Config.Comment(value={"Disable the Small Solar Panel."})
        @Config.Name(value="Without solar panel")
        @Config.RequiresMcRestart
        public boolean without_solar_panel = false;
        @Config.Comment(value={"Disable the Small Fluid Collection Funnel."})
        @Config.Name(value="Without fluid collector")
        @Config.RequiresMcRestart
        public boolean without_fluid_funnel = false;
        @Config.Comment(value={"Disable the Small Mineral Smelter."})
        @Config.Name(value="Without mineral smelter")
        @Config.RequiresMcRestart
        public boolean without_mineral_smelter = false;
        @Config.Comment(value={"Disable the Small Tree Cutter."})
        @Config.Name(value="Without tree cutter")
        @Config.RequiresMcRestart
        public boolean without_treecutter = false;
        @Config.Comment(value={"Disable the Small Mikling Machine."})
        @Config.Name(value="Without milking machine")
        @Config.RequiresMcRestart
        public boolean without_milker = false;
        @Config.Comment(value={"Disable directly picking up layers from slabs and slab slices by left clicking while looking up/down."})
        @Config.Name(value="Without slab pickup")
        public boolean without_direct_slab_pickup = false;
        @Config.Comment(value={"Disable possibility to sit on stools and chairs."})
        @Config.Name(value="Without chair sitting")
        public boolean without_chair_sitting = false;
        @Config.Comment(value={"Disable that mobs will sit on chairs and stools."})
        @Config.Name(value="Without chair mob sitting")
        public boolean without_mob_chair_sitting = false;
        @Config.Comment(value={"Disable the speed boost of ladders in this mod."})
        @Config.Name(value="Without ladder speed boost")
        public boolean without_ladder_speed_boost = false;
        @Config.Comment(value={"Disable history refabrication feature of the treated wood crafting table."})
        @Config.Name(value="Without crafting table history")
        public boolean without_crafting_table_history = false;
    }
}

