/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.detail;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.detail.ModConfig;

public class BlockCategories {
    private static Set<Block> logs_ = new HashSet<Block>();
    private static Set<Block> leaves_ = new HashSet<Block>();
    private static Set<Block> variant_logs_ = new HashSet<Block>();

    public static final Set<Block> logs() {
        return logs_;
    }

    public static final Set<Block> leaves() {
        return leaves_;
    }

    public static boolean isLog(IBlockState state) {
        Block block = state.func_177230_c();
        return block instanceof BlockLog || block instanceof BlockNewLog || BlockCategories.logs().contains(block);
    }

    public static boolean isLeaves(IBlockState state) {
        if (state.func_185904_a() == Material.field_151584_j) {
            return true;
        }
        Block block = state.func_177230_c();
        return block instanceof BlockLeaves || BlockCategories.leaves().contains(block);
    }

    public static final boolean isSameLeaves(IBlockState a, IBlockState b) {
        if (!BlockCategories.isLeaves(a)) {
            return false;
        }
        Block block = a.func_177230_c();
        if (block != b.func_177230_c()) {
            return false;
        }
        if (block instanceof BlockNewLeaf) {
            return a.func_177229_b((IProperty)BlockNewLeaf.field_176240_P) == b.func_177229_b((IProperty)BlockNewLeaf.field_176240_P);
        }
        if (block instanceof BlockOldLeaf) {
            return a.func_177229_b((IProperty)BlockOldLeaf.field_176239_P) == b.func_177229_b((IProperty)BlockOldLeaf.field_176239_P);
        }
        return true;
    }

    public static final boolean isSameLog(IBlockState a, IBlockState b) {
        if (!BlockCategories.isLog(a) || !BlockCategories.isLog(b)) {
            return false;
        }
        if (variant_logs_.contains(a.func_177230_c()) || variant_logs_.contains(b.func_177230_c())) {
            return true;
        }
        if (a.func_177230_c() != b.func_177230_c()) {
            return false;
        }
        if (a.func_177230_c() instanceof BlockNewLog) {
            return a.func_177229_b((IProperty)BlockNewLog.field_176300_b) == b.func_177229_b((IProperty)BlockNewLog.field_176300_b);
        }
        if (a.func_177230_c() instanceof BlockOldLog) {
            return a.func_177229_b((IProperty)BlockOldLog.field_176301_b) == b.func_177229_b((IProperty)BlockOldLog.field_176301_b);
        }
        IProperty prop = a.func_177227_a().stream().filter(p -> p.func_177701_a().contains("variant") || p.func_177701_a().contains("type")).findFirst().orElse(null);
        if (prop != null) {
            return a.func_177229_b(prop).equals(b.func_177229_b(prop));
        }
        return true;
    }

    public static final void reload() {
        Item item;
        NonNullList stacks;
        HashSet<Block> logs = new HashSet<Block>();
        for (String string : OreDictionary.getOreNames()) {
            if (!string.startsWith("logWood")) continue;
            stacks = OreDictionary.getOres((String)string, (boolean)false);
            for (ItemStack stack : stacks) {
                item = stack.func_77973_b();
                if (!(item instanceof ItemBlock)) continue;
                Block block = ((ItemBlock)item).func_179223_d();
                logs.add(block);
                if (!block.getRegistryName().func_110623_a().contains("menril")) continue;
                variant_logs_.add(block);
            }
        }
        logs_ = logs;
        ModEngineersDecor.logger.info("Found " + logs.size() + " types of 'choppable' log.");
        if (ModConfig.zmisc.with_experimental) {
            for (Block b : logs_) {
                ModEngineersDecor.logger.info(" - choppable log: " + b.getRegistryName());
            }
        }
        HashSet<Block> leaves = new HashSet<Block>();
        for (String string : OreDictionary.getOreNames()) {
            if (!string.startsWith("treeLeaves")) continue;
            stacks = OreDictionary.getOres((String)string, (boolean)false);
            for (ItemStack stack : stacks) {
                item = stack.func_77973_b();
                if (!(item instanceof ItemBlock)) continue;
                leaves.add(((ItemBlock)item).func_179223_d());
            }
        }
        leaves_ = leaves;
        ModEngineersDecor.logger.info("Found " + leaves.size() + " types of leaves.");
        if (ModConfig.zmisc.with_experimental) {
            for (Block b : leaves_) {
                ModEngineersDecor.logger.info(" - choppable leaf: " + b.getRegistryName());
            }
        }
    }
}

