/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.detail.ModAuxiliaries;

public class BlockDecorLadder
extends BlockLadder {
    protected static final double ladder_speed = 0.7;
    protected static boolean with_ladder_speed_boost = true;
    protected static final AxisAlignedBB EDLADDER_SOUTH_AABB = ModAuxiliaries.getPixeledAABB(3.0, 0.0, 0.0, 13.0, 16.0, 3.0);
    protected static final AxisAlignedBB EDLADDER_EAST_AABB = ModAuxiliaries.getRotatedAABB(EDLADDER_SOUTH_AABB, EnumFacing.EAST, false);
    protected static final AxisAlignedBB EDLADDER_WEST_AABB = ModAuxiliaries.getRotatedAABB(EDLADDER_SOUTH_AABB, EnumFacing.WEST, false);
    protected static final AxisAlignedBB EDLADDER_NORTH_AABB = ModAuxiliaries.getRotatedAABB(EDLADDER_SOUTH_AABB, EnumFacing.NORTH, false);

    public static final void on_config(boolean without_ladder_speed_boost) {
        with_ladder_speed_boost = !without_ladder_speed_boost;
    }

    public BlockDecorLadder(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound) {
        this.func_149647_a(ModEngineersDecor.CREATIVE_TAB_ENGINEERSDECOR);
        this.setRegistryName("engineersdecor", registryName);
        this.func_149663_c("engineersdecor." + registryName);
        this.func_149675_a(false);
        this.func_149711_c(hardness > 0.0f ? hardness : 5.0f);
        this.func_149752_b(resistance > 0.0f ? resistance : 10.0f);
        this.func_149672_a(sound == null ? SoundType.field_185851_d : sound);
        this.func_149713_g(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        ModAuxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176382_a)) {
            case NORTH: {
                return EDLADDER_NORTH_AABB;
            }
            case SOUTH: {
                return EDLADDER_SOUTH_AABB;
            }
            case WEST: {
                return EDLADDER_WEST_AABB;
            }
        }
        return EDLADDER_EAST_AABB;
    }

    public boolean func_181623_g() {
        return false;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.NORMAL;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return this.canAttachTo(world, pos.func_177976_e(), side) || this.canAttachTo(world, pos.func_177974_f(), side) || this.canAttachTo(world, pos.func_177978_c(), side) || this.canAttachTo(world, pos.func_177968_d(), side);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (facing.func_176740_k().func_176722_c() && this.canAttachTo(world, pos.func_177972_a(facing.func_176734_d()), facing)) {
            return this.func_176223_P().func_177226_a((IProperty)field_176382_a, (Comparable)facing);
        }
        for (EnumFacing e : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canAttachTo(world, pos.func_177972_a(e.func_176734_d()), e)) continue;
            return this.func_176223_P().func_177226_a((IProperty)field_176382_a, (Comparable)e);
        }
        return this.func_176223_P();
    }

    private boolean canAttachTo(World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        return !BlockDecorLadder.func_193382_c((Block)state.func_177230_c()) && state.func_193401_d((IBlockAccess)world, pos, side) == BlockFaceShape.SOLID;
    }

    public static void onPlayerUpdateEvent(EntityPlayer player) {
        if (!with_ladder_speed_boost) {
            return;
        }
        if (!player.func_70617_f_() || player.func_70093_af() || player.func_175149_v()) {
            return;
        }
        if (Math.abs(player.field_70181_x) < 0.1 || Math.abs(player.field_70181_x) > 0.7 || player.func_70040_Z().field_72448_b > 0.0 != player.field_70181_x > 0.0) {
            return;
        }
        if (Math.abs(player.func_70040_Z().field_72448_b) < 0.9) {
            return;
        }
        BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        if (!(player.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BlockDecorLadder)) {
            return;
        }
        player.field_70143_R = 0.0f;
        player.field_70181_x = player.field_70181_x < -0.25 ? -0.7 : (player.field_70181_x > 0.25 ? 0.7 : player.field_70181_x);
        player.field_70159_w = MathHelper.func_151237_a((double)player.field_70159_w, (double)-0.05, (double)0.05);
        player.field_70179_y = MathHelper.func_151237_a((double)player.field_70179_y, (double)-0.05, (double)0.05);
        player.func_70091_d(MoverType.PLAYER, player.field_70159_w, player.field_70181_x, player.field_70179_y);
    }
}

