/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirected;
import wile.engineersdecor.detail.Networking;

public class BlockDecorHopper
extends BlockDecorDirected {
    public BlockDecorHopper(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound, unrotatedAABB);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BTileEntity();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tedata")) {
            return;
        }
        NBTTagCompound te_nbt = stack.func_77978_p().func_74775_l("tedata");
        if (te_nbt.func_82582_d()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        ((BTileEntity)te).readnbt(te_nbt, false);
        ((BTileEntity)te).reset_rtstate();
        ((BTileEntity)te).func_70296_d();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        ItemStack stack = new ItemStack((Block)this, 1);
        NBTTagCompound te_nbt = new NBTTagCompound();
        ((BTileEntity)te).writenbt(te_nbt, false);
        if (!te_nbt.func_82582_d()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("tedata", (NBTBase)te_nbt);
            stack.func_77982_d(nbt);
        }
        world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
        world.func_175698_g(pos);
        world.func_175713_t(pos);
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        for (ItemStack stack : ((BTileEntity)te).stacks_) {
            if (stack.func_190926_b()) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
        ((BTileEntity)te).reset_rtstate();
        super.onBlockExploded(world, pos, explosion);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)ModEngineersDecor.instance, 213106, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos) {
        if (!(world instanceof World) || world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        ((BTileEntity)te).block_updated();
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        super.func_180658_a(world, pos, entity, fallDistance);
        if (!(entity instanceof EntityItem)) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        ((BTileEntity)te).collection_timer_ = 0;
    }

    public static Object getServerGuiElement(EntityPlayer player, World world, BlockPos pos, TileEntity te) {
        return te instanceof BTileEntity ? new BContainer(player.field_71071_by, world, pos, (BTileEntity)te) : null;
    }

    public static Object getClientGuiElement(EntityPlayer player, World world, BlockPos pos, TileEntity te) {
        return te instanceof BTileEntity ? new BGui(player.field_71071_by, world, pos, (BTileEntity)te) : null;
    }

    public static class BTileEntity
    extends TileEntity
    implements ITickable,
    ISidedInventory,
    Networking.IPacketReceiver {
        public static final int TICK_INTERVAL = 10;
        public static final int COLLECTION_INTERVAL = 25;
        public static final int NUM_OF_SLOTS = 18;
        public static final int MAX_TRANSFER_COUNT = 32;
        public static final int MAX_COLLECTION_RANGE = 4;
        public static final int PERIOD_OFFSET = 10;
        public static final int LOGIC_INVERTED = 1;
        public static final int LOGIC_CONTINUOUS = 2;
        private boolean block_power_signal_ = false;
        private boolean block_power_updated_ = false;
        private int collection_timer_ = 0;
        private int delay_timer_ = 0;
        private int transfer_count_ = 1;
        private int logic_ = 3;
        private int transfer_period_ = 0;
        private int collection_range_ = 0;
        private int current_slot_index_ = 0;
        private int tick_timer_ = 0;
        protected NonNullList<ItemStack> stacks_;
        private final IItemHandler item_handler_ = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
        private final IItemHandler down_item_handler_ = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
        private static final int[] SIDED_INV_SLOTS = new int[18];

        public static void on_config(int cooldown_ticks) {
        }

        public BTileEntity() {
            this.stacks_ = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
            this.reset_rtstate();
        }

        public void reset_rtstate() {
            this.block_power_signal_ = false;
            this.block_power_updated_ = false;
        }

        public void readnbt(NBTTagCompound nbt, boolean update_packet) {
            this.stacks_ = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks_);
            while (this.stacks_.size() < 18) {
                this.stacks_.add((Object)ItemStack.field_190927_a);
            }
            this.block_power_signal_ = nbt.func_74767_n("powered");
            this.current_slot_index_ = nbt.func_74762_e("act_slot_index");
            this.transfer_count_ = MathHelper.func_76125_a((int)nbt.func_74762_e("xsize"), (int)1, (int)32);
            this.logic_ = nbt.func_74762_e("logic");
            this.transfer_period_ = nbt.func_74762_e("period");
            this.collection_range_ = nbt.func_74762_e("range");
        }

        protected void writenbt(NBTTagCompound nbt, boolean update_packet) {
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks_);
            nbt.func_74757_a("powered", this.block_power_signal_);
            nbt.func_74768_a("act_slot_index", this.current_slot_index_);
            nbt.func_74768_a("xsize", this.transfer_count_);
            nbt.func_74768_a("logic", this.logic_);
            nbt.func_74768_a("period", this.transfer_period_);
            nbt.func_74768_a("range", this.collection_range_);
        }

        public void block_updated() {
            boolean powered = this.field_145850_b.func_175640_z(this.field_174879_c);
            if (this.block_power_signal_ != powered) {
                this.block_power_updated_ = true;
            }
            this.block_power_signal_ = powered;
            this.tick_timer_ = 1;
        }

        public boolean is_input_slot(int index) {
            return index >= 0 && index < 18;
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState os, IBlockState ns) {
            return os.func_177230_c() != ns.func_177230_c() || !(ns.func_177230_c() instanceof BlockDecorHopper);
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt, false);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt, false);
            return nbt;
        }

        public String func_70005_c_() {
            Block block = this.func_145838_q();
            return block != null ? block.func_149739_a() + ".name" : "";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
        }

        public int func_70302_i_() {
            return this.stacks_.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks_) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index < this.func_70302_i_() ? (ItemStack)this.stacks_.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks_, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks_, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stacks_.set(index, (Object)stack);
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            if (this.tick_timer_ > 8) {
                this.tick_timer_ = 8;
            }
            this.func_70296_d();
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
            this.func_70296_d();
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return true;
        }

        public int func_174887_a_(int id) {
            switch (id) {
                case 0: {
                    return this.collection_range_;
                }
                case 1: {
                    return this.transfer_count_;
                }
                case 2: {
                    return this.logic_;
                }
                case 3: {
                    return this.transfer_period_;
                }
                case 4: {
                    return this.delay_timer_;
                }
                case 5: {
                    return this.block_power_signal_ ? 1 : 0;
                }
                case 6: {
                    return this.current_slot_index_;
                }
            }
            return 0;
        }

        public void func_174885_b(int id, int value) {
            switch (id) {
                case 0: {
                    this.collection_range_ = MathHelper.func_76125_a((int)value, (int)0, (int)4);
                    return;
                }
                case 1: {
                    this.transfer_count_ = MathHelper.func_76125_a((int)value, (int)1, (int)32);
                    return;
                }
                case 2: {
                    this.logic_ = value;
                    return;
                }
                case 3: {
                    this.transfer_period_ = MathHelper.func_76125_a((int)value, (int)0, (int)100);
                    return;
                }
                case 4: {
                    this.delay_timer_ = MathHelper.func_76125_a((int)value, (int)0, (int)400);
                    return;
                }
                case 5: {
                    this.block_power_signal_ = value != 0;
                    return;
                }
                case 6: {
                    this.current_slot_index_ = MathHelper.func_76125_a((int)value, (int)0, (int)17);
                    return;
                }
            }
        }

        public int func_174890_g() {
            return 7;
        }

        public void func_174888_l() {
            this.stacks_.clear();
        }

        public int[] func_180463_a(EnumFacing side) {
            return SIDED_INV_SLOTS;
        }

        public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
            return this.is_input_slot(index) && this.func_94041_b(index, stack);
        }

        public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
            return direction == EnumFacing.DOWN;
        }

        public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
            return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(cap, facing);
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)(facing == EnumFacing.DOWN ? this.down_item_handler_ : this.item_handler_);
            }
            return (T)super.getCapability(capability, facing);
        }

        @Override
        public void onServerPacketReceived(NBTTagCompound nbt) {
        }

        @Override
        public void onClientPacketReceived(EntityPlayer player, NBTTagCompound nbt) {
            if (nbt.func_74764_b("xsize")) {
                this.transfer_count_ = MathHelper.func_76125_a((int)nbt.func_74762_e("xsize"), (int)1, (int)32);
            }
            if (nbt.func_74764_b("period")) {
                this.transfer_period_ = MathHelper.func_76125_a((int)nbt.func_74762_e("period"), (int)0, (int)100);
            }
            if (nbt.func_74764_b("range")) {
                this.collection_range_ = MathHelper.func_76125_a((int)nbt.func_74762_e("range"), (int)0, (int)4);
            }
            if (nbt.func_74764_b("logic")) {
                this.logic_ = nbt.func_74762_e("logic");
            }
            if (nbt.func_74764_b("manual_trigger") && nbt.func_74762_e("manual_trigger") != 0) {
                this.block_power_signal_ = true;
                this.block_power_updated_ = true;
                this.tick_timer_ = 1;
            }
            this.func_70296_d();
        }

        private static int next_slot(int i) {
            return i < 17 ? i + 1 : 0;
        }

        private int try_insert_into_hopper(ItemStack stack) {
            int max_to_insert;
            int n_to_insert = max_to_insert = stack.func_190916_E();
            int first_empty_slot = -1;
            for (int i = 0; i < this.stacks_.size(); ++i) {
                int nspace;
                ItemStack slotstack = (ItemStack)this.stacks_.get(i);
                if (first_empty_slot < 0 && slotstack.func_190926_b()) {
                    first_empty_slot = i;
                    continue;
                }
                if (!stack.func_77969_a(slotstack) || (nspace = slotstack.func_77976_d() - slotstack.func_190916_E()) <= 0) continue;
                if (nspace >= n_to_insert) {
                    slotstack.func_190917_f(n_to_insert);
                    n_to_insert = 0;
                    break;
                }
                slotstack.func_190917_f(nspace);
                n_to_insert -= nspace;
            }
            if (n_to_insert > 0 && first_empty_slot >= 0) {
                ItemStack new_stack = stack.func_77946_l();
                new_stack.func_190920_e(n_to_insert);
                this.stacks_.set(first_empty_slot, (Object)new_stack);
                n_to_insert = 0;
            }
            return max_to_insert - n_to_insert;
        }

        private boolean try_insert(EnumFacing facing) {
            int num_inserted;
            EnumFacing f;
            ItemStack current_stack = ItemStack.field_190927_a;
            for (int i = 0; i < 18; ++i) {
                if (this.current_slot_index_ >= 18) {
                    this.current_slot_index_ = 0;
                }
                if (!(current_stack = (ItemStack)this.stacks_.get(this.current_slot_index_)).func_190926_b()) break;
                this.current_slot_index_ = BTileEntity.next_slot(this.current_slot_index_);
            }
            if (current_stack.func_190926_b()) {
                this.current_slot_index_ = 0;
                return false;
            }
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
                this.delay_timer_ = 12;
                return false;
            }
            if (te instanceof TileEntityHopper ? (f = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing)).func_177229_b((IProperty)BlockHopper.field_176430_a)) == facing.func_176734_d() : te instanceof BTileEntity && (f = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing)).func_177229_b((IProperty)BlockDecorDirected.FACING)) == facing.func_176734_d()) {
                return false;
            }
            ItemStack insert_stack = current_stack.func_77946_l();
            if (insert_stack.func_190916_E() > this.transfer_count_) {
                insert_stack.func_190920_e(this.transfer_count_);
            }
            int initial_insert_stack_size = insert_stack.func_190916_E();
            IItemHandler ih = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            int first_empty_slot_index = -1;
            if (ih == null || ih.getSlots() <= 0) {
                return false;
            }
            for (int i = 0; i < ih.getSlots(); ++i) {
                if (!ih.isItemValid(i, insert_stack)) continue;
                ItemStack target_stack = ih.getStackInSlot(i);
                if (first_empty_slot_index < 0 && target_stack.func_190926_b()) {
                    first_empty_slot_index = i;
                }
                if (target_stack.func_77969_a(insert_stack) && (insert_stack = ih.insertItem(i, insert_stack.func_77946_l(), false)).func_190926_b()) break;
            }
            if (first_empty_slot_index >= 0 && !insert_stack.func_190926_b()) {
                insert_stack = ih.insertItem(first_empty_slot_index, insert_stack.func_77946_l(), false);
            }
            if ((num_inserted = initial_insert_stack_size - insert_stack.func_190916_E()) > 0) {
                current_stack.func_190918_g(num_inserted);
                this.stacks_.set(this.current_slot_index_, (Object)current_stack);
            }
            if (!insert_stack.func_190926_b()) {
                this.current_slot_index_ = BTileEntity.next_slot(this.current_slot_index_);
            }
            return num_inserted > 0;
        }

        private boolean try_item_handler_extract(IItemHandler ih) {
            int end = ih.getSlots();
            int n_to_extract = this.transfer_count_;
            for (int i = 0; i < end; ++i) {
                int n_accepted;
                ItemStack stack;
                if (ih.getStackInSlot(i).func_190926_b() || (stack = ih.extractItem(i, n_to_extract, true)).func_190926_b() || (n_accepted = this.try_insert_into_hopper(stack)) <= 0) continue;
                ItemStack test = ih.extractItem(i, n_accepted, false);
                if ((n_to_extract -= n_accepted) <= 0) break;
            }
            return n_to_extract < this.transfer_count_;
        }

        private boolean try_inventory_extract(IInventory inv) {
            int end = inv.func_70302_i_();
            int n_to_extract = this.transfer_count_;
            for (int i = 0; i < end; ++i) {
                int n_accepted;
                ItemStack stack = inv.func_70301_a(i).func_77946_l();
                if (stack.func_190926_b() || (n_accepted = this.try_insert_into_hopper(stack)) <= 0) continue;
                stack.func_190918_g(n_accepted);
                n_to_extract -= n_accepted;
                if (stack.func_190926_b()) {
                    stack = ItemStack.field_190927_a;
                }
                inv.func_70299_a(i, stack);
                if (n_to_extract <= 0) break;
            }
            if (n_to_extract < this.transfer_count_) {
                inv.func_70296_d();
                return true;
            }
            return false;
        }

        private boolean try_collect(EnumFacing facing) {
            AxisAlignedBB collection_volume;
            BlockPos rpos;
            if (facing == EnumFacing.UP) {
                rpos = this.field_174879_c.func_177963_a(0.5, 1.5, 0.5);
                collection_volume = new AxisAlignedBB(this.field_174879_c.func_177984_a()).func_72314_b(0.1 + (double)this.collection_range_, 0.6, 0.1 + (double)this.collection_range_);
            } else {
                rpos = this.field_174879_c.func_177963_a(0.5, -1.5, 0.5);
                collection_volume = new AxisAlignedBB(this.field_174879_c.func_177979_c(2)).func_72314_b(0.1 + (double)this.collection_range_, 1.0, 0.1 + (double)this.collection_range_);
            }
            List items = this.field_145850_b.func_72872_a(EntityItem.class, collection_volume);
            if (items.size() <= 0) {
                return false;
            }
            int max_to_collect = 3;
            int n_collected = 0;
            for (EntityItem ie : items) {
                ItemStack stack;
                int n_accepted;
                boolean is_direct_collection_tange;
                boolean bl = is_direct_collection_tange = ie.func_174818_b(rpos) < 0.7;
                if (!is_direct_collection_tange && (ie.func_174874_s() || !ie.field_70122_E) || (n_accepted = this.try_insert_into_hopper(stack = ie.func_92059_d())) <= 0) continue;
                if (n_accepted == stack.func_190916_E()) {
                    ie.func_70106_y();
                } else {
                    stack.func_190918_g(n_accepted);
                }
                if (is_direct_collection_tange || ++n_collected < 3) continue;
                break;
            }
            return n_collected > 0;
        }

        public void func_73660_a() {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (this.delay_timer_ > 0 && --this.delay_timer_ == 0) {
                this.func_70296_d();
            }
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 10;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof BlockDecorHopper)) {
                this.block_power_signal_ = false;
                return;
            }
            boolean dirty = this.block_power_updated_;
            boolean rssignal = (this.logic_ & 1) != 0 == !this.block_power_signal_;
            boolean trigger = rssignal && (this.block_power_updated_ || (this.logic_ & 2) != 0);
            EnumFacing hopper_facing = (EnumFacing)state.func_177229_b((IProperty)BlockDecorDirected.FACING);
            boolean tr = this.field_145850_b.func_175640_z(this.field_174879_c);
            this.block_power_updated_ = this.block_power_signal_ != tr;
            this.block_power_signal_ = tr;
            if (this.block_power_updated_) {
                dirty = true;
            }
            if (rssignal) {
                boolean has_item_handler;
                EnumFacing hopper_input_facing = hopper_facing == EnumFacing.UP ? EnumFacing.DOWN : EnumFacing.UP;
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(hopper_input_facing));
                boolean bl = has_item_handler = te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, hopper_input_facing.func_176734_d());
                if (has_item_handler || te instanceof ISidedInventory) {
                    if (has_item_handler) {
                        IItemHandler ih = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, hopper_facing.func_176734_d());
                        if (ih != null && this.try_item_handler_extract(ih)) {
                            dirty = true;
                        }
                    } else {
                        this.try_inventory_extract((IInventory)te);
                    }
                } else if ((this.collection_timer_ -= 10) <= 0) {
                    this.collection_timer_ = 25;
                    if (this.try_collect(hopper_input_facing)) {
                        dirty = true;
                    }
                }
            }
            if (trigger && this.delay_timer_ <= 0) {
                this.delay_timer_ = 10 + this.transfer_period_ * 2;
                if (this.try_insert(hopper_facing)) {
                    dirty = true;
                }
            }
            if (dirty) {
                this.func_70296_d();
            }
            if (trigger && this.tick_timer_ > 10) {
                this.tick_timer_ = 10;
            }
        }

        static {
            for (int i = 0; i < 18; ++i) {
                BTileEntity.SIDED_INV_SLOTS[i] = i;
            }
        }
    }

    public static class BContainer
    extends Container {
        private static final int PLAYER_INV_START_SLOTNO = 18;
        private final World world;
        private final BlockPos pos;
        private final EntityPlayer player;
        private final BTileEntity te;
        private int[] fields_ = new int[7];

        public BContainer(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            int x;
            int y;
            this.player = playerInventory.field_70458_d;
            this.world = world;
            this.pos = pos;
            this.te = te;
            int i = -1;
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 6; ++x) {
                    int xpos = 11 + x * 18;
                    int ypos = 9 + y * 17;
                    this.func_75146_a(new Slot((IInventory)te, ++i, xpos, ypos));
                }
            }
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x2, 8 + x2 * 18, 129));
            }
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, 71 + y * 18));
                }
            }
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public void func_75132_a(IContainerListener listener) {
            super.func_75132_a(listener);
            listener.func_175173_a((Container)this, (IInventory)this.te);
        }

        public void func_75142_b() {
            super.func_75142_b();
            for (int il = 0; il < this.field_75149_d.size(); ++il) {
                IContainerListener lis = (IContainerListener)this.field_75149_d.get(il);
                for (int k = 0; k < this.fields_.length; ++k) {
                    int f = this.te.func_174887_a_(k);
                    if (this.fields_[k] == f) continue;
                    this.fields_[k] = f;
                    lis.func_71112_a((Container)this, k, f);
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void func_75137_b(int id, int value) {
            if (id < 0 || id >= this.fields_.length) {
                return;
            }
            this.fields_[id] = value;
            this.te.func_174885_b(id, value);
        }

        public boolean func_75145_c(EntityPlayer player) {
            return this.world.func_180495_p(this.pos).func_177230_c() instanceof BlockDecorHopper && player.func_174818_b(this.pos) <= 64.0;
        }

        public ItemStack func_82846_b(EntityPlayer player, int index) {
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index >= 0 && index < 18) {
                if (!this.func_75135_a(slot_stack, 18, 54, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 18 && index <= 54) {
                if (!this.func_75135_a(slot_stack, 0, 18, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class BGui
    extends GuiContainer {
        private final BTileEntity te;

        public BGui(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            super((Container)new BContainer(playerInventory, world, pos, te));
            this.te = te;
        }

        public void func_73866_w_() {
            super.func_73866_w_();
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
            super.func_73864_a(mouseX, mouseY, mouseButton);
            BContainer container = (BContainer)this.field_147002_h;
            if (container.fields_.length != 7) {
                return;
            }
            int mx = mouseX - this.getGuiLeft();
            int my = mouseY - this.getGuiTop();
            if (!this.func_146978_c(126, 1, 49, 60, mouseX, mouseY)) {
                return;
            }
            if (this.func_146978_c(128, 9, 44, 10, mouseX, mouseY)) {
                int range = mx - 133;
                if (range < -1) {
                    range = container.fields_[0] - 1;
                } else if (range >= 34) {
                    range = container.fields_[0] + 1;
                } else {
                    range = (int)(0.5 + 4.0 * (double)range / 34.0);
                    range = MathHelper.func_76125_a((int)range, (int)0, (int)4);
                }
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("range", range);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            } else if (this.func_146978_c(128, 21, 44, 10, mouseX, mouseY)) {
                int period = mx - 133;
                period = period < -1 ? container.fields_[3] - 3 : (period >= 35 ? container.fields_[3] + 3 : (int)(0.5 + 100.0 * (double)period / 34.0));
                period = MathHelper.func_76125_a((int)period, (int)0, (int)100);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("period", period);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            } else if (this.func_146978_c(128, 34, 44, 10, mouseX, mouseY)) {
                int ndrop = mx - 134;
                ndrop = ndrop < -1 ? container.fields_[1] - 1 : (ndrop >= 34 ? container.fields_[1] + 1 : MathHelper.func_76125_a((int)(1 + ndrop), (int)1, (int)32));
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("xsize", ndrop);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            } else if (this.func_146978_c(133, 49, 9, 9, mouseX, mouseY)) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("manual_trigger", 1);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            } else if (this.func_146978_c(145, 49, 9, 9, mouseX, mouseY)) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("logic", container.fields_[2] ^ 1);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            } else if (this.func_146978_c(159, 49, 7, 9, mouseX, mouseY)) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("logic", container.fields_[2] ^ 2);
                Networking.PacketTileNotify.sendToServer(this.te, nbt);
            }
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/factory_hopper_gui.png"));
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            int w = this.getXSize();
            int h = this.getYSize();
            this.func_73729_b(x0, y0, 0, 0, w, h);
            BContainer container = (BContainer)this.field_147002_h;
            if (container.fields_.length != 7) {
                return;
            }
            int slot_index = container.fields_[6];
            if (slot_index < 0 || slot_index >= 18) {
                slot_index = 0;
            }
            int x = x0 + 10 + slot_index % 6 * 18;
            int y = y0 + 8 + slot_index / 6 * 17;
            this.func_73729_b(x, y, 200, 8, 18, 18);
            int[] lut = new int[]{133, 141, 149, 157, 166};
            int px = lut[MathHelper.func_76125_a((int)container.fields_[0], (int)0, (int)4)];
            int x2 = x0 + px - 2;
            int y2 = y0 + 14;
            this.func_73729_b(x2, y2, 179, 40, 5, 5);
            int px2 = (int)Math.round(33.5 * (double)container.fields_[3] / 100.0 + 1.0);
            x = x0 + 132 - 2 + MathHelper.func_76125_a((int)px2, (int)0, (int)34);
            y = y0 + 27;
            this.func_73729_b(x, y, 179, 40, 5, 5);
            int x3 = x0 + 133 - 2 + container.fields_[1];
            int y3 = y0 + 40;
            this.func_73729_b(x3, y3, 179, 40, 5, 5);
            if (container.fields_[5] != 0) {
                this.func_73729_b(x0 + 133, y0 + 49, 217, 49, 9, 9);
            }
            int inverter_offset = (container.fields_[2] & 1) != 0 ? 11 : 0;
            this.func_73729_b(x0 + 145, y0 + 49, 177 + inverter_offset, 49, 9, 9);
            int pulse_mode_offset = (container.fields_[2] & 2) != 0 ? 9 : 0;
            this.func_73729_b(x0 + 159, y0 + 49, 199 + pulse_mode_offset, 49, 9, 9);
            if (container.fields_[4] > 10 && System.currentTimeMillis() % 1000L < 500L) {
                this.func_73729_b(x0 + 148, y0 + 22, 187, 22, 3, 3);
            }
        }
    }
}

