/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import wile.engineersdecor.blocks.BlockDecor;

public class BlockDecorFluidFunnel
extends BlockDecor {
    public static final int FILL_LEVEL_MAX = 3;
    public static final PropertyInteger FILL_LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)3);

    public BlockDecorFluidFunnel(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound, unrotatedAABB);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FILL_LEVEL});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)FILL_LEVEL, (Comparable)Integer.valueOf(meta & 3));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) | (Integer)state.func_177229_b((IProperty)FILL_LEVEL);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FILL_LEVEL, (Comparable)Integer.valueOf(0));
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return MathHelper.func_76125_a((int)((Integer)state.func_177229_b((IProperty)FILL_LEVEL) * 5), (int)0, (int)15);
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BTileEntity();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tedata")) {
            return;
        }
        NBTTagCompound te_nbt = stack.func_77978_p().func_74775_l("tedata");
        if (te_nbt.func_82582_d()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        ((BTileEntity)te).readnbt(te_nbt, false);
        ((BTileEntity)te).func_70296_d();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        ItemStack stack = new ItemStack((Block)this, 1);
        NBTTagCompound te_nbt = new NBTTagCompound();
        ((BTileEntity)te).writenbt(te_nbt, false);
        if (!te_nbt.func_82582_d()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("tedata", (NBTBase)te_nbt);
            stack.func_77982_d(nbt);
        }
        world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
        world.func_175698_g(pos);
        world.func_175713_t(pos);
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return false;
        }
        return FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)facing);
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BTileEntity) {
            ((BTileEntity)te).block_changed();
        }
    }

    public static class BTileEntity
    extends TileEntity
    implements IFluidHandler,
    IFluidTankProperties,
    ICapabilityProvider,
    ITickable {
        public static final int TANK_CAPACITY = 3000;
        public static final int TICK_INTERVAL = 10;
        public static final int COLLECTION_INTERVAL = 40;
        public static final int MAX_TRACK_RADIUS = 16;
        public static final int MAX_TRACKING_STEPS_PER_CYCLE = 72;
        public static final int MAX_TRACKING_STEPS_PER_CYCLE_INTENSIVE = 1024;
        public static final int MAX_TRACK_RADIUS_SQ = 256;
        public static final int INTENSIVE_SEARCH_TRIGGER_THRESHOLD = 16;
        private final IFluidTankProperties[] fluid_props_ = new IFluidTankProperties[]{this};
        private FluidStack tank_ = null;
        private int tick_timer_ = 0;
        private int collection_timer_ = 0;
        private BlockPos last_pick_pos_ = BlockPos.field_177992_a;
        private ArrayList<Vec3i> search_offsets_ = null;
        private int no_fluid_found_counter_ = 0;
        private int intensive_search_counter_ = 0;
        private int total_pick_counter_ = 0;

        public void block_changed() {
            this.tick_timer_ = 10;
        }

        public void readnbt(NBTTagCompound nbt, boolean update_packet) {
            this.tank_ = !nbt.func_74764_b("tank") ? null : FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("tank"));
        }

        protected void writenbt(NBTTagCompound nbt, boolean update_packet) {
            if (this.tank_ != null) {
                nbt.func_74782_a("tank", (NBTBase)this.tank_.writeToNBT(new NBTTagCompound()));
            }
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState os, IBlockState ns) {
            this.block_changed();
            return os.func_177230_c() != ns.func_177230_c() || !(ns.func_177230_c() instanceof BlockDecorFluidFunnel);
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt, false);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt, false);
            return nbt;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability != CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)super.getCapability(capability, facing);
            }
            return (T)((Object)this);
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.fluid_props_;
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null || this.tank_ == null) {
                return null;
            }
            return !this.tank_.isFluidEqual(resource) ? null : this.drain(resource.amount, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.tank_ == null) {
                return null;
            }
            maxDrain = MathHelper.func_76125_a((int)maxDrain, (int)0, (int)this.tank_.amount);
            FluidStack res = this.tank_.copy();
            res.amount = maxDrain;
            if (doDrain) {
                this.tank_.amount -= maxDrain;
            }
            if (this.tank_.amount <= 0) {
                this.tank_ = null;
            }
            return res;
        }

        @Nullable
        public FluidStack getContents() {
            return this.tank_ == null ? null : this.tank_.copy();
        }

        public int getCapacity() {
            return 3000;
        }

        public boolean canFill() {
            return false;
        }

        public boolean canDrain() {
            return true;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return false;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return true;
        }

        private Fluid get_fluid(BlockPos pos) {
            return FluidRegistry.lookupFluidForBlock((Block)this.field_145850_b.func_180495_p(pos).func_177230_c());
        }

        private boolean try_pick(BlockPos pos) {
            IFluidHandler hnd = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)pos, null);
            if (hnd == null) {
                return false;
            }
            FluidStack fs = hnd.drain(this.tank_ == null ? 3000 : 3000 - this.tank_.amount, true);
            if (fs == null) {
                return false;
            }
            if (this.tank_ == null) {
                this.tank_ = fs.copy();
            } else if (this.tank_.isFluidEqual(fs)) {
                this.tank_.amount = MathHelper.func_76125_a((int)(this.tank_.amount + fs.amount), (int)0, (int)3000);
            } else {
                return false;
            }
            this.field_145850_b.func_175698_g(pos);
            this.field_145850_b.func_175685_c(pos, this.field_145850_b.func_180495_p(pos).func_177230_c(), true);
            return true;
        }

        private boolean can_pick(BlockPos pos, Fluid fluid) {
            IFluidHandler hnd = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)pos, null);
            if (hnd == null) {
                return false;
            }
            FluidStack fs = hnd.drain(this.tank_ == null ? 3000 : 3000 - this.tank_.amount, false);
            return fs != null && fs.getFluid().equals(fluid);
        }

        private void rebuild_search_offsets(boolean intensive) {
            this.search_offsets_ = new ArrayList(9);
            this.search_offsets_.add(new Vec3i(0, 1, 0));
            ArrayList<Vec3i> ofs = new ArrayList<Vec3i>(Arrays.asList(new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1)));
            if (intensive || this.total_pick_counter_ > 50) {
                Collections.shuffle(ofs);
            }
            this.search_offsets_.addAll(ofs);
            if (intensive) {
                ofs = new ArrayList<Vec3i>(Arrays.asList(new Vec3i(-1, 1, 0), new Vec3i(1, 1, 0), new Vec3i(0, 1, -1), new Vec3i(0, 1, 1)));
                Collections.shuffle(ofs);
                this.search_offsets_.addAll(ofs);
            }
        }

        private boolean try_collect(BlockPos collection_pos) {
            int max;
            boolean intensive;
            Block collection_block = this.field_145850_b.func_180495_p(collection_pos).func_177230_c();
            if (!(collection_block instanceof IFluidBlock) && !(collection_block instanceof BlockLiquid)) {
                return false;
            }
            Fluid fluid_to_collect = FluidRegistry.lookupFluidForBlock((Block)collection_block);
            if (fluid_to_collect == null) {
                return false;
            }
            if (this.tank_ != null && !this.tank_.getFluid().equals(fluid_to_collect)) {
                return false;
            }
            if (this.try_pick(collection_pos)) {
                this.last_pick_pos_ = collection_pos;
                return true;
            }
            if (this.last_pick_pos_ == null || this.last_pick_pos_.func_177951_i((Vec3i)collection_pos) > 256.0) {
                this.last_pick_pos_ = collection_pos;
                this.search_offsets_ = null;
            }
            BlockPos pos = this.last_pick_pos_;
            HashSet<BlockPos> checked = new HashSet<BlockPos>();
            Stack<BlockPos> trail = new Stack<BlockPos>();
            trail.add(pos);
            checked.add(pos);
            int steps = 0;
            boolean bl = intensive = this.no_fluid_found_counter_ >= 16;
            if (intensive) {
                this.no_fluid_found_counter_ = 0;
                ++this.intensive_search_counter_;
            }
            if (this.search_offsets_ == null) {
                this.rebuild_search_offsets(intensive);
            }
            int n = max = intensive ? 1024 : 72;
            while (++steps <= max) {
                int num_adjacent = 0;
                for (int i = 0; i < this.search_offsets_.size(); ++i) {
                    BlockPos p = pos.func_177971_a(this.search_offsets_.get(i));
                    if (checked.contains(p)) continue;
                    checked.add(p);
                    ++steps;
                    if (!fluid_to_collect.equals(this.get_fluid(p))) continue;
                    ++num_adjacent;
                    pos = p;
                    trail.push(pos);
                    if (steps < 512) {
                        int max_surface_search = 512 - steps;
                        for (int k = 0; k < max_surface_search && this.can_pick(pos.func_177984_a(), fluid_to_collect); ++k) {
                            pos = pos.func_177984_a();
                            trail.push(pos);
                        }
                    }
                    if (!this.try_pick(pos)) continue;
                    this.last_pick_pos_ = pos;
                    this.no_fluid_found_counter_ = 0;
                    this.search_offsets_ = null;
                    if (++this.total_pick_counter_ > 50 && this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                        this.last_pick_pos_ = collection_pos;
                    }
                    return true;
                }
                if (trail.isEmpty()) break;
                if (num_adjacent != 0) continue;
                pos = (BlockPos)trail.pop();
            }
            if (this.intensive_search_counter_ > 2) {
                this.field_145850_b.func_175698_g(pos);
            }
            this.last_pick_pos_ = collection_pos;
            this.search_offsets_ = null;
            ++this.no_fluid_found_counter_;
            return false;
        }

        public void func_73660_a() {
            int fill_level;
            IFluidHandler fh;
            if (this.field_145850_b.field_72995_K || --this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 10;
            this.collection_timer_ += 10;
            IBlockState funnel_state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(funnel_state.func_177230_c() instanceof BlockDecorFluidFunnel)) {
                return;
            }
            boolean dirty = false;
            if (this.collection_timer_ >= 40 && (this.tank_ == null || this.tank_.amount <= 2000)) {
                this.collection_timer_ = 0;
                if (!this.field_145850_b.func_175640_z(this.field_174879_c)) {
                    if (this.last_pick_pos_ == null) {
                        this.last_pick_pos_ = this.field_174879_c.func_177984_a();
                    }
                    if (this.try_collect(this.field_174879_c.func_177984_a())) {
                        dirty = true;
                    }
                }
            }
            if (this.tank_ != null && this.tank_.amount >= 1000 && (fh = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (EnumFacing)EnumFacing.UP)) != null) {
                FluidStack fs = new FluidStack(this.tank_.getFluid(), 1000);
                int nfilled = MathHelper.func_76125_a((int)fh.fill(fs, true), (int)0, (int)1000);
                this.tank_.amount -= nfilled;
                if (this.tank_.amount <= 0) {
                    this.tank_ = null;
                }
                dirty = true;
            }
            int n = fill_level = this.tank_ == null ? 0 : MathHelper.func_76125_a((int)(this.tank_.amount / 1000), (int)0, (int)3);
            if ((Integer)funnel_state.func_177229_b((IProperty)FILL_LEVEL) != fill_level) {
                this.field_145850_b.func_180501_a(this.field_174879_c, funnel_state.func_177226_a((IProperty)FILL_LEVEL, (Comparable)Integer.valueOf(fill_level)), 18);
            }
            if (dirty) {
                this.func_70296_d();
            }
        }
    }
}

