/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wile.engineersdecor.blocks.BlockDecor;
import wile.engineersdecor.detail.ModAuxiliaries;

public class BlockDecorDirected
extends BlockDecor {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    protected final ArrayList<AxisAlignedBB> AABBs;

    public BlockDecorDirected(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound);
        boolean is_horizontal = (config & 2L) != 0L;
        this.AABBs = new ArrayList<AxisAlignedBB>(Arrays.asList(ModAuxiliaries.getRotatedAABB(unrotatedAABB, EnumFacing.DOWN, is_horizontal), ModAuxiliaries.getRotatedAABB(unrotatedAABB, EnumFacing.UP, is_horizontal), ModAuxiliaries.getRotatedAABB(unrotatedAABB, EnumFacing.NORTH, is_horizontal), ModAuxiliaries.getRotatedAABB(unrotatedAABB, EnumFacing.SOUTH, is_horizontal), ModAuxiliaries.getRotatedAABB(unrotatedAABB, EnumFacing.WEST, is_horizontal), ModAuxiliaries.getRotatedAABB(unrotatedAABB, EnumFacing.EAST, is_horizontal), unrotatedAABB, unrotatedAABB));
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (int)((this.config & 0xF00L) >> 8);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.AABBs.get(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() & 7);
    }

    @Override
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Override
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        if (!super.func_176198_a(world, pos, side)) {
            return false;
        }
        return (this.config & 6L) != 2L || side != EnumFacing.UP && side != EnumFacing.DOWN;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if ((this.config & 6L) == 6L) {
            facing = placer.func_174811_aO();
        } else if ((this.config & 6L) == 2L) {
            facing = facing == EnumFacing.UP || facing == EnumFacing.DOWN ? EnumFacing.NORTH : facing;
        } else if ((this.config & 4L) != 0L) {
            facing = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer);
        }
        if ((this.config & 0x10L) != 0L) {
            facing = facing.func_176734_d();
        }
        if ((this.config & 0x40L) != 0L && placer.func_70093_af()) {
            facing = facing.func_176734_d();
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }
}

