/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.mars.world;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class MarsSaveData
extends WorldSavedData {
    private static final String DATA_NAME = "galaxyspace_MarsSaveData";
    public boolean isDustStorm;
    public float prevStormStrength;
    public float stormStrength = 0.0f;
    public int tickDustStorm = 0;
    public int clearWeatherTime = 72000;

    public MarsSaveData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.isDustStorm = nbt.func_74767_n("isDustStorm");
        this.tickDustStorm = nbt.func_74762_e("tickDustStorm");
        this.prevStormStrength = nbt.func_74760_g("prevStormStrength");
        this.stormStrength = nbt.func_74760_g("stormStrength");
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74757_a("isDustStorm", this.isDustStorm);
        compound.func_74768_a("tickDustStorm", this.tickDustStorm);
        compound.func_74776_a("prevStormStrength", this.prevStormStrength);
        compound.func_74776_a("stormStrength", this.stormStrength);
        return compound;
    }

    public static MarsSaveData get(World world) {
        MapStorage storage = world.getPerWorldStorage();
        MarsSaveData instance = (MarsSaveData)storage.func_75742_a(MarsSaveData.class, DATA_NAME);
        if (instance == null) {
            instance = new MarsSaveData(DATA_NAME);
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }

    public float getStormStrength(float delta) {
        return this.prevStormStrength + (this.stormStrength - this.prevStormStrength) * delta;
    }
}

