/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.hooks;

import asmodeuscore.api.dimension.IAdvancedSpace;
import galaxyspace.api.block.IEnergyGeyser;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.events.SetBlockEvent;
import galaxyspace.core.events.UpdateBlockEvent;
import galaxyspace.core.hooklib.asm.Hook;
import galaxyspace.core.hooklib.asm.ReturnCondition;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemBasicGS;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.item.IItemThermal;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityAlienVillager;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.DamageSourceGC;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityCreeperBoss;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityGasLiquefier;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityMethaneSynthesizer;
import micdoodle8.mods.galacticraft.planets.venus.VenusBlocks;
import micdoodle8.mods.galacticraft.planets.venus.VenusModule;
import micdoodle8.mods.galacticraft.planets.venus.dimension.WorldProviderVenus;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntityGeothermalGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class GSHooksManager {
    private static final EntityAlienVillager.ITradeList[] DEFAULT_TRADE_LIST_MAP = new EntityAlienVillager.ITradeList[]{new EntityAlienVillager.ItemAndEmeraldToItem(new ItemStack(GCItems.schematic, 1, 1), new EntityAlienVillager.PriceInfo(40, 55), ItemBasicGS.BasicItems.SCHEMATIC_BOX.getItemStack()), new EntityAlienVillager.ListItemForEmeralds(new ItemStack(GCItems.oxMask, 1, 0), new EntityAlienVillager.PriceInfo(1, 2)), new EntityAlienVillager.ListItemForEmeralds(new ItemStack(GCItems.oxTankLight, 1, 235), new EntityAlienVillager.PriceInfo(3, 4)), new EntityAlienVillager.ListItemForEmeralds(new ItemStack(GCItems.oxygenGear, 1, 0), new EntityAlienVillager.PriceInfo(3, 4)), new EntityAlienVillager.ListItemForEmeralds(new ItemStack(GCItems.fuelCanister, 1, 317), new EntityAlienVillager.PriceInfo(3, 4)), new EntityAlienVillager.ListItemForEmeralds(new ItemStack(GCItems.parachute, 1, 0), new EntityAlienVillager.PriceInfo(1, 2)), new EntityAlienVillager.ListItemForEmeralds(new ItemStack(GCItems.battery, 1, 58), new EntityAlienVillager.PriceInfo(2, 4)), new EntityAlienVillager.ItemAndEmeraldToItem(new ItemStack(GCItems.oilCanister, 1, 1001), new EntityAlienVillager.PriceInfo(1, 1), new ItemStack(GCItems.foodItem, 1, 1)), new EntityAlienVillager.ListItemForEmeralds(new ItemStack(GCItems.basicItem, 1, 13), new EntityAlienVillager.PriceInfo(3, 4)), new EntityAlienVillager.ItemAndEmeraldToItem(new ItemStack(GCItems.schematic, 1, 0), new EntityAlienVillager.PriceInfo(3, 5), new ItemStack(GCItems.schematic, 1, 1)), new EntityAlienVillager.ItemAndEmeraldToItem(new ItemStack(GCItems.schematic, 1, 1), new EntityAlienVillager.PriceInfo(3, 5), new ItemStack(GCItems.schematic, 1, 0)), new EntityAlienVillager.ItemAndEmeraldToItem(new ItemStack(GCItems.basicItem, 2, 3), new EntityAlienVillager.PriceInfo(1, 1), new ItemStack(GCItems.basicItem, 1, 6)), new EntityAlienVillager.ItemAndEmeraldToItem(new ItemStack(GCItems.basicItem, 2, 4), new EntityAlienVillager.PriceInfo(1, 1), new ItemStack(GCItems.basicItem, 1, 7)), new EntityAlienVillager.EmeraldForItems(new ItemStack(Blocks.field_150345_g, 1, 3), new EntityAlienVillager.PriceInfo(11, 39))};

    @Hook(returnCondition=ReturnCondition.ON_TRUE, booleanReturnConstant=false)
    public static boolean setBlockState(World world, BlockPos pos, IBlockState newState, int flags) {
        return MinecraftForge.EVENT_BUS.post((Event)new SetBlockEvent(world, pos, newState, flags));
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS, isMandatory=true)
    public static void randomTick(Block block, World worldIn, BlockPos pos, IBlockState state, Random rand) {
        UpdateBlockEvent event = new UpdateBlockEvent(worldIn, pos, state, rand);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            block.func_180650_b(worldIn, pos, state, rand);
        }
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static int getAirProducts(TileEntityMethaneSynthesizer te) {
        WorldProvider WP = te.func_145831_w().field_73011_w;
        if (WP instanceof IGalacticraftWorldProvider) {
            ArrayList atmos = ((IGalacticraftWorldProvider)WP).getCelestialBody().atmosphere.composition;
            if (atmos.contains(EnumAtmosphericGas.CO2)) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static int getAirProducts(TileEntityGasLiquefier te) {
        WorldProvider WP = te.func_145831_w().field_73011_w;
        if (WP instanceof IGalacticraftWorldProvider) {
            int result = 0;
            ArrayList atmos = ((IGalacticraftWorldProvider)WP).getCelestialBody().atmosphere.composition;
            if (atmos.size() > 0) {
                result = te.getIdFromName(((EnumAtmosphericGas)atmos.get(0)).name().toLowerCase()) + 1;
            }
            if (atmos.size() > 1) {
                result += 16 * (te.getIdFromName(((EnumAtmosphericGas)atmos.get(1)).name().toLowerCase()) + 1);
            }
            if (atmos.size() > 2) {
                result += 256 * (te.getIdFromName(((EnumAtmosphericGas)atmos.get(2)).name().toLowerCase()) + 1);
            }
            return result;
        }
        return 35;
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static void checkThermalStatus(GCPlayerHandler handler, EntityPlayerMP player, GCPlayerStats playerStats) {
        if (player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && !player.field_71075_bZ.field_75098_d && !CompatibilityManager.isAndroid((EntityPlayer)player)) {
            float absThermalLevelMod;
            ItemStack thermalPaddingHelm = playerStats.getExtendedInventory().func_70301_a(6);
            ItemStack thermalPaddingChestplate = playerStats.getExtendedInventory().func_70301_a(7);
            ItemStack thermalPaddingLeggings = playerStats.getExtendedInventory().func_70301_a(8);
            ItemStack thermalPaddingBoots = playerStats.getExtendedInventory().func_70301_a(9);
            float lowestThermalStrength = 0.0f;
            if (!(thermalPaddingHelm.func_190926_b() || thermalPaddingChestplate.func_190926_b() || thermalPaddingLeggings.func_190926_b() || thermalPaddingBoots.func_190926_b())) {
                if (thermalPaddingHelm.func_77973_b() instanceof IItemThermal) {
                    lowestThermalStrength += (float)((IItemThermal)thermalPaddingHelm.func_77973_b()).getThermalStrength();
                }
                if (thermalPaddingChestplate.func_77973_b() instanceof IItemThermal) {
                    lowestThermalStrength += (float)((IItemThermal)thermalPaddingChestplate.func_77973_b()).getThermalStrength();
                }
                if (thermalPaddingLeggings.func_77973_b() instanceof IItemThermal) {
                    lowestThermalStrength += (float)((IItemThermal)thermalPaddingLeggings.func_77973_b()).getThermalStrength();
                }
                if (thermalPaddingBoots.func_77973_b() instanceof IItemThermal) {
                    lowestThermalStrength += (float)((IItemThermal)thermalPaddingBoots.func_77973_b()).getThermalStrength();
                }
                lowestThermalStrength /= 4.0f;
                lowestThermalStrength = Math.abs(lowestThermalStrength);
            }
            IGalacticraftWorldProvider provider = (IGalacticraftWorldProvider)player.field_70170_p.field_73011_w;
            float thermalLevelMod = provider.getThermalLevelModifier();
            if (player.field_70170_p.field_73011_w instanceof IAdvancedSpace) {
                provider = (IAdvancedSpace)player.field_70170_p.field_73011_w;
                thermalLevelMod = ((IAdvancedSpace)provider).getThermalLevelModifier((EntityPlayer)player);
            }
            if ((double)(absThermalLevelMod = Math.abs(thermalLevelMod)) > 0.0) {
                int thermalLevelTickCooldownSingle;
                int thermalLevelCooldownBase = Math.abs(MathHelper.func_76141_d((float)(200.0f / thermalLevelMod)));
                int normaliseCooldown = MathHelper.func_76141_d((float)(150.0f / lowestThermalStrength));
                int thermalLevelTickCooldown = thermalLevelCooldownBase;
                if (thermalLevelTickCooldown < 1) {
                    thermalLevelTickCooldown = 1;
                }
                if (!(thermalPaddingHelm.func_190926_b() || thermalPaddingChestplate.func_190926_b() || thermalPaddingLeggings.func_190926_b() || thermalPaddingBoots.func_190926_b())) {
                    float relativeFactor = Math.max(1.0f, absThermalLevelMod / lowestThermalStrength) / 1.5f;
                    if ((normaliseCooldown = MathHelper.func_76141_d((float)((float)normaliseCooldown / absThermalLevelMod * relativeFactor))) < 1) {
                        normaliseCooldown = 1;
                    }
                    if ((player.field_70173_aa - 1) % normaliseCooldown == 0) {
                        handler.normaliseThermalLevel(player, playerStats, 1);
                    }
                    absThermalLevelMod = Math.abs(thermalLevelMod /= Math.max(1.0f, lowestThermalStrength / 2.0f));
                }
                if (OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player, (boolean)true)) {
                    playerStats.setThermalLevelNormalising(true);
                    handler.normaliseThermalLevel(player, playerStats, 1);
                    return;
                }
                if (!thermalPaddingHelm.func_190926_b()) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
                if (!thermalPaddingChestplate.func_190926_b()) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
                if (!thermalPaddingLeggings.func_190926_b()) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
                if (!thermalPaddingBoots.func_190926_b()) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
                if ((thermalLevelTickCooldownSingle = MathHelper.func_76141_d((float)((float)thermalLevelTickCooldown / absThermalLevelMod))) < 1) {
                    thermalLevelTickCooldownSingle = 1;
                }
                if ((player.field_70173_aa - 1) % thermalLevelTickCooldownSingle == 0) {
                    int last = playerStats.getThermalLevel();
                    playerStats.setThermalLevel(Math.min(Math.max(last + (thermalLevelMod < 0.0f ? -1 : 1), -22), 22));
                    if (playerStats.getThermalLevel() != last) {
                        GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_THERMAL_LEVEL, GCCoreUtil.getDimensionID((World)player.field_70170_p), new Object[]{playerStats.getThermalLevel(), playerStats.isThermalLevelNormalising()}), player);
                    }
                }
                playerStats.setThermalLevelNormalising(thermalLevelTickCooldownSingle > normaliseCooldown && !thermalPaddingHelm.func_190926_b() && !thermalPaddingChestplate.func_190926_b() && !thermalPaddingLeggings.func_190926_b() && !thermalPaddingBoots.func_190926_b());
                if (!playerStats.isThermalLevelNormalising()) {
                    if ((player.field_70173_aa - 1) % thermalLevelTickCooldown == 0 && Math.abs(playerStats.getThermalLevel()) >= 22) {
                        player.func_70097_a((DamageSource)DamageSourceGC.thermal, 1.5f);
                    }
                    if (playerStats.getThermalLevel() < -15) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 5, 2, true, true));
                    }
                    if (playerStats.getThermalLevel() > 15) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 5, 2, true, true));
                    }
                }
            } else {
                playerStats.setThermalLevelNormalising(true);
                handler.normaliseThermalLevel(player, playerStats, 2);
            }
        } else {
            playerStats.setThermalLevelNormalising(true);
            handler.normaliseThermalLevel(player, playerStats, 3);
        }
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static double getSolarEnergyMultiplier(WorldProviderVenus wp) {
        return 0.0;
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static ItemStack getGuaranteedLoot(EntityCreeperBoss creeper, Random rand) {
        LinkedList stackList = new LinkedList();
        stackList.addAll(GalacticraftRegistry.getDungeonLoot((int)2));
        return ((ItemStack)stackList.get(rand.nextInt(stackList.size()))).func_77946_l();
    }

    @Hook(injectOnLine=59, returnCondition=ReturnCondition.ALWAYS)
    public static void update(TileEntityGeothermalGenerator te) {
        if (te.ticks % 20 == 0) {
            BlockPos pos1;
            BlockPos below = te.func_174877_v().func_177977_b();
            IBlockState stateBelow = te.func_145831_w().func_180495_p(below);
            boolean lastValidSpout = (Boolean)ReflectionHelper.getPrivateValue(TileEntityGeothermalGenerator.class, (Object)te, (String[])new String[]{"validSpout"});
            boolean validSpoutHook = false;
            ReflectionHelper.setPrivateValue(TileEntityGeothermalGenerator.class, (Object)te, (Object)validSpoutHook, (String[])new String[]{"validSpout"});
            if (stateBelow.func_177230_c() instanceof IEnergyGeyser) {
                pos1 = below.func_177977_b();
                while (te.func_174877_v().func_177956_o() - pos1.func_177956_o() < 20) {
                    IBlockState state = te.func_145831_w().func_180495_p(pos1);
                    IEnergyGeyser geyser = (IEnergyGeyser)stateBelow.func_177230_c();
                    boolean work = geyser.isWorkGeyser(te.func_145831_w(), stateBelow, below);
                    if (work) {
                        validSpoutHook = true;
                        ReflectionHelper.setPrivateValue(TileEntityGeothermalGenerator.class, (Object)te, (Object)validSpoutHook, (String[])new String[]{"validSpout"});
                    } else if (state.func_177230_c().isAir(te.func_145831_w().func_180495_p(pos1), (IBlockAccess)te.func_145831_w(), pos1)) {
                        pos1 = pos1.func_177977_b();
                        continue;
                    }
                    break;
                }
            } else if (stateBelow.func_177230_c() == VenusBlocks.spout) {
                pos1 = below.func_177977_b();
                while (te.func_174877_v().func_177956_o() - pos1.func_177956_o() < 20) {
                    IBlockState state = te.func_145831_w().func_180495_p(pos1);
                    if (state.func_177230_c() == VenusModule.sulphuricAcid.getBlock()) {
                        validSpoutHook = true;
                        ReflectionHelper.setPrivateValue(TileEntityGeothermalGenerator.class, (Object)te, (Object)validSpoutHook, (String[])new String[]{"validSpout"});
                    } else if (state.func_177230_c().isAir(te.func_145831_w().func_180495_p(pos1), (IBlockAccess)te.func_145831_w(), pos1)) {
                        pos1 = pos1.func_177977_b();
                        continue;
                    }
                    break;
                }
            }
            if (te.func_145831_w().field_72995_K && validSpoutHook != lastValidSpout) {
                IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
                te.func_145831_w().func_184138_a(te.func_174877_v(), state, state, 3);
            }
        }
        if (!te.func_145831_w().field_72995_K) {
            te.recharge((ItemStack)te.getInventory().get(0));
            if (te.disableCooldown > 0) {
                --te.disableCooldown;
            }
            te.generateWatts = Math.min(Math.max(GSHooksManager.getGenerate(te, (Boolean)ReflectionHelper.getPrivateValue(TileEntityGeothermalGenerator.class, (Object)te, (String[])new String[]{"validSpout"})), 0), 200);
        } else if (te.generateWatts > 0) {
            if (te.ticks % ((int)(200.0f / (float)(te.generateWatts + 1)) * 5 + 1) == 0) {
                double posX = (double)te.func_174877_v().func_177958_n() + 0.5;
                double posY = (double)te.func_174877_v().func_177956_o() + 1.0;
                double posZ = (double)te.func_174877_v().func_177952_p() + 0.5;
                GalacticraftPlanets.spawnParticle((String)"acidExhaust", (Vector3)new Vector3(posX - 0.25, posY, posZ - 0.25), (Vector3)new Vector3(0.0, 0.025, 0.0), (Object[])new Object[0]);
                GalacticraftPlanets.spawnParticle((String)"acidExhaust", (Vector3)new Vector3(posX - 0.25, posY, posZ), (Vector3)new Vector3(0.0, 0.025, 0.0), (Object[])new Object[0]);
                GalacticraftPlanets.spawnParticle((String)"acidExhaust", (Vector3)new Vector3(posX - 0.25, posY, posZ + 0.25), (Vector3)new Vector3(0.0, 0.025, 0.0), (Object[])new Object[0]);
                GalacticraftPlanets.spawnParticle((String)"acidExhaust", (Vector3)new Vector3(posX, posY, posZ - 0.25), (Vector3)new Vector3(0.0, 0.025, 0.0), (Object[])new Object[0]);
                GalacticraftPlanets.spawnParticle((String)"acidExhaust", (Vector3)new Vector3(posX, posY, posZ), (Vector3)new Vector3(0.0, 0.025, 0.0), (Object[])new Object[0]);
                GalacticraftPlanets.spawnParticle((String)"acidExhaust", (Vector3)new Vector3(posX, posY, posZ + 0.25), (Vector3)new Vector3(0.0, 0.025, 0.0), (Object[])new Object[0]);
                GalacticraftPlanets.spawnParticle((String)"acidExhaust", (Vector3)new Vector3(posX + 0.25, posY, posZ - 0.25), (Vector3)new Vector3(0.0, 0.025, 0.0), (Object[])new Object[0]);
                GalacticraftPlanets.spawnParticle((String)"acidExhaust", (Vector3)new Vector3(posX + 0.25, posY, posZ), (Vector3)new Vector3(0.0, 0.025, 0.0), (Object[])new Object[0]);
                GalacticraftPlanets.spawnParticle((String)"acidExhaust", (Vector3)new Vector3(posX + 0.25, posY, posZ + 0.25), (Vector3)new Vector3(0.0, 0.025, 0.0), (Object[])new Object[0]);
            }
        }
        te.produce();
    }

    private static int getGenerate(TileEntityGeothermalGenerator te, boolean valid) {
        if (te.getDisabled(0)) {
            return 0;
        }
        if (!valid) {
            return 0;
        }
        int diff = 170;
        return (int)Math.floor((Math.sin((float)te.ticks / 50.0f) * 0.5 + 0.5) * (double)diff + 30.0);
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static float getGravity(WorldProviderAsteroids wp) {
        if (GSConfigCore.enableZeroGravityOnAsteroids) {
            return 0.08f;
        }
        return 0.072f;
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static void populateBuyingList(EntityAlienVillager e) {
        MerchantRecipeList buyingList = (MerchantRecipeList)ReflectionHelper.getPrivateValue(EntityAlienVillager.class, (Object)e, (String[])new String[]{"buyingList"});
        if (buyingList == null) {
            buyingList = new MerchantRecipeList();
        }
        for (EntityAlienVillager.ITradeList tradeList : DEFAULT_TRADE_LIST_MAP) {
            tradeList.modifyMerchantRecipeList(buyingList, e.func_130014_f_().field_73012_v);
        }
        ReflectionHelper.setPrivateValue(EntityAlienVillager.class, (Object)e, (Object)buyingList, (String[])new String[]{"buyingList"});
    }
}

