/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.gui.widgets;

import com.google.common.collect.ImmutableSet;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IFilterLogic;
import forestry.api.genetics.IFilterRuleType;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.SoundUtil;
import forestry.core.utils.Translator;
import forestry.sorting.gui.GuiGeneticFilter;
import forestry.sorting.gui.ISelectableProvider;
import forestry.sorting.gui.widgets.SelectionWidget;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.EnumFacing;

public class RuleWidget
extends Widget
implements ISelectableProvider<IFilterRuleType> {
    private static final ImmutableSet<IFilterRuleType> ENTRIES = RuleWidget.createEntries();
    private final EnumFacing facing;
    private final GuiGeneticFilter gui;

    public RuleWidget(WidgetManager manager, int xPos, int yPos, EnumFacing facing, GuiGeneticFilter gui) {
        super(manager, xPos, yPos);
        this.facing = facing;
        this.gui = gui;
    }

    @Override
    public void draw(int startX, int startY) {
        int x = this.xPos + startX;
        int y = this.yPos + startY;
        IFilterLogic logic = this.gui.getLogic();
        IFilterRuleType rule = logic.getRule(this.facing);
        this.draw(this.manager.gui, rule, x, y);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        if (this.gui.selection.isSame(this)) {
            textureManager.func_110577_a(SelectionWidget.TEXTURE);
            this.gui.func_73729_b(x - 1, y - 1, 212, 0, 18, 18);
        }
    }

    @Override
    public Collection<IFilterRuleType> getEntries() {
        return ENTRIES;
    }

    @Override
    public void draw(GuiForestry gui, IFilterRuleType selectable, int x, int y) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(selectable.getTextureMap());
        TextureAtlasSprite sprite = selectable.getSprite();
        gui.func_175175_a(x, y, sprite, 16, 16);
    }

    @Override
    public String getName(IFilterRuleType selectable) {
        return Translator.translateToLocal("for.gui.filter." + selectable.getUID());
    }

    @Override
    public void onSelect(IFilterRuleType selectable) {
        IFilterLogic logic = this.gui.getLogic();
        if (logic.setRule(this.facing, selectable)) {
            logic.sendToServer(this.facing, selectable);
        }
        if (this.gui.selection.isSame(this)) {
            this.gui.onModuleClick(this);
        }
        SoundUtil.playButtonClick();
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 1) {
            this.onSelect(AlleleManager.filterRegistry.getDefaultRule());
        } else {
            SoundUtil.playButtonClick();
            this.gui.onModuleClick(this);
        }
    }

    @Override
    public ToolTip getToolTip(int mouseX, int mouseY) {
        IFilterLogic logic = this.gui.getLogic();
        IFilterRuleType rule = logic.getRule(this.facing);
        ToolTip tooltip = new ToolTip();
        tooltip.add(this.getName(rule));
        return tooltip;
    }

    private static ImmutableSet<IFilterRuleType> createEntries() {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (IFilterRuleType rule : AlleleManager.filterRegistry.getRules()) {
            entries.add((Object)rule);
        }
        return entries.build();
    }
}

