/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.inventory;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.items.misc.ItemEncodedPattern;
import appeng.util.Platform;
import io.github.phantamanta44.libnine.util.TriBool;
import io.github.phantamanta44.threng.inventory.base.ContainerTile;
import io.github.phantamanta44.threng.inventory.slot.IDisplayModeSlot;
import io.github.phantamanta44.threng.tile.TileBigAssemblerCore;
import io.github.phantamanta44.threng.tile.TileBigAssemblerPatternStore;
import io.github.phantamanta44.threng.util.ISearchable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerBigAssembler
extends ContainerTile<TileBigAssemblerCore> {
    private final Page[] pages;

    public ContainerBigAssembler(EntityPlayer player, World world, int x, int y, int z) {
        this(player.field_71071_by, (TileBigAssemblerCore)Objects.requireNonNull(world.func_175625_s(new BlockPos(x, y, z))));
    }

    public ContainerBigAssembler(InventoryPlayer ipl, TileBigAssemblerCore tile) {
        super(tile, ipl, 217);
        List<TileBigAssemblerPatternStore> patternStores = tile.getPatternStores();
        this.pages = new Page[patternStores.size()];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = new Page(patternStores.get(i).getPatternInventory());
        }
    }

    public TileBigAssemblerCore getAssemblerCore() {
        return (TileBigAssemblerCore)this.tile;
    }

    public Page getPage(int pageNum) {
        return this.pages[pageNum];
    }

    public int getPageCount() {
        return this.pages.length;
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return super.func_75145_c(player) && ((TileBigAssemblerCore)this.tile).isActive();
    }

    public class Page {
        private boolean active = true;

        Page(IItemHandlerModifiable patternInv) {
            for (int row = 0; row < 4; ++row) {
                for (int col = 0; col < 9; ++col) {
                    int index = row * 9 + col;
                    ContainerBigAssembler.this.func_75146_a((Slot)new SlotPage(patternInv, index, 8 + col * 18, 18 + row * 18));
                }
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        private class SlotPage
        extends SlotItemHandler
        implements IDisplayModeSlot,
        ISearchable {
            private boolean displayMode;
            @Nullable
            private String searchQuery;
            private TriBool matchesQuery;
            @Nullable
            private List<String> resultNames;

            public SlotPage(IItemHandlerModifiable patternInv, int index, int posX, int posY) {
                super((IItemHandler)patternInv, index, posX, posY);
                this.displayMode = false;
                this.searchQuery = null;
                this.matchesQuery = TriBool.NONE;
                this.resultNames = null;
            }

            public boolean func_111238_b() {
                return Page.this.active;
            }

            @Override
            public void prepareDisplayMode() {
                this.displayMode = true;
            }

            @Override
            public void updateSearchQuery(@Nullable String query) {
                this.searchQuery = query;
                this.matchesQuery = TriBool.NONE;
            }

            @Override
            public boolean matchesQuery() {
                if (this.matchesQuery == TriBool.NONE) {
                    if (this.searchQuery == null || this.searchQuery.isEmpty()) {
                        this.matchesQuery = TriBool.TRUE;
                        return true;
                    }
                    ItemStack stack = this.func_75211_c();
                    if (stack.func_190926_b()) {
                        this.matchesQuery = TriBool.FALSE;
                        return false;
                    }
                    if (this.resultNames == null) {
                        ICraftingPatternDetails pattern;
                        this.resultNames = stack.func_77973_b() instanceof ICraftingPatternItem && (pattern = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, ((TileBigAssemblerCore)ContainerBigAssembler.this.tile).func_145831_w())) != null ? Arrays.stream(pattern.getCondensedOutputs()).map(o -> Platform.getItemDisplayName((Object)o).toLowerCase()).collect(Collectors.toList()) : Collections.emptyList();
                    }
                    for (String name : this.resultNames) {
                        if (!name.contains(this.searchQuery)) continue;
                        this.matchesQuery = TriBool.TRUE;
                        return true;
                    }
                    this.matchesQuery = TriBool.FALSE;
                    return false;
                }
                return this.matchesQuery.value;
            }

            public ItemStack func_75211_c() {
                if (this.displayMode) {
                    ItemStack outputStack;
                    ItemStack stack;
                    this.displayMode = false;
                    if (Platform.isClient() && !(stack = super.func_75211_c()).func_190926_b() && stack.func_77973_b() instanceof ItemEncodedPattern && !(outputStack = ((ItemEncodedPattern)stack.func_77973_b()).getOutput(stack)).func_190926_b()) {
                        return outputStack;
                    }
                }
                return super.func_75211_c();
            }

            public void func_75215_d(@Nonnull ItemStack stack) {
                super.func_75215_d(stack);
                this.resultNames = null;
                this.matchesQuery = TriBool.NONE;
            }

            @Nonnull
            public ItemStack func_75209_a(int amount) {
                ItemStack extracted = super.func_75209_a(amount);
                this.resultNames = null;
                this.matchesQuery = TriBool.NONE;
                return extracted;
            }
        }
    }
}

