/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.integration;

import io.github.phantamanta44.threng.ThrEng;
import io.github.phantamanta44.threng.integration.IntegrationModule;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class IntegrationManager {
    private final List<IntegrationModule> integrations = new ArrayList<IntegrationModule>();

    public void load(ASMDataTable asmTable) {
        for (ASMDataTable.ASMData asmData : asmTable.getAll(IntegrationModule.Register.class.getName())) {
            String modId = (String)asmData.getAnnotationInfo().get("value");
            if (Loader.isModLoaded((String)modId)) {
                ThrEng.LOGGER.info("Loading mod integration: {}", (Object)modId);
                try {
                    this.integrations.add((IntegrationModule)Class.forName(asmData.getClassName()).newInstance());
                }
                catch (Exception e) {
                    ThrEng.LOGGER.error("Failed to load integration!", (Throwable)e);
                }
                continue;
            }
            ThrEng.LOGGER.info("Skipping missing mod for integration: {}", (Object)modId);
        }
    }

    public void init() {
        for (IntegrationModule module : this.integrations) {
            try {
                ThrEng.LOGGER.info("Initializing mod integration: {}", (Object)module.getClass().getSimpleName());
                module.init();
            }
            catch (Exception e) {
                ThrEng.LOGGER.error("Failed to initialize integration!", (Throwable)e);
            }
        }
    }
}

