/*
 * Decompiled with CFR 0.152.
 */
package tinkersoc.furnace;

import java.util.HashMap;
import li.cil.oc.api.API;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.smeltery.tileentity.TileSearedFurnace;
import tinkersoc.AbstractTinkersEnvironment;

public class EnvironmentTinkerFurnace
extends AbstractTinkersEnvironment<TileSearedFurnace> {
    public EnvironmentTinkerFurnace(TileSearedFurnace furnace) {
        super("seared_furnace", furnace);
    }

    @Callback(doc="function():table - Get information on the furnace's current fuel")
    public Object[] getFuelInfo(Context context, Arguments arguments) {
        final FluidStack stack = ((TileSearedFurnace)this.tile).currentFuel;
        return new Object[]{new HashMap<String, Object>(){
            {
                this.put("fluid", stack);
                this.put("heat", stack.getFluid().getTemperature());
                this.put("maxCap", stack.amount);
            }
        }};
    }

    @Callback(doc="function():int - Gets the amount of fuel in the furnace")
    public Object[] getFuelLevel(Context context, Arguments arguments) {
        return new Object[]{((TileSearedFurnace)this.tile).currentFuel.amount};
    }

    @Callback(doc="function([index:int]):int - Gets the furnace temperature or the temperature of an item being smelted")
    public Object[] getTemperature(Context context, Arguments arguments) {
        if (arguments.count() == 0) {
            return new Object[]{((TileSearedFurnace)this.tile).getTemperature()};
        }
        return new Object[]{((TileSearedFurnace)this.tile).getTemperature(arguments.checkInteger(0))};
    }

    @Callback(doc="function(index:int) - Returns whether the item in the specified slot can be heated")
    public Object[] canHeat(Context context, Arguments arguments) {
        return new Object[]{((TileSearedFurnace)this.tile).canHeat(arguments.checkInteger(0))};
    }

    @Callback(doc="function():int - Gets the number of smelting slots the furnace has")
    public Object[] getInventorySize(Context context, Arguments arguments) {
        return new Object[]{((TileSearedFurnace)this.tile).func_70302_i_()};
    }

    @Callback(doc="function(index:int):int - Gets the required temperature for the item in the specified slot")
    public Object[] getTempRequired(Context context, Arguments arguments) {
        return new Object[]{((TileSearedFurnace)this.tile).getTempRequired(arguments.checkInteger(0))};
    }

    @Callback(doc="function():boolean - Gets whether the furnace has fuel")
    public Object[] hasFuel(Context context, Arguments arguments) {
        return new Object[]{((TileSearedFurnace)this.tile).hasFuel()};
    }

    @Callback(doc="function(index:int):table - Gets the stack in the specified slot")
    public Object[] getStackInSlot(Context context, Arguments arguments) {
        if (!API.config.getBoolean("misc.allowItemStackInspection")) {
            return new Object[]{null, "ItemStack inspection disabled in OC config"};
        }
        int slot = arguments.checkInteger(0);
        if (slot < 1 || slot > ((TileSearedFurnace)this.tile).func_70302_i_()) {
            return new Object[]{null, "Invalid slot"};
        }
        ItemStack stack = ((TileSearedFurnace)this.tile).getItemHandler().getStackInSlot(--slot);
        if (stack.func_190926_b()) {
            return new Object[]{null, "No item"};
        }
        return new Object[]{stack};
    }

    @Callback(doc="function(index:int):number - Gets the heating progress of the item in the specified slot")
    public Object[] getHeatingProgress(Context context, Arguments arguments) {
        return new Object[]{Float.valueOf(((TileSearedFurnace)this.tile).getHeatingProgress(arguments.checkInteger(0)))};
    }
}

