/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med.logic;

import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.api.classic.reactor.ISteamReactor;
import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.block.machine.med.logic.ReactorLogicBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public abstract class SteamReactorLogicBase
extends ReactorLogicBase
implements ISteamReactor {
    FluidTank waterTank = new FluidTank(2000);
    FluidTank steamTank = new FluidTank(20000);
    public long totalUsedWater = 0L;
    public long totalProducedSteam = 0L;
    public int lastSteamProduction = 0;

    public SteamReactorLogicBase(TileEntityReactorPlanner tile) {
        super(tile);
    }

    @Override
    public void clear() {
        super.clear();
        this.totalUsedWater = 0L;
        this.totalProducedSteam = 0L;
    }

    @Override
    public void reset() {
        this.totalUsedWater = 0L;
        this.totalProducedSteam = 0L;
    }

    @Override
    public void validate() {
        this.waterTank.fillInternal(new FluidStack(FluidRegistry.WATER, Integer.MAX_VALUE), true);
        this.steamTank.drainInternal(Integer.MAX_VALUE, true);
        this.totalUsedWater = 0L;
        this.totalProducedSteam = 0L;
        this.lastSteamProduction = 0;
    }

    public void updateTanks() {
        this.totalUsedWater += (long)this.waterTank.fillInternal(new FluidStack(FluidRegistry.WATER, Integer.MAX_VALUE), true);
        FluidStack steam = this.steamTank.drainInternal(Integer.MAX_VALUE, true);
        this.lastSteamProduction = 0;
        if (steam != null) {
            this.totalProducedSteam += (long)steam.amount;
            this.lastSteamProduction = steam.amount;
        }
    }

    @Override
    public boolean isSteamLogic() {
        return true;
    }

    @Override
    public FluidTank getWaterTank() {
        return this.waterTank;
    }

    @Override
    public FluidTank getSteamTank() {
        return this.steamTank;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.waterTank.readFromNBT(nbt.func_74775_l("WaterTank"));
        this.steamTank.readFromNBT(nbt.func_74775_l("SteamTank"));
        this.totalUsedWater = nbt.func_74763_f("TotalWater");
        this.totalProducedSteam = nbt.func_74763_f("TotalSteam");
        this.lastSteamProduction = nbt.func_74762_e("LastSteam");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.waterTank.writeToNBT(this.getTag(nbt, "WaterTank"));
        this.steamTank.writeToNBT(this.getTag(nbt, "SteamTank"));
        nbt.func_74772_a("TotalWater", this.totalUsedWater);
        nbt.func_74772_a("TotalSteam", this.totalProducedSteam);
        nbt.func_74768_a("LastSteam", this.lastSteamProduction);
    }

    @Override
    public void read(IInputBuffer buffer) {
        super.read(buffer);
        this.totalUsedWater = buffer.readLong();
        this.totalProducedSteam = buffer.readLong();
        this.lastSteamProduction = buffer.readInt();
    }

    @Override
    public void write(IOutputBuffer buffer) {
        super.write(buffer);
        buffer.writeLong(this.totalUsedWater);
        buffer.writeLong(this.totalProducedSteam);
        buffer.writeInt(this.lastSteamProduction);
    }

    @Override
    public void readStateFromNBT(NBTTagCompound nbt) {
        super.readStateFromNBT(nbt);
        this.waterTank.readFromNBT(nbt.func_74775_l("WaterTank"));
        this.steamTank.readFromNBT(nbt.func_74775_l("SteamTank"));
        this.totalUsedWater = nbt.func_74763_f("TotalWater");
        this.totalProducedSteam = nbt.func_74763_f("TotalSteam");
        this.lastSteamProduction = nbt.func_74762_e("LastSteam");
    }

    @Override
    public void writeStateToNBT(NBTTagCompound nbt) {
        super.writeStateToNBT(nbt);
        this.waterTank.writeToNBT(this.getTag(nbt, "WaterTank"));
        this.steamTank.writeToNBT(this.getTag(nbt, "SteamTank"));
        nbt.func_74772_a("TotalWater", this.totalUsedWater);
        nbt.func_74772_a("TotalSteam", this.totalProducedSteam);
        nbt.func_74768_a("LastSteam", this.lastSteamProduction);
    }
}

