/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med;

import ic2.api.classic.network.adv.IBitLevelOverride;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.machine.med.container.ContainerCropHarvester;
import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.inventory.transport.wrapper.InventoryWrapper;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.util.helpers.AabbUtil;
import ic2.core.util.math.MathUtil;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityCropHarvester
extends TileEntityElecMachine
implements ITickable,
IHasGui,
IBitLevelOverride {
    public static AabbUtil.IBlockFilter filter = new CropFilter();
    public PersonalInventory inv = new PersonalInventory(5);
    LinkedList<BlockPos> todoList = new LinkedList();
    LinkedList<ItemStack> items = new LinkedList();
    public int nextDelay = 10;
    public int delay = 0;
    public int radius = 1;
    IItemTransporter transporter = null;

    public TileEntityCropHarvester() {
        super(9, 128);
        this.maxEnergy = 50000;
        this.inv.setMaxStackSize(1);
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        int[] array = MathUtil.fromTo(0, 9);
        handler.registerDefaultSideAccess(AccessRule.Export, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Export, array);
        handler.registerDefaultSlotsForSide(RotationList.ALL, array);
        handler.registerSlotType(SlotType.Output, array);
    }

    @Override
    public NetworkField.BitLevel getOverride(int fieldID, String fieldName) {
        return NetworkField.BitLevel.Bit24;
    }

    @Override
    public boolean hasOverride(int fieldID, String fieldName) {
        return fieldID == 3 || fieldID == 4;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerCropHarvester(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.cropHarvester;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.todoList.clear();
        this.items.clear();
        this.delay = nbt.func_74762_e("Delay");
        this.radius = nbt.func_74762_e("Radius");
        this.nextDelay = nbt.func_74762_e("NextDelay");
        this.inv.readFromNBT(nbt.func_74775_l("Upgrades"));
        NBTTagList posList = nbt.func_150295_c("PosList", 11);
        for (int i = 0; i < posList.func_74745_c(); ++i) {
            int[] array = posList.func_150306_c(i);
            this.todoList.add(new BlockPos(array[0], array[1], array[2]));
        }
        NBTTagList itemList = nbt.func_150295_c("ItemList", 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            ItemStack stack = new ItemStack(itemList.func_150305_b(i));
            if (stack == null) continue;
            this.items.add(stack);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Delay", this.delay);
        nbt.func_74768_a("Radius", this.radius);
        nbt.func_74768_a("NextDelay", this.nextDelay);
        this.inv.writeToNBT(this.getTag(nbt, "Upgrades"));
        NBTTagList posList = new NBTTagList();
        for (BlockPos pos : this.todoList) {
            posList.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
        }
        nbt.func_74782_a("PosList", (NBTBase)posList);
        NBTTagList itemList = new NBTTagList();
        for (ItemStack stack : this.items) {
            NBTTagCompound data = new NBTTagCompound();
            stack.func_77955_b(data);
            itemList.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("ItemList", (NBTBase)itemList);
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.setOverclockerUpgrade();
            this.transporter = TransporterManager.manager.getTransporter(new InventoryWrapper(this), true);
        }
    }

    public void setOverclockerUpgrade() {
        int overclocker = 0;
        int newRange = 1;
        for (int i = 0; i < this.inv.getSlotCount(); ++i) {
            ItemStack stack = this.inv.getStackInSlot(i);
            if (StackUtil.isStackEqual(stack, Ic2Items.overClockerUpgrade)) {
                ++overclocker;
                continue;
            }
            if (StackUtil.isStackEqual(stack, Ic2Items.padUpgradeBasicFieldUpgrade)) {
                ++newRange;
                continue;
            }
            if (StackUtil.isStackEqual(stack, Ic2Items.padUpgradeFieldUpgrade)) {
                newRange += 2;
                continue;
            }
            if (!StackUtil.isStackEqual(stack, Ic2Items.padUpgradeAdvFieldUpgrade)) continue;
            newRange += 3;
        }
        if (newRange > 5) {
            newRange = 5;
        }
        if (newRange < this.radius) {
            this.todoList.clear();
        }
        this.radius = newRange;
        if (overclocker < 1) {
            this.nextDelay = 20;
        } else if (overclocker < 2) {
            this.nextDelay = 10;
        } else if (overclocker < 3) {
            this.nextDelay = 5;
        } else if (overclocker < 4) {
            this.nextDelay = 2;
        } else if (overclocker >= 4) {
            this.nextDelay = 0;
        }
    }

    @Override
    public boolean supportsNotify() {
        return true;
    }

    public void func_73660_a() {
        this.addItemsToInventory();
        this.updateNeighbors();
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        if (!this.hasEnergy(100)) {
            this.delay += 20;
            return;
        }
        if (this.items.size() > 0) {
            this.delay += 20;
            return;
        }
        this.delay += this.nextDelay;
        if (this.todoList.isEmpty()) {
            this.todoList.addAll(AabbUtil.getTargets(this.func_145831_w(), this.func_174877_v(), this.radius, filter, true, RotationList.ALL));
            this.useEnergy(10);
        }
        if (this.todoList.isEmpty()) {
            this.delay += 120;
            return;
        }
        BlockPos target = this.todoList.remove();
        if (this.todoList.isEmpty()) {
            this.delay += 120;
        }
        TileEntity tile = this.func_145831_w().func_175625_s(target);
        this.useEnergy(1);
        if (tile instanceof ICropTile) {
            this.delay += this.nextDelay;
            ICropTile crop = (ICropTile)tile;
            CropCard card = crop.getCrop();
            if (card == null) {
                return;
            }
            if (card.canBeHarvested(crop) && crop.getCurrentSize() >= card.getOptimalHarvestSize(crop)) {
                this.items.addAll(crop.performHarvest());
                this.addItemsToInventory();
                this.useEnergy(20);
                this.notifyNeighbors();
            }
        }
    }

    public void addItemsToInventory() {
        if (this.items.isEmpty()) {
            return;
        }
        if (this.transporter == null) {
            return;
        }
        ArrayList<ItemStack> left = new ArrayList<ItemStack>();
        while (this.items.size() > 0) {
            ItemStack added;
            ItemStack stack = this.items.remove();
            if (stack.func_190926_b() || (added = this.transporter.addItem(stack.func_77946_l(), null, true)) == null) continue;
            stack.func_190918_g(added.func_190916_E());
            if (stack.func_190916_E() <= 0) continue;
            left.add(stack);
        }
        this.transporter.onFinishedActions();
        this.items.addAll(left);
    }

    @Override
    public double getWrenchDropRate() {
        return 0.8;
    }

    public static class CropFilter
    implements AabbUtil.IBlockFilter {
        @Override
        public boolean isValidBlock(IBlockState state) {
            return state.func_177230_c() == Ic2States.cropStick.func_177230_c();
        }

        @Override
        public boolean isValidBlock(World world, BlockPos pos) {
            return world.func_175625_s(pos) instanceof ICropTile;
        }

        @Override
        public boolean forceChunkLoad() {
            return false;
        }
    }
}

