/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropCardBase;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropHops
extends CropCardBase {
    public CropHops() {
        super(new CropProperties(5, 2, 2, 0, 1, 1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state >= 5) {
            return this.getSprite("bc")[39 + state];
        }
        return this.getSprite("bc")[1 + state];
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Green", "Ingredient", "Wheat"};
    }

    @Override
    public String getId() {
        return "Hops";
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        return 600;
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 7 && cropTile.getLightLevel() >= 9;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 7;
    }

    @Override
    public int getMaxSize() {
        return 7;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 3;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return Ic2Items.hops.func_77946_l();
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 7;
    }
}

