/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropCardBase;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropCoffee
extends CropCardBase {
    public CropCoffee() {
        super(new CropProperties(7, 1, 4, 1, 2, 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state == 5) {
            return this.getSprite("bc")[43];
        }
        if (state == 4) {
            return this.getSprite("bc")[42];
        }
        return this.getSprite("bc")[31 + state];
    }

    @Override
    public String getId() {
        return "Coffee";
    }

    @Override
    public String getDiscoveredBy() {
        return "Snoochy";
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Leaves", "Ingrident", "Beans"};
    }

    @Override
    public int getMaxSize() {
        return 5;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        if (crop.getCurrentSize() == 4) {
            return ItemStack.field_190927_a;
        }
        return Ic2Items.coffeeBeans.func_77946_l();
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 5 && cropTile.getLightLevel() >= 9;
    }

    @Override
    public int getWeightInfluences(ICropTile crop, int humidity, int nutrients, int air) {
        return (int)(0.4f * (float)humidity + 1.4f * (float)nutrients + 1.2f * (float)air);
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        if (cropTile.getCurrentSize() == 3) {
            return (int)((float)super.getGrowthDuration(cropTile) * 0.5f);
        }
        if (cropTile.getCurrentSize() == 4) {
            return (int)((float)super.getGrowthDuration(cropTile) * 1.5f);
        }
        return super.getGrowthDuration(cropTile);
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() >= 4;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 3;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 5;
    }
}

