/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine;

import io.github.phantamanta44.libnine.LibNine;
import io.github.phantamanta44.libnine.block.L9Block;
import io.github.phantamanta44.libnine.component.multiblock.IMultiBlockUnit;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockType;
import io.github.phantamanta44.libnine.gui.L9GuiHandler;
import io.github.phantamanta44.libnine.item.L9Item;
import io.github.phantamanta44.libnine.network.PacketClientContainerInteraction;
import io.github.phantamanta44.libnine.network.PacketServerSyncTileEntity;
import io.github.phantamanta44.libnine.util.LazyConstant;
import io.github.phantamanta44.libnine.util.render.TextureResource;
import io.github.phantamanta44.libnine.wsd.WSDManager;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class Virtue {
    private static final Map<String, Virtue> loadedVirtues = new LinkedHashMap<String, Virtue>();
    private final String modId;
    private final String modPref;
    @Nullable
    private final CreativeTabs defaultCreativeTab;
    private final LazyConstant<SimpleNetworkWrapper> networkHandler;
    private final LazyConstant<L9GuiHandler> guiHandler;
    private final LazyConstant<WSDManager> wsdManager;
    private boolean usesTileEntities;
    private boolean usesContainers;

    public static Virtue forMod(String modId) {
        return loadedVirtues.get(modId);
    }

    public Virtue(String modId, @Nullable CreativeTabs defaultCreativeTab) {
        this.modId = modId;
        this.modPref = modId + ":";
        this.defaultCreativeTab = defaultCreativeTab;
        this.networkHandler = new LazyConstant<SimpleNetworkWrapper>(() -> NetworkRegistry.INSTANCE.newSimpleChannel(modId));
        this.guiHandler = new LazyConstant<L9GuiHandler>(() -> {
            L9GuiHandler handler = new L9GuiHandler(this);
            NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)handler);
            return handler;
        });
        this.wsdManager = new LazyConstant<WSDManager>(() -> new WSDManager(this));
        this.usesContainers = false;
        this.usesTileEntities = false;
        loadedVirtues.put(modId, this);
    }

    public Virtue(String modId) {
        this(modId, null);
    }

    void markUsesTileEntities() {
        if (!this.usesTileEntities) {
            this.getNetworkHandler().registerMessage(PacketServerSyncTileEntity.Handler.class, PacketServerSyncTileEntity.class, 255, Side.CLIENT);
            this.usesTileEntities = true;
        }
    }

    void markUsesContainers() {
        if (!this.usesContainers) {
            this.getNetworkHandler().registerMessage(PacketClientContainerInteraction.Handler.class, PacketClientContainerInteraction.class, 254, Side.SERVER);
            this.usesContainers = true;
        }
    }

    public String getModId() {
        return this.modId;
    }

    @Nullable
    public CreativeTabs getDefaultCreativeTab() {
        return this.defaultCreativeTab;
    }

    public SimpleNetworkWrapper getNetworkHandler() {
        return this.networkHandler.get();
    }

    public L9GuiHandler getGuiHandler() {
        return this.guiHandler.get();
    }

    public WSDManager getWsdManager() {
        return this.wsdManager.get();
    }

    public String prefix(String suffix) {
        return this.modPref + suffix;
    }

    public ResourceLocation newResourceLocation(String resource) {
        return new ResourceLocation(this.modId, resource);
    }

    public ModelResourceLocation newModelResourceLocation(String model, String variant) {
        return new ModelResourceLocation(this.prefix(model), variant);
    }

    public ModelResourceLocation newModelResourceLocation(String model) {
        return new ModelResourceLocation(this.prefix(model));
    }

    public TextureResource newTextureResource(String resource, int width, int height) {
        return new TextureResource(this.newResourceLocation(resource), width, height);
    }

    public SoundEvent newSoundEvent(String key) {
        ResourceLocation id = this.newResourceLocation(key);
        SoundEvent sound = new SoundEvent(id);
        sound.setRegistryName(id);
        LibNine.PROXY.getRegistrar().queueSoundEventReg(sound);
        return sound;
    }

    public <T extends IMultiBlockUnit<T>> MultiBlockType<T> newMultiBlockType(String key, int maxSearchDist, Class<T> componentType) {
        return new MultiBlockType<T>(this.newResourceLocation(key), maxSearchDist, componentType);
    }

    public void setCreativeTabFor(L9Item item) {
        if (this.defaultCreativeTab != null) {
            item.func_77637_a(this.defaultCreativeTab);
        }
    }

    public void setCreativeTabFor(L9Block block) {
        if (this.defaultCreativeTab != null) {
            block.func_149647_a(this.defaultCreativeTab);
        }
    }
}

