/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.proxy;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.furniture.handler.CraftingHandler;
import com.mrcrayfish.furniture.handler.SyncEvent;
import com.mrcrayfish.furniture.proxy.ProxyInterface;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CommonProxy
implements ProxyInterface {
    private static final List<String> IGNORE_SOUNDS;
    private static final List<String> IGNORE_ITEMS;

    public World getClientWorld() {
        return null;
    }

    public EntityPlayer getClientPlayer() {
        return null;
    }

    @Override
    public boolean isSinglePlayer() {
        return false;
    }

    @Override
    public boolean isDedicatedServer() {
        return true;
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)new CraftingHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SyncEvent());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onMissingMap(RegistryEvent.MissingMappings<SoundEvent> event) {
        for (RegistryEvent.MissingMappings.Mapping missing : event.getMappings()) {
            if (!missing.key.func_110624_b().equals("cfm") || !IGNORE_SOUNDS.contains(missing.key.func_110623_a())) continue;
            missing.ignore();
        }
    }

    @SubscribeEvent
    public void onMissingItems(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping missing : event.getMappings()) {
            if (!missing.key.func_110624_b().equals("cfm") || !IGNORE_ITEMS.contains(missing.key.func_110623_a())) continue;
            missing.ignore();
        }
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)"channel_news");
        builder.add((Object)"channel_sam_tabor");
        builder.add((Object)"channel_heman");
        builder.add((Object)"channel_switch");
        builder.add((Object)"channel_cooking");
        IGNORE_SOUNDS = builder.build();
        builder = ImmutableList.builder();
        builder.add((Object)"shower_head_on");
        builder.add((Object)"fire_pit_off");
        builder.add((Object)"lamp_on");
        builder.add((Object)"tree_top");
        builder.add((Object)"shower_top");
        builder.add((Object)"bath_top");
        builder.add((Object)"curtains_closed");
        builder.add((Object)"ceiling_light_on");
        builder.add((Object)"blinds_closed");
        builder.add((Object)"cup");
        builder.add((Object)"grand_chair_top");
        builder.add((Object)"fridge");
        builder.add((Object)"divingboard_plank");
        IGNORE_ITEMS = builder.build();
    }
}

