/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.gui;

import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.api.Recipes;
import com.mrcrayfish.furniture.gui.RecipePage;
import com.mrcrayfish.furniture.gui.page.PageBlender;
import com.mrcrayfish.furniture.gui.page.PageChoppingBoard;
import com.mrcrayfish.furniture.gui.page.PageContentsOne;
import com.mrcrayfish.furniture.gui.page.PageContentsTwo;
import com.mrcrayfish.furniture.gui.page.PageDishwasher;
import com.mrcrayfish.furniture.gui.page.PageFreezer;
import com.mrcrayfish.furniture.gui.page.PageGrill;
import com.mrcrayfish.furniture.gui.page.PageMicrowave;
import com.mrcrayfish.furniture.gui.page.PageMineBay;
import com.mrcrayfish.furniture.gui.page.PageOven;
import com.mrcrayfish.furniture.gui.page.PagePrinter;
import com.mrcrayfish.furniture.gui.page.PageTitle;
import com.mrcrayfish.furniture.gui.page.PageToaster;
import com.mrcrayfish.furniture.gui.page.PageWashingMachine;
import com.mrcrayfish.furniture.init.FurnitureItems;
import java.awt.Desktop;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiRecipeBook
extends GuiScreen {
    private static final ResourceLocation page_1 = new ResourceLocation("cfm:textures/gui/recipebook_1.png");
    private static final ResourceLocation page_2 = new ResourceLocation("cfm:textures/gui/recipebook_2.png");
    public int bookWidth = 146;
    public int bookHeight = 180;
    private int xSize = this.bookWidth * 2;
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private GuiButton buttonTutorial;
    private GuiButton buttonContents;
    private HashMap<Integer, RecipePage> pages = new HashMap();
    private int pageCount = 0;
    private int pageNum = 0;
    private int progress = 0;
    private ItemStack knife = new ItemStack(FurnitureItems.KNIFE);

    public GuiRecipeBook() {
        this.compilePages();
    }

    public void compilePages() {
        PageTitle titlePage = new PageTitle(this);
        this.pages.put(this.pageCount++, titlePage);
        PageContentsOne contentsPageOne = new PageContentsOne(this);
        this.pages.put(this.pageCount++, contentsPageOne);
        PageContentsTwo contentsPageTwo = new PageContentsTwo(this);
        this.pages.put(this.pageCount, contentsPageTwo);
        ArrayList<RecipeData> oven = Recipes.getRecipes("oven");
        for (int i = 0; i < oven.size(); ++i) {
            if (i % 8 == 0) {
                ++this.pageCount;
            }
            if (this.pages.containsKey(this.pageCount)) {
                this.pages.get(this.pageCount).addRecipe(oven.get(i));
                continue;
            }
            this.pages.put(this.pageCount, new PageOven());
            this.pages.get(this.pageCount).addRecipe(oven.get(i));
        }
        ArrayList<RecipeData> freezer = Recipes.getRecipes("freezer");
        for (int i = 0; i < freezer.size(); ++i) {
            if (i % 8 == 0) {
                ++this.pageCount;
            }
            if (this.pages.containsKey(this.pageCount)) {
                this.pages.get(this.pageCount).addRecipe(freezer.get(i));
                continue;
            }
            this.pages.put(this.pageCount, new PageFreezer());
            this.pages.get(this.pageCount).addRecipe(freezer.get(i));
        }
        ArrayList<RecipeData> minebay = Recipes.getRecipes("minebay");
        for (int i = 0; i < minebay.size(); ++i) {
            if (i % 8 == 0) {
                ++this.pageCount;
            }
            if (this.pages.containsKey(this.pageCount)) {
                this.pages.get(this.pageCount).addRecipe(minebay.get(i));
                continue;
            }
            this.pages.put(this.pageCount, new PageMineBay());
            this.pages.get(this.pageCount).addRecipe(minebay.get(i));
        }
        ArrayList<RecipeData> printer = Recipes.getRecipes("printer");
        for (int i = 0; i < printer.size(); ++i) {
            if (i % 40 == 0) {
                ++this.pageCount;
            }
            if (this.pages.containsKey(this.pageCount)) {
                this.pages.get(this.pageCount).addRecipe(printer.get(i));
                continue;
            }
            this.pages.put(this.pageCount, new PagePrinter());
            this.pages.get(this.pageCount).addRecipe(printer.get(i));
        }
        ArrayList<RecipeData> choppingboard = Recipes.getRecipes("choppingboard");
        for (int i = 0; i < choppingboard.size(); ++i) {
            if (i % 8 == 0) {
                ++this.pageCount;
            }
            if (this.pages.containsKey(this.pageCount)) {
                this.pages.get(this.pageCount).addRecipe(choppingboard.get(i));
                continue;
            }
            this.pages.put(this.pageCount, new PageChoppingBoard());
            this.pages.get(this.pageCount).addRecipe(choppingboard.get(i));
        }
        ArrayList<RecipeData> toaster = Recipes.getRecipes("toaster");
        for (int i = 0; i < toaster.size(); ++i) {
            if (i % 8 == 0) {
                ++this.pageCount;
            }
            if (this.pages.containsKey(this.pageCount)) {
                this.pages.get(this.pageCount).addRecipe(toaster.get(i));
                continue;
            }
            this.pages.put(this.pageCount, new PageToaster());
            this.pages.get(this.pageCount).addRecipe(toaster.get(i));
        }
        ArrayList<RecipeData> blender = Recipes.getRecipes("blender");
        for (int i = 0; i < blender.size(); ++i) {
            if (i % 4 == 0) {
                ++this.pageCount;
            }
            if (this.pages.containsKey(this.pageCount)) {
                this.pages.get(this.pageCount).addRecipe(blender.get(i));
                continue;
            }
            this.pages.put(this.pageCount, new PageBlender());
            this.pages.get(this.pageCount).addRecipe(blender.get(i));
        }
        ArrayList<RecipeData> microwave = Recipes.getRecipes("microwave");
        for (int i = 0; i < microwave.size(); ++i) {
            if (i % 8 == 0) {
                ++this.pageCount;
            }
            if (this.pages.containsKey(this.pageCount)) {
                this.pages.get(this.pageCount).addRecipe(microwave.get(i));
                continue;
            }
            this.pages.put(this.pageCount, new PageMicrowave());
            this.pages.get(this.pageCount).addRecipe(microwave.get(i));
        }
        ArrayList<RecipeData> dishwasher = Recipes.getRecipes("dishwasher");
        for (int i = 0; i < dishwasher.size(); ++i) {
            if (i % 40 == 0) {
                ++this.pageCount;
            }
            if (this.pages.containsKey(this.pageCount)) {
                this.pages.get(this.pageCount).addRecipe(dishwasher.get(i));
                continue;
            }
            this.pages.put(this.pageCount, new PageDishwasher());
            this.pages.get(this.pageCount).addRecipe(dishwasher.get(i));
        }
        ArrayList<RecipeData> washingmachine = Recipes.getRecipes("washingmachine");
        for (int i = 0; i < washingmachine.size(); ++i) {
            if (i % 40 == 0) {
                ++this.pageCount;
            }
            if (this.pages.containsKey(this.pageCount)) {
                this.pages.get(this.pageCount).addRecipe(washingmachine.get(i));
                continue;
            }
            this.pages.put(this.pageCount, new PageWashingMachine());
            this.pages.get(this.pageCount).addRecipe(washingmachine.get(i));
        }
        ArrayList<RecipeData> grill = Recipes.getRecipes("grill");
        for (int i = 0; i < grill.size(); ++i) {
            if (i % 8 == 0) {
                ++this.pageCount;
            }
            if (this.pages.containsKey(this.pageCount)) {
                this.pages.get(this.pageCount).addRecipe(grill.get(i));
                continue;
            }
            this.pages.put(this.pageCount, new PageGrill());
            this.pages.get(this.pageCount).addRecipe(grill.get(i));
        }
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        int i = (this.field_146294_l - 18) / 2;
        this.buttonNextPage = new NextPageButton(1, i + 110, 160, true);
        this.buttonPreviousPage = new NextPageButton(2, i - 110, 160, false);
        this.buttonTutorial = new GuiButton(3, i + 50, 135, 60, 20, "Click here");
        this.buttonContents = new GuiButton(14, i - 60, 152, 50, 20, "Contents");
        this.field_146292_n.add(this.buttonNextPage);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.field_146292_n.add(this.buttonTutorial);
        this.field_146292_n.add(this.buttonContents);
        for (RecipePage page : this.pages.values()) {
            page.init(this.field_146292_n);
        }
        this.updateButtons();
    }

    public void updateButtons() {
        if (this.pageNum == 0) {
            this.buttonPreviousPage.field_146125_m = false;
            this.buttonTutorial.field_146125_m = true;
            this.buttonContents.field_146125_m = false;
        } else {
            this.buttonPreviousPage.field_146125_m = true;
            this.buttonNextPage.field_146125_m = this.pageNum != this.pages.size() - 1;
            this.buttonTutorial.field_146125_m = false;
            this.buttonContents.field_146125_m = this.pageNum >= 3;
        }
    }

    protected void func_146284_a(GuiButton button) {
        this.pages.get(this.pageNum).onClose();
        if (button == this.buttonNextPage) {
            ++this.pageNum;
            if (this.pageNum > this.pages.size() - 1) {
                this.pageNum = this.pages.size() - 1;
            }
        } else if (button == this.buttonPreviousPage) {
            --this.pageNum;
            if (this.pageNum < 0) {
                this.pageNum = 0;
            }
        } else if (button == this.buttonContents) {
            this.gotoPage("contents");
        } else if (button == this.buttonTutorial) {
            this.openTutorial();
        } else {
            for (RecipePage page : this.pages.values()) {
                page.handleButtonClick(button);
            }
        }
        this.pages.get(this.pageNum).onShown();
        this.updateButtons();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.pages = null;
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.progress;
        if (this.progress >= 160) {
            this.progress = 0;
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = (this.field_146294_l - this.bookWidth) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(page_1);
        this.func_73729_b(k - this.bookWidth / 2, 5, 0, 0, this.bookWidth, this.bookHeight);
        this.field_146297_k.func_110434_K().func_110577_a(page_2);
        this.func_73729_b(k + this.bookWidth / 2, 5, 0, 0, this.bookWidth, this.bookHeight);
        if (this.pageNum == 0) {
            this.field_146297_k.func_110434_K().func_110577_a(page_1);
            this.func_73729_b(this.field_146294_l / 2 - this.bookWidth / 2 - 46, 50, 146, 0, 93, 25);
            this.func_73729_b(this.field_146294_l / 2 - this.bookWidth / 2 - 33, 75, 146, 25, 66, 22);
        }
        super.func_73863_a(par1, par2, par3);
        this.updatePage(par1, par2, par3);
    }

    public void updatePage(int mouseX, int mouseY, float partialTicks) {
        int k = this.field_146294_l / 2;
        RecipePage page = this.pages.get(this.pageNum);
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        if (page.shouldDrawTitle()) {
            this.field_146289_q.func_175065_a(TextFormatting.BOLD + page.getTitle(), (float)(k - this.bookWidth + 20), 26.0f, 1986677, false);
            this.field_146289_q.func_175065_a(TextFormatting.BOLD + page.getTitle(), (float)(k + 20), 26.0f, 1986677, false);
        }
        page.draw(this, k - 130, 40, mouseX, mouseY, partialTicks);
        page.drawOverlay(this.field_146297_k, this, k - 130, 40, mouseX, mouseY, partialTicks);
        GL11.glPopMatrix();
    }

    public void gotoPage(String type) {
        for (int i = 0; i < this.pages.size(); ++i) {
            if (this.pages.get(i) == null || !this.pages.get((Object)Integer.valueOf((int)i)).type.equalsIgnoreCase(type)) continue;
            this.pageNum = i;
            break;
        }
    }

    public void drawPlainArrow(int x, int y) {
        GL11.glPushMatrix();
        this.field_146297_k.func_110434_K().func_110577_a(page_1);
        this.func_73729_b(x, y, 36, 180, 22, 15);
        GL11.glPopMatrix();
    }

    public void drawProgressArrow(int x, int y, float partialTicks) {
        GL11.glPushMatrix();
        this.field_146297_k.func_110434_K().func_110577_a(page_1);
        this.func_73729_b(x, y, 36, 180, 22, 15);
        int percent = (int)((float)this.progress + partialTicks) * 22 / 160;
        this.func_73729_b(x, y, 58, 180, percent + 1, 16);
        GL11.glPopMatrix();
    }

    public void drawTag(int x, int y) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(page_1);
        this.func_73729_b(x, y, 0, 200, 45, 18);
        GL11.glPopMatrix();
    }

    public void drawKnife(int x, int y) {
        GL11.glPushMatrix();
        int percent = this.progress * 16 / 160;
        if (percent >= 12) {
            percent = 12;
        }
        this.getItemRenderer().func_180450_b(this.knife, x, y + percent);
        GL11.glPopMatrix();
    }

    public RenderItem getItemRenderer() {
        return this.field_146296_j;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void openTutorial() {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null) {
            try {
                desktop.browse(new URL("http://mrcrayfishs-furniture-mod.wikia.com/wiki/RecipeAPI").toURI());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isMouseWithin(int posX, int posY, int width, int height, int mouseX, int mouseY) {
        return mouseX >= posX - 1 && mouseX < posX + width + 1 && mouseY >= posY - 1 && mouseY < posY + height + 1;
    }

    public void func_146285_a(ItemStack itemStack, int mouseX, int mouseY) {
        List list = itemStack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, itemStack.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, TextFormatting.GRAY + (String)list.get(k));
        }
        FontRenderer font = itemStack.func_77973_b().getFontRenderer(itemStack);
        this.drawHoveringText(list, mouseX, mouseY, font == null ? this.field_146289_q : font);
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean rightButton;

        public NextPageButton(int id, int posX, int posY, boolean rightButton) {
            super(id, posX, posY, 18, 10, "");
            this.rightButton = rightButton;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(page_1);
                int u = 0;
                int v = 180;
                boolean bl = flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                if (flag) {
                    u += this.field_146120_f;
                }
                if (!this.rightButton) {
                    v += this.field_146121_g;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, u, v, this.field_146120_f, this.field_146121_g);
            }
        }
    }
}

