/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.advancement.Triggers;
import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.util.CollisionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockShower
extends BlockFurniture {
    private static final AxisAlignedBB NOTHING = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final AxisAlignedBB SIDE_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SIDE_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SIDE_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SIDE_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    public static final AxisAlignedBB TOP_BOUNDING_BOX = new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB BOTTOM_BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);

    public BlockShower(Material material, boolean top) {
        super(material);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185851_d);
        if (top) {
            this.func_149647_a(null);
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && super.func_176196_c(world, pos.func_177984_a());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), FurnitureBlocks.SHOWER_TOP.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 2);
        if (placer instanceof EntityPlayer) {
            Triggers.trigger(Triggers.PLACE_BATHTROOM_FURNITURE, (EntityPlayer)placer);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        world.func_175655_b(this == FurnitureBlocks.SHOWER_BOTTOM ? pos.func_177984_a() : pos.func_177977_b(), false);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            boolean top = this == FurnitureBlocks.SHOWER_TOP;
            IBlockState head = world.func_180495_p(pos.func_177981_b(top ? 1 : 2));
            if (head.func_177230_c() == FurnitureBlocks.SHOWER_HEAD_ON) {
                Triggers.trigger(Triggers.PLAYER_SHOWER, player);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177230_c() == FurnitureBlocks.SHOWER_TOP ? TOP_BOUNDING_BOX : BOTTOM_BOUNDING_BOX;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return new ItemStack(FurnitureBlocks.SHOWER_BOTTOM).func_77973_b();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(FurnitureBlocks.SHOWER_BOTTOM);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    private List<AxisAlignedBB> getCollisionBoxList(IBlockState state, World world, BlockPos pos) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (state.func_177230_c() == FurnitureBlocks.SHOWER_BOTTOM) {
            list.add(BOTTOM);
        }
        if (facing != EnumFacing.NORTH) {
            list.add(SIDE_SOUTH);
        }
        if (facing != EnumFacing.SOUTH) {
            list.add(SIDE_NORTH);
        }
        if (facing != EnumFacing.EAST) {
            list.add(SIDE_WEST);
        }
        if (facing != EnumFacing.WEST) {
            list.add(SIDE_EAST);
        }
        return list;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        List<AxisAlignedBB> boxes = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)worldIn, pos), worldIn, pos);
        for (AxisAlignedBB box : boxes) {
            BlockFurniture.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)world, pos), world, pos)) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }
}

