/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.advancement.Triggers;
import com.mrcrayfish.furniture.gui.inventory.ISimpleInventory;
import com.mrcrayfish.furniture.tileentity.TileEntityPresent;
import com.mrcrayfish.furniture.util.InventoryUtil;
import java.util.Date;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPresent
extends Block
implements ITileEntityProvider {
    public static final PropertyEnum<EnumDyeColor> COLOUR = PropertyEnum.func_177709_a((String)"colour", EnumDyeColor.class);
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.35, 0.75);

    public BlockPresent(Material material) {
        super(material);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185854_g);
        this.field_149758_A = true;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(COLOUR, (Comparable)EnumDyeColor.WHITE));
        this.func_149647_a(MrCrayfishFurnitureMod.tabFurniture);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityPresent present = (TileEntityPresent)world.func_175625_s(pos);
        if (present != null) {
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187802_ec, SoundCategory.BLOCKS, 0.75f, 1.0f, false);
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Merry Christmas" + TextFormatting.RESET + " from " + TextFormatting.RED + present.ownerName));
            }
            Triggers.trigger(Triggers.UNWRAP_PRESENT, player);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Object inv;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IInventory) {
            inv = (IInventory)tileEntity;
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)inv);
        }
        if (tileEntity instanceof ISimpleInventory) {
            inv = (ISimpleInventory)tileEntity;
            InventoryUtil.dropInventoryItems(world, pos, (ISimpleInventory)inv);
        }
        super.func_180663_b(world, pos, state);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOX);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityPresent();
    }

    public int getDaysInbetween(Date date, Date date2) {
        return (int)(date2.getTime() - date.getTime()) / 86400000;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(COLOUR)).func_176765_a();
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(COLOUR)).func_176765_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COLOUR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOUR});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_149666_a(CreativeTabs item, NonNullList<ItemStack> items) {
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }
}

