/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.MrCrayfishFurnitureMod;
import com.mrcrayfish.furniture.blocks.BlockLampOn;
import com.mrcrayfish.furniture.entity.EntitySittableBlock;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLamp
extends Block {
    public static final PropertyInteger COLOUR = PropertyInteger.func_177719_a((String)"colour", (int)0, (int)15);
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);

    public BlockLamp(Material material, boolean on) {
        super(material);
        this.func_149711_c(0.75f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(0)));
        if (!on) {
            this.func_149647_a(MrCrayfishFurnitureMod.tabFurniture);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemDye) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(15 - heldItem.func_77952_i())));
            if (!playerIn.func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
            return true;
        }
        if (!(worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockLamp)) {
            worldIn.func_180501_a(pos, FurnitureBlocks.LAMP_ON.func_176223_P().func_177226_a((IProperty)BlockLampOn.COLOUR, (Comparable)((Integer)state.func_177229_b((IProperty)COLOUR))), 3);
        } else {
            int yOffset = 1;
            while (worldIn.func_180495_p(pos.func_177981_b(++yOffset)).func_177230_c() instanceof BlockLamp) {
            }
            int colour = (Integer)worldIn.func_180495_p(pos.func_177981_b(yOffset).func_177977_b()).func_177229_b((IProperty)COLOUR);
            if (worldIn.func_180495_p(pos.func_177981_b(yOffset).func_177977_b()).func_177230_c() instanceof BlockLampOn) {
                worldIn.func_175656_a(pos.func_177981_b(yOffset).func_177977_b(), FurnitureBlocks.LAMP_OFF.func_176223_P().func_177226_a((IProperty)BlockLampOn.COLOUR, (Comparable)Integer.valueOf(colour)));
            } else {
                worldIn.func_175656_a(pos.func_177981_b(yOffset).func_177977_b(), FurnitureBlocks.LAMP_ON.func_176223_P().func_177226_a((IProperty)BlockLampOn.COLOUR, (Comparable)Integer.valueOf(colour)));
            }
        }
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean up = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockLamp;
        boolean down = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockLamp;
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(up)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(down));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)COLOUR);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOUR, UP, DOWN});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(Math.min(meta, 15)));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack(FurnitureBlocks.LAMP_OFF, 1, Math.min((Integer)state.func_177229_b((IProperty)COLOUR), 15)));
    }

    public void func_149666_a(CreativeTabs item, NonNullList<ItemStack> items) {
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(FurnitureBlocks.LAMP_OFF, 1, ((Integer)state.func_177229_b((IProperty)COLOUR)).intValue());
    }

    private List<AxisAlignedBB> getCollisionBoxList(IBlockState state, World world, BlockPos pos) {
        ArrayList list = Lists.newArrayList();
        boolean up = (Boolean)state.func_177229_b((IProperty)UP);
        boolean down = (Boolean)state.func_177229_b((IProperty)DOWN);
        list.add(field_185505_j);
        return list;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean p_185477_7_) {
        if (!(entity instanceof EntitySittableBlock)) {
            List<AxisAlignedBB> boxes = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)worldIn, pos), worldIn, pos);
            for (AxisAlignedBB box : boxes) {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
            }
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)world, pos), world, pos)) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }
}

