/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.advancement.Triggers;
import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.entity.EntitySittableBlock;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.util.CollisionHelper;
import com.mrcrayfish.furniture.util.SittableUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrandChair
extends BlockFurniture {
    private static final AxisAlignedBB BOUNDING_BOX_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.8, 1.0);
    private static final AxisAlignedBB BOUNDING_BOX_TOP = new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, 0.8, 1.0);
    private static final AxisAlignedBB COLLISION_BOX_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB COLLISION_BOX_TOP_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.8125, 0.0, 0.0, 1.0, 0.8, 1.0);
    private static final AxisAlignedBB COLLISION_BOX_TOP_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.8125, 0.0, 0.0, 1.0, 0.8, 1.0);
    private static final AxisAlignedBB COLLISION_BOX_TOP_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.8125, 0.0, 0.0, 1.0, 0.8, 1.0);
    private static final AxisAlignedBB COLLISION_BOX_TOP_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.8125, 0.0, 0.0, 1.0, 0.8, 1.0);
    private static final AxisAlignedBB[] COLLISION_BOX_TOP = new AxisAlignedBB[]{COLLISION_BOX_TOP_SOUTH, COLLISION_BOX_TOP_WEST, COLLISION_BOX_TOP_NORTH, COLLISION_BOX_TOP_EAST};

    public BlockGrandChair(Material materialIn, boolean top) {
        super(materialIn);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        if (top) {
            this.func_149647_a(null);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)placer;
            Triggers.trigger(Triggers.PLACE_CHAIR, player);
            Triggers.trigger(Triggers.PLACE_CHAIR_OR_TABLE, player);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (this == FurnitureBlocks.GRAND_CHAIR_BOTTOM) {
            if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == FurnitureBlocks.GRAND_CHAIR_TOP) {
                worldIn.func_175655_b(pos.func_177984_a(), false);
            }
        } else if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == FurnitureBlocks.GRAND_CHAIR_BOTTOM) {
            worldIn.func_175655_b(pos.func_177977_b(), false);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos) && worldIn.func_175623_d(pos.func_177984_a());
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this == FurnitureBlocks.GRAND_CHAIR_BOTTOM) {
            world.func_175656_a(pos.func_177984_a(), FurnitureBlocks.GRAND_CHAIR_TOP.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()));
        }
        return super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (this == FurnitureBlocks.GRAND_CHAIR_BOTTOM && !playerIn.func_70093_af()) {
            if (SittableUtil.sitOnBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, 0.375)) {
                worldIn.func_175666_e(pos, (Block)this);
                return true;
            }
        } else {
            worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().func_180639_a(worldIn, pos.func_177977_b(), state, playerIn, hand, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this == FurnitureBlocks.GRAND_CHAIR_BOTTOM) {
            return BOUNDING_BOX_BOTTOM;
        }
        return BOUNDING_BOX_TOP;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        if (!(entityIn instanceof EntitySittableBlock)) {
            if (this == FurnitureBlocks.GRAND_CHAIR_BOTTOM) {
                BlockFurniture.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOX_BOTTOM);
            } else {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                BlockFurniture.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOX_TOP[facing.func_176736_b()]);
            }
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return SittableUtil.isSomeoneSitting(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) ? 1 : 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return new ItemStack(FurnitureBlocks.GRAND_CHAIR_BOTTOM).func_77973_b();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(FurnitureBlocks.GRAND_CHAIR_BOTTOM);
    }
}

