/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.util.StateHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCounter
extends BlockFurniture {
    public static final AxisAlignedBB COUNTER_TOP = new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB[] FORWARD_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.875, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 0.875), new AxisAlignedBB(0.125, 0.0, 0.0, 1.0, 0.875, 1.0)};
    public static final AxisAlignedBB[] LEFT_CORNER_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.125, 0.875, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.875, 0.875, 0.875), new AxisAlignedBB(0.125, 0.0, 0.0, 1.0, 0.875, 0.875), new AxisAlignedBB(0.125, 0.0, 0.124, 1.0, 0.875, 1.0)};
    public static final AxisAlignedBB[] RIGHT_CORNER_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.125, 0.0, 0.125, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.125, 0.875, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.875, 0.875, 0.875), new AxisAlignedBB(0.125, 0.0, 0.0, 1.0, 0.875, 0.875)};
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", CounterType.class);

    public BlockCounter(Material material) {
        super(material);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TYPE, (Comparable)((Object)CounterType.NORMAL)));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        List<AxisAlignedBB> list = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)worldIn, pos));
        for (AxisAlignedBB box : list) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) instanceof BlockCounter) {
            if (StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) == StateHelper.Direction.LEFT) {
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CounterType.CORNER_LEFT));
            }
            if (StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) == StateHelper.Direction.RIGHT) {
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CounterType.CORNER_RIGHT));
            }
        }
        if (StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.UP) instanceof BlockCounter) {
            if (StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.UP) == StateHelper.Direction.LEFT && !(StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.LEFT) instanceof BlockCounter)) {
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CounterType.INVERT_RIGHT));
            }
            if (StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.UP) == StateHelper.Direction.RIGHT && !(StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.RIGHT) instanceof BlockCounter)) {
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CounterType.INVERT_LEFT));
            }
        }
        return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CounterType.NORMAL));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    private List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        list.add(COUNTER_TOP);
        if (state.func_177229_b((IProperty)TYPE) == CounterType.INVERT_LEFT) {
            list.add(LEFT_CORNER_BOXES[facing.func_176736_b()]);
        } else if (state.func_177229_b((IProperty)TYPE) == CounterType.INVERT_RIGHT) {
            list.add(RIGHT_CORNER_BOXES[facing.func_176736_b()]);
        } else if (state.func_177229_b((IProperty)TYPE) == CounterType.NORMAL) {
            list.add(FORWARD_BOXES[facing.func_176736_b()]);
        } else {
            list.add(field_185505_j);
        }
        return list;
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public static enum CounterType implements IStringSerializable
    {
        NORMAL,
        CORNER_LEFT,
        CORNER_RIGHT,
        INVERT_LEFT,
        INVERT_RIGHT;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }
    }
}

