/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.advancement.Triggers;
import com.mrcrayfish.furniture.blocks.BlockFurnitureTile;
import com.mrcrayfish.furniture.entity.EntitySittableBlock;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.tileentity.TileEntityCouch;
import com.mrcrayfish.furniture.util.CollisionHelper;
import com.mrcrayfish.furniture.util.SittableUtil;
import com.mrcrayfish.furniture.util.StateHelper;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockCouch
extends BlockFurnitureTile {
    public static final PropertyInteger COLOUR = PropertyInteger.func_177719_a((String)"colour", (int)0, (int)15);
    public static final PropertyEnum<CouchType> TYPE = PropertyEnum.func_177709_a((String)"type", CouchType.class);
    private static final AxisAlignedBB COUCH_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6, 1.0);
    private static final AxisAlignedBB COUCH_BACKREST_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.8, 0.6, 0.0, 1.0, 1.21, 1.0);
    private static final AxisAlignedBB COUCH_BACKREST_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.8, 0.6, 0.0, 1.0, 1.21, 1.0);
    private static final AxisAlignedBB COUCH_BACKREST_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.8, 0.6, 0.0, 1.0, 1.21, 1.0);
    private static final AxisAlignedBB COUCH_BACKREST_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.8, 0.6, 0.0, 1.0, 1.21, 1.0);
    private static final AxisAlignedBB[] COUCH_BACKREST = new AxisAlignedBB[]{COUCH_BACKREST_SOUTH, COUCH_BACKREST_WEST, COUCH_BACKREST_NORTH, COUCH_BACKREST_EAST};
    private static final AxisAlignedBB[] COUCH_BACKREST_LEFT = new AxisAlignedBB[]{COUCH_BACKREST_WEST, COUCH_BACKREST_NORTH, COUCH_BACKREST_EAST, COUCH_BACKREST_SOUTH};
    private static final AxisAlignedBB[] COUCH_BACKREST_RIGHT = new AxisAlignedBB[]{COUCH_BACKREST_EAST, COUCH_BACKREST_SOUTH, COUCH_BACKREST_WEST, COUCH_BACKREST_NORTH};
    private static final AxisAlignedBB COUCH_ARMREST_LEFT_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.5, 0.9, 1.0, 0.9, 1.0);
    private static final AxisAlignedBB COUCH_ARMREST_LEFT_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.0, 0.5, 0.9, 1.0, 0.9, 1.0);
    private static final AxisAlignedBB COUCH_ARMREST_LEFT_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.0, 0.5, 0.9, 1.0, 0.9, 1.0);
    private static final AxisAlignedBB COUCH_ARMREST_LEFT_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.0, 0.5, 0.9, 1.0, 0.9, 1.0);
    private static final AxisAlignedBB[] COUCH_ARMREST_LEFT = new AxisAlignedBB[]{COUCH_ARMREST_LEFT_SOUTH, COUCH_ARMREST_LEFT_WEST, COUCH_ARMREST_LEFT_NORTH, COUCH_ARMREST_LEFT_EAST};
    private static final AxisAlignedBB COUCH_ARMREST_RIGHT_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.5, 0.0, 1.0, 0.9, 0.1);
    private static final AxisAlignedBB COUCH_ARMREST_RIGHT_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.0, 0.5, 0.0, 1.0, 0.9, 0.1);
    private static final AxisAlignedBB COUCH_ARMREST_RIGHT_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.0, 0.5, 0.0, 1.0, 0.9, 0.1);
    private static final AxisAlignedBB COUCH_ARMREST_RIGHT_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.0, 0.5, 0.0, 1.0, 0.9, 0.1);
    private static final AxisAlignedBB[] COUCH_ARMREST_RIGHT = new AxisAlignedBB[]{COUCH_ARMREST_RIGHT_SOUTH, COUCH_ARMREST_RIGHT_WEST, COUCH_ARMREST_RIGHT_NORTH, COUCH_ARMREST_RIGHT_EAST};

    public BlockCouch() {
        super(Material.field_151580_n);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185854_g);
        IBlockState baseState = this.field_176227_L.func_177621_b();
        if (this.isSpecial()) {
            this.func_180632_j(baseState.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)CouchType.BOTH)));
        } else {
            this.func_180632_j(baseState.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)CouchType.BOTH)).func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(0)));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!this.isSpecial()) {
            int colour = ((TileEntityCouch)world.func_175625_s(pos)).getColour();
            state = state.func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(colour));
        }
        if (StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) instanceof BlockCouch) {
            if (StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) == StateHelper.Direction.RIGHT) {
                return state.func_177226_a(TYPE, (Comparable)((Object)CouchType.CORNER_RIGHT));
            }
            if (StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) == StateHelper.Direction.LEFT) {
                return state.func_177226_a(TYPE, (Comparable)((Object)CouchType.CORNER_LEFT));
            }
        }
        boolean left = false;
        boolean right = false;
        if (!StateHelper.isAirBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.LEFT)) {
            left = true;
        }
        if (!StateHelper.isAirBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.RIGHT)) {
            right = true;
        }
        if (left && !right) {
            return state.func_177226_a(TYPE, (Comparable)((Object)CouchType.LEFT));
        }
        if (!left && right) {
            return state.func_177226_a(TYPE, (Comparable)((Object)CouchType.RIGHT));
        }
        if (!left && !right) {
            return state.func_177226_a(TYPE, (Comparable)((Object)CouchType.BOTH));
        }
        return state.func_177226_a(TYPE, (Comparable)((Object)CouchType.NONE));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        if (!this.isSpecial()) {
            state = state.func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(0));
        }
        return state;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!this.isSpecial()) {
            if (!heldItem.func_190926_b() && heldItem.func_77973_b() == Items.field_151057_cb && heldItem.func_82837_s() && heldItem.func_82833_r().equals("jeb_")) {
                worldIn.func_175656_a(pos, FurnitureBlocks.COUCH_JEB.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
                if (!playerIn.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
                Triggers.trigger(Triggers.CREATE_COUCH_JEB, playerIn);
                return true;
            }
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof TileEntityCouch) {
                TileEntityCouch tileEntityCouch = (TileEntityCouch)tileEntity;
                if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemDye) {
                    tileEntityCouch.setColour(heldItem.func_77952_i());
                    if (!playerIn.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                    TileEntityUtil.markBlockForUpdate(worldIn, pos);
                    return true;
                }
            }
        }
        return SittableUtil.sitOnBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, 0.45);
    }

    private List<AxisAlignedBB> getCollisionBoxList(IBlockState state, World world, BlockPos pos) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        IBlockState actualState = this.func_176221_a(state, (IBlockAccess)world, pos);
        list.add(COUCH_BACKREST[facing.func_176736_b()]);
        list.add(COUCH_BASE);
        if (actualState.func_177229_b(TYPE) == CouchType.CORNER_LEFT) {
            if (facing.func_176740_k() == EnumFacing.Axis.X) {
                list.add(COUCH_BACKREST[facing.func_176736_b() - 1 < 0 ? 3 : facing.func_176736_b() - 1]);
            } else {
                list.add(COUCH_BACKREST[(facing.func_176736_b() + 1) % 4]);
            }
        } else if (actualState.func_177229_b(TYPE) == CouchType.CORNER_RIGHT) {
            if (facing.func_176740_k() == EnumFacing.Axis.X) {
                list.add(COUCH_BACKREST[(facing.func_176736_b() + 1) % 4]);
            } else {
                list.add(COUCH_BACKREST[facing.func_176736_b() - 1 < 0 ? 3 : facing.func_176736_b() - 1]);
            }
        } else {
            if (StateHelper.isAirBlock((IBlockAccess)world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.LEFT)) {
                list.add(COUCH_ARMREST_LEFT[facing.func_176736_b()]);
            }
            if (StateHelper.isAirBlock((IBlockAccess)world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.RIGHT)) {
                list.add(COUCH_ARMREST_RIGHT[facing.func_176736_b()]);
            }
        }
        return list;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean p_185477_7_) {
        if (!(entity instanceof EntitySittableBlock)) {
            List<AxisAlignedBB> boxes = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)worldIn, pos), worldIn, pos);
            for (AxisAlignedBB box : boxes) {
                BlockFurnitureTile.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
            }
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)world, pos), world, pos)) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCouch();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return this.isSpecial() ? new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE}) : new BlockStateContainer((Block)this, new IProperty[]{FACING, COLOUR, TYPE});
    }

    public abstract boolean isSpecial();

    public static enum CouchType implements IStringSerializable
    {
        NONE,
        LEFT,
        RIGHT,
        BOTH,
        CORNER_LEFT,
        CORNER_RIGHT;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }
    }
}

