/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.advancement.Triggers;
import com.mrcrayfish.furniture.blocks.BlockFurnitureTile;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import com.mrcrayfish.furniture.network.PacketHandler;
import com.mrcrayfish.furniture.network.message.MessageFillBath;
import com.mrcrayfish.furniture.tileentity.TileEntityBath;
import com.mrcrayfish.furniture.util.CollisionHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockBath
extends BlockFurnitureTile {
    public static final PropertyInteger WATER_LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)16);
    public static final AxisAlignedBB BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    public static final AxisAlignedBB SIDE_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.125, 0.0, 1.0, 0.875, 0.125);
    public static final AxisAlignedBB SIDE_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.0, 0.125, 0.0, 1.0, 0.875, 0.125);
    public static final AxisAlignedBB SIDE_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.0, 0.125, 0.0, 1.0, 0.875, 0.125);
    public static final AxisAlignedBB SIDE_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.0, 0.125, 0.0, 1.0, 0.875, 0.125);
    public static final AxisAlignedBB[] TOP_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, -1.0, 1.0, 0.9375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 2.0, 0.9375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 2.0), new AxisAlignedBB(-1.0, 0.0, 0.0, 1.0, 0.9375, 1.0)};
    public static final AxisAlignedBB[] BOTTOM_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 2.0), new AxisAlignedBB(-1.0, 0.0, 0.0, 1.0, 0.9375, 1.0), new AxisAlignedBB(0.0, 0.0, -1.0, 1.0, 0.9375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 2.0, 0.9375, 1.0)};

    public BlockBath(Material material, boolean top) {
        super(material);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185851_d);
        if (top) {
            this.func_149647_a(null);
        }
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        return state.func_177226_a((IProperty)WATER_LEVEL, (Comparable)Integer.valueOf(0));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos.func_177972_a(placer.func_174811_aO()), FurnitureBlocks.BATH_2.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)WATER_LEVEL, state.func_177229_b((IProperty)WATER_LEVEL)));
        if (placer instanceof EntityPlayer) {
            Triggers.trigger(Triggers.PLACE_BATHTROOM_FURNITURE, (EntityPlayer)placer);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return state.func_177230_c() == FurnitureBlocks.BATH_1 ? BOTTOM_BOXES[facing.func_176736_b()] : TOP_BOXES[facing.func_176736_b()];
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockFurnitureTile.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOTTOM);
        if (this == FurnitureBlocks.BATH_1) {
            if (facing != EnumFacing.WEST) {
                BlockFurnitureTile.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SIDE_NORTH);
            }
            if (facing != EnumFacing.EAST) {
                BlockFurnitureTile.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SIDE_SOUTH);
            }
            if (facing != EnumFacing.NORTH) {
                BlockFurnitureTile.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SIDE_EAST);
            }
            if (facing != EnumFacing.SOUTH) {
                BlockFurnitureTile.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SIDE_WEST);
            }
        } else {
            if (facing != EnumFacing.EAST) {
                BlockFurnitureTile.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SIDE_NORTH);
            }
            if (facing != EnumFacing.WEST) {
                BlockFurnitureTile.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SIDE_SOUTH);
            }
            if (facing != EnumFacing.SOUTH) {
                BlockFurnitureTile.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SIDE_EAST);
            }
            if (facing != EnumFacing.NORTH) {
                BlockFurnitureTile.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SIDE_WEST);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        BlockPos otherBathPos = null;
        otherBathPos = this == FurnitureBlocks.BATH_1 ? pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)) : pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d());
        TileEntity tile_entity_1 = worldIn.func_175625_s(pos);
        TileEntity tile_entity_2 = worldIn.func_175625_s(otherBathPos);
        if (tile_entity_1 instanceof TileEntityBath && tile_entity_2 instanceof TileEntityBath) {
            TileEntityBath tileEntityBath = (TileEntityBath)tile_entity_1;
            TileEntityBath tileEntityBath2 = (TileEntityBath)tile_entity_2;
            if (!heldItem.func_190926_b()) {
                if (heldItem.func_77973_b() == Items.field_151133_ar) {
                    if (tileEntityBath.hasWater()) {
                        if (!worldIn.field_72995_K) {
                            if (!playerIn.func_184812_l_()) {
                                if (heldItem.func_190916_E() > 1) {
                                    if (playerIn.field_71071_by.func_70441_a(new ItemStack(Items.field_151131_as))) {
                                        heldItem.func_190918_g(1);
                                    }
                                } else {
                                    playerIn.func_184611_a(hand, new ItemStack(Items.field_151131_as));
                                }
                            }
                            tileEntityBath.removeWaterLevel();
                            tileEntityBath2.removeWaterLevel();
                            worldIn.func_175666_e(pos, (Block)this);
                        } else {
                            playerIn.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                        }
                    }
                } else if (heldItem.func_77973_b() == Items.field_151131_as) {
                    if (!tileEntityBath.isFull()) {
                        if (!worldIn.field_72995_K) {
                            tileEntityBath.addWaterLevel();
                            tileEntityBath2.addWaterLevel();
                            if (!playerIn.func_184812_l_()) {
                                playerIn.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
                            }
                            worldIn.func_175666_e(pos, (Block)this);
                        } else {
                            playerIn.func_184185_a(SoundEvents.field_187624_K, 1.0f, 1.0f);
                            worldIn.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.75 + (double)tileEntityBath.getWaterLevel() * 0.0265, (double)pos.func_177952_p() + 0.5, 0.0, 0.1, 0.0, new int[0]);
                        }
                    }
                } else if (heldItem.func_77973_b() == Items.field_151069_bo) {
                    if (tileEntityBath.hasWater()) {
                        if (!worldIn.field_72995_K) {
                            if (!playerIn.func_184812_l_()) {
                                if (heldItem.func_190916_E() > 1) {
                                    if (playerIn.field_71071_by.func_70441_a(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b))) {
                                        heldItem.func_190918_g(1);
                                    }
                                } else {
                                    playerIn.func_184611_a(hand, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b));
                                }
                            }
                            tileEntityBath.removeWaterLevel();
                            tileEntityBath2.removeWaterLevel();
                            worldIn.func_175666_e(pos, (Block)this);
                        } else {
                            playerIn.func_184185_a(SoundEvents.field_187615_H, 1.0f, 1.0f);
                        }
                    }
                } else if (PotionUtils.func_185191_c((ItemStack)heldItem) == PotionTypes.field_185230_b) {
                    if (!tileEntityBath.isFull()) {
                        if (!worldIn.field_72995_K) {
                            tileEntityBath.addWaterLevel();
                            tileEntityBath2.addWaterLevel();
                            if (!playerIn.func_184812_l_()) {
                                if (heldItem.func_77973_b() == Items.field_151068_bn) {
                                    playerIn.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
                                } else {
                                    playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                                }
                            }
                            worldIn.func_175666_e(pos, (Block)this);
                        } else {
                            playerIn.func_184185_a(SoundEvents.field_191241_J, 1.0f, 1.0f);
                            worldIn.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.75 + (double)tileEntityBath.getWaterLevel() * 0.0265, (double)pos.func_177952_p() + 0.5, 0.0, 0.1, 0.0, new int[0]);
                        }
                    }
                } else if (this.hasWaterSource(worldIn, pos) && !tileEntityBath.isFull()) {
                    if (this == FurnitureBlocks.BATH_2) {
                        if (!worldIn.field_72995_K) {
                            tileEntityBath.addWaterLevel();
                            tileEntityBath2.addWaterLevel();
                            worldIn.func_175698_g(pos.func_177982_a(0, -2, 0));
                            worldIn.func_175666_e(pos, (Block)this);
                        } else {
                            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, FurnitureSounds.tap, SoundCategory.BLOCKS, 0.75f, 0.8f, true);
                        }
                    } else if (!worldIn.field_72995_K) {
                        playerIn.func_145747_a((ITextComponent)new TextComponentString("You need to have a water source under the block the bath head is on to fill it. Alternatively you can use a water bucket to fill it."));
                    }
                }
            } else if (this.hasWaterSource(worldIn, pos) && !tileEntityBath.isFull()) {
                if (this == FurnitureBlocks.BATH_2) {
                    if (!worldIn.field_72995_K) {
                        tileEntityBath.addWaterLevel();
                        tileEntityBath2.addWaterLevel();
                        worldIn.func_175698_g(pos.func_177982_a(0, -2, 0));
                        worldIn.func_175666_e(pos, (Block)this);
                    } else {
                        worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, FurnitureSounds.tap, SoundCategory.BLOCKS, 0.75f, 0.8f, true);
                    }
                } else if (!worldIn.field_72995_K) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("You need to have a water source under the block the bath head is on to fill it. Alternatively you can use a water bucket to fill it."));
                }
            }
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageFillBath(tileEntityBath.getWaterLevel(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), otherBathPos.func_177958_n(), otherBathPos.func_177956_o(), otherBathPos.func_177952_p()), new NetworkRegistry.TargetPoint(playerIn.field_71093_bK, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 128.0));
            worldIn.func_175704_b(pos, pos);
            worldIn.func_175704_b(otherBathPos, otherBathPos);
        }
        return true;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (this == FurnitureBlocks.BATH_1) {
            worldIn.func_175655_b(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)), false);
        } else {
            worldIn.func_175655_b(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d()), false);
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBath();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return new ItemStack(FurnitureBlocks.BATH_1).func_77973_b();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(FurnitureBlocks.BATH_1);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileEntityBath) {
            TileEntityBath bath = (TileEntityBath)world.func_175625_s(pos);
            return state.func_177226_a((IProperty)WATER_LEVEL, (Comparable)Integer.valueOf(bath.getWaterLevel()));
        }
        return state.func_177226_a((IProperty)WATER_LEVEL, (Comparable)Integer.valueOf(0));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, WATER_LEVEL});
    }

    public static boolean canPlaceBath(World world, BlockPos pos, EnumFacing facing) {
        return world.func_175623_d(pos) && world.func_175623_d(pos.func_177967_a(facing, 1));
    }

    public boolean hasWaterSource(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177982_a(0, -2, 0)) == Blocks.field_150355_j.func_176223_P();
    }

    @Override
    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityBath bath = (TileEntityBath)world.func_175625_s(pos);
        return bath.getWaterLevel();
    }
}

