/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.advancement.Triggers;
import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBasin
extends BlockFurniture {
    public static final AxisAlignedBB[] PILLAR = new AxisAlignedBB[]{new AxisAlignedBB(0.1875, 0.0, 0.5, 0.8125, 0.6875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.1875, 0.5, 0.6875, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.6875, 0.5), new AxisAlignedBB(0.5, 0.0, 0.1875, 1.0, 0.6875, 0.8125)};
    public static final AxisAlignedBB TOP = new AxisAlignedBB(0.0, 0.6875, 0.0, 1.0, 1.0, 1.0);
    public static final PropertyBool FILLED = PropertyBool.func_177716_a((String)"filled");

    public BlockBasin(Material material) {
        super(material);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            Triggers.trigger(Triggers.PLACE_BATHTROOM_FURNITURE, (EntityPlayer)placer);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        List<AxisAlignedBB> list = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)worldIn, pos));
        for (AxisAlignedBB box : list) {
            BlockFurniture.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        world.func_175666_e(pos, (Block)this);
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        world.func_175666_e(pos, (Block)this);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            if (heldItem.func_77973_b() == Items.field_151133_ar) {
                if (this.hasWater(state)) {
                    if (!worldIn.field_72995_K) {
                        if (!playerIn.func_184812_l_()) {
                            if (heldItem.func_190916_E() > 1) {
                                if (playerIn.field_71071_by.func_70441_a(new ItemStack(Items.field_151131_as))) {
                                    heldItem.func_190918_g(1);
                                }
                            } else {
                                playerIn.func_184611_a(hand, new ItemStack(Items.field_151131_as));
                            }
                        }
                        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(false)));
                        worldIn.func_175666_e(pos, (Block)this);
                    } else {
                        playerIn.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                    }
                }
            } else if (heldItem.func_77973_b() == Items.field_151131_as) {
                if (!this.hasWater(state)) {
                    if (!worldIn.field_72995_K) {
                        if (!playerIn.func_184812_l_()) {
                            playerIn.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
                        }
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(true)), 2);
                        worldIn.func_175666_e(pos, (Block)this);
                    } else {
                        playerIn.func_184185_a(SoundEvents.field_187624_K, 1.0f, 1.0f);
                        this.createSplashParticle(worldIn, pos);
                    }
                }
            } else if (heldItem.func_77973_b() == Items.field_151069_bo) {
                if (this.hasWater(state)) {
                    if (!worldIn.field_72995_K) {
                        if (!playerIn.func_184812_l_()) {
                            if (heldItem.func_190916_E() > 1) {
                                if (playerIn.field_71071_by.func_70441_a(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b))) {
                                    heldItem.func_190918_g(1);
                                }
                            } else {
                                playerIn.func_184611_a(hand, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b));
                            }
                        }
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(false)), 2);
                        worldIn.func_175666_e(pos, (Block)this);
                    } else {
                        playerIn.func_184185_a(SoundEvents.field_187615_H, 1.0f, 1.0f);
                        this.createSplashParticle(worldIn, pos);
                    }
                }
            } else if (PotionUtils.func_185191_c((ItemStack)heldItem) == PotionTypes.field_185230_b) {
                if (!this.hasWater(state)) {
                    if (!worldIn.field_72995_K) {
                        if (!playerIn.func_184812_l_()) {
                            if (heldItem.func_77973_b() == Items.field_151068_bn) {
                                playerIn.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
                            } else {
                                playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                            }
                        }
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(true)), 2);
                        worldIn.func_175666_e(pos, (Block)this);
                    } else {
                        playerIn.func_184185_a(SoundEvents.field_191241_J, 1.0f, 1.0f);
                        this.createSplashParticle(worldIn, pos);
                    }
                }
            } else if (!this.hasWater(state)) {
                if (this.hasWaterSource(worldIn, pos)) {
                    if (!worldIn.field_72995_K) {
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(true)), 2);
                        worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, FurnitureSounds.tap, SoundCategory.BLOCKS, 0.75f, 1.0f);
                        worldIn.func_175698_g(pos.func_177982_a(0, -2, 0));
                        worldIn.func_175666_e(pos, (Block)this);
                    } else {
                        this.createSplashParticle(worldIn, pos);
                    }
                } else if (!worldIn.field_72995_K) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString("You need to have a water source under the block the basin is on to fill it. Alternatively you can use a water bucket to fill it."));
                }
            }
        } else if (!this.hasWater(state)) {
            if (this.hasWaterSource(worldIn, pos)) {
                if (!worldIn.field_72995_K) {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(true)), 2);
                    worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, FurnitureSounds.tap, SoundCategory.BLOCKS, 0.75f, 1.0f);
                    worldIn.func_175698_g(pos.func_177982_a(0, -2, 0));
                    worldIn.func_175666_e(pos, (Block)this);
                } else {
                    this.createSplashParticle(worldIn, pos);
                }
            } else if (!worldIn.field_72995_K) {
                playerIn.func_145747_a((ITextComponent)new TextComponentString("You need to have a water source under the block the basin is on to fill it. Alternatively you can use a water bucket to fill it."));
            }
        }
        return true;
    }

    private void createSplashParticle(World world, BlockPos pos) {
        for (int i = 0; i < 5; ++i) {
            world.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)pos.func_177958_n() + 0.3 + 0.4 * RANDOM.nextDouble(), (double)pos.func_177956_o() + 1.05, (double)pos.func_177952_p() + 0.3 + 0.4 * RANDOM.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(meta / 4 >= 1));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)FILLED) != false ? 4 : 0);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, FILLED});
    }

    private boolean hasWater(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)FILLED);
    }

    private boolean hasWaterSource(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177982_a(0, -2, 0)) == Blocks.field_150355_j.func_176223_P();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)FILLED) != false ? 1 : 0;
    }

    private List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        list.add(PILLAR[facing.func_176736_b()]);
        list.add(TOP);
        return list;
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }
}

