/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab.inventory;

import icbm.classic.prefab.inventory.InventorySlot;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;

public class InventoryWithSlots
extends ItemStackHandler {
    private final InventorySlot[] slotHandlers;
    private BiConsumer<Integer, ItemStack> onContentChange;

    public InventoryWithSlots(int size) {
        super(size);
        this.slotHandlers = new InventorySlot[size];
    }

    public void setSize(int size) {
        this.stacks = NonNullList.func_191197_a((int)Math.max(size, this.stacks.size()), (Object)ItemStack.field_190927_a);
    }

    public void onTick() {
        for (InventorySlot slot : this.slotHandlers) {
            if (slot == null || slot.getOnTick() == null) continue;
            this.setStackInSlot(slot.getSlot(), slot.getOnTick().apply(this.getStackInSlot(slot.getSlot())));
        }
    }

    protected void onContentsChanged(int slot) {
        if (this.onContentChange != null) {
            this.onContentChange.accept(slot, this.getStackInSlot(slot));
        }
        this.getSlot(slot).map(InventorySlot::getOnContentChanged).ifPresent(s -> s.accept(this.getStackInSlot(slot)));
    }

    public InventoryWithSlots withSlot(InventorySlot slot) {
        this.slotHandlers[slot.getSlot()] = slot;
        return this;
    }

    public InventoryWithSlots withChangeCallback(BiConsumer<Integer, ItemStack> onChange) {
        this.onContentChange = onChange;
        return this;
    }

    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.isItemValid(slot, stack) && this.getSlot(slot).map(InventorySlot::getOnInsertStack).map(s -> (Boolean)s.apply(stack)).orElse(true) != false ? super.insertItem(slot, stack, simulate) : stack;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        return this.getSlot(slot).map(InventorySlot::getValidator).map(s -> (Boolean)s.apply(stack)).orElse(false);
    }

    public Optional<InventorySlot> getSlot(int slot) {
        if (slot < this.slotHandlers.length) {
            return Optional.ofNullable(this.slotHandlers[slot]);
        }
        return Optional.empty();
    }

    public BiConsumer<Integer, ItemStack> getOnContentChange() {
        return this.onContentChange;
    }
}

