/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.radio;

import icbm.classic.ICBMClassic;
import icbm.classic.api.data.IBoundBox;
import icbm.classic.api.radio.IRadioMessage;
import icbm.classic.api.radio.IRadioReceiver;
import icbm.classic.api.radio.IRadioSender;
import icbm.classic.lib.data.BoundBlockPos;
import icbm.classic.lib.radio.RadioMap;
import java.util.HashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class RadioRegistry {
    public static final RadioRegistry INSTANCE = new RadioRegistry();
    public static final IBoundBox<BlockPos> INFINITE = new BoundBlockPos(-2147483647, -2147483647, -2147483647, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static final HashMap<Integer, RadioMap> RADIO_MAPS = new HashMap();
    public static String EMPTY_HZ = "";

    public static boolean add(IRadioReceiver receiver) {
        if (receiver.getWorld() == null) {
            return false;
        }
        return RadioRegistry.getRadarMapForDim(receiver.getWorld().field_73011_w.getDimension()).add(receiver);
    }

    public static boolean addOrUpdate(IRadioReceiver receiver) {
        if (!RadioRegistry.add(receiver)) {
            RadioMap map = RadioRegistry.getRadarMapForDim(receiver.getWorld().field_73011_w.getDimension());
            if (map.receive_to_chunks.containsKey(receiver)) {
                map.update(receiver);
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean remove(IRadioReceiver tile) {
        if (tile.getWorld() == null) {
            return false;
        }
        if (RADIO_MAPS.containsKey(tile.getWorld().field_73011_w.getDimension())) {
            RadioMap map = RadioRegistry.getRadarMapForDim(tile.getWorld().field_73011_w.getDimension());
            return map.remove(tile);
        }
        return false;
    }

    public static void popMessage(World world, IRadioSender sender, IRadioMessage packet) {
        if (world == null || world.field_73011_w == null || world.field_72995_K) {
            ICBMClassic.logger().error("RadarRegistry: Invalid world : " + world, (Throwable)new RuntimeException());
            return;
        }
        if (RADIO_MAPS.containsKey(world.field_73011_w.getDimension())) {
            RadioMap map = RadioRegistry.getRadarMapForDim(world.field_73011_w.getDimension());
            map.popMessage(sender, packet);
        }
    }

    public static RadioMap getRadioMapForWorld(World world) {
        if (world != null && world.field_73011_w != null) {
            if (world.field_72995_K) {
                if (ICBMClassic.runningAsDev) {
                    ICBMClassic.logger().error("RadarRegistry: Radar data can not be requested client side.", (Throwable)new RuntimeException());
                }
                return null;
            }
            return RadioRegistry.getRadarMapForDim(world.field_73011_w.getDimension());
        }
        if (ICBMClassic.runningAsDev) {
            ICBMClassic.logger().error("RadarRegistry: World can not be null or have a null provider when requesting a radar map", (Throwable)new RuntimeException());
        }
        return null;
    }

    public static RadioMap getRadarMapForDim(int dimID) {
        if (!RADIO_MAPS.containsKey(dimID)) {
            RadioMap map = new RadioMap(dimID);
            RADIO_MAPS.put(dimID, map);
            return map;
        }
        return RADIO_MAPS.get(dimID);
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        int dim;
        if (event.getWorld().field_73011_w != null && RADIO_MAPS.containsKey(dim = event.getWorld().field_73011_w.getDimension())) {
            RadioRegistry.getRadarMapForDim(dim).unloadAll();
            RADIO_MAPS.remove(dim);
        }
    }
}

