/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib;

import icbm.classic.ICBMClassic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;

public class LanguageUtility {
    public static int toolTipLineLength = 30;

    public static String getLocal(String key) {
        if (key == null || key.isEmpty()) {
            if (ICBMClassic.runningAsDev) {
                ICBMClassic.logger().error("LanguageUtility.getLocal(" + key + ") - invalid key", (Throwable)new RuntimeException());
            }
            return "error.key.empty";
        }
        String translation = I18n.func_74838_a((String)key);
        if (translation == null || translation.isEmpty()) {
            if (ICBMClassic.runningAsDev) {
                ICBMClassic.logger().error("LanguageUtility.getLocal(" + key + ") - no translation", (Throwable)new RuntimeException());
            }
            return key;
        }
        return translation;
    }

    public static String getLocalName(String key) {
        String translation;
        if (key == null || key.isEmpty()) {
            if (ICBMClassic.runningAsDev) {
                ICBMClassic.logger().error("LanguageUtility.getLocalName(" + key + ")", (Throwable)new RuntimeException());
            }
            return "error.key.empty";
        }
        if (!key.endsWith(".name")) {
            key = key + ".name";
        }
        if ((translation = I18n.func_74838_a((String)key)) == null || translation.isEmpty()) {
            if (ICBMClassic.runningAsDev) {
                ICBMClassic.logger().error("LanguageUtility.getLocal(" + key + ") - no translation", (Throwable)new RuntimeException());
            }
            return key;
        }
        return translation;
    }

    public static Integer getLangSetting(String key, int backup) {
        block3: {
            String result = LanguageUtility.getLocal(key);
            if (result != null && !result.isEmpty()) {
                try {
                    return Integer.parseInt(key);
                }
                catch (NumberFormatException e) {
                    if (!ICBMClassic.runningAsDev) break block3;
                    ICBMClassic.logger().error("LanguageUtility.getLangSetting(" + key + ")", (Throwable)e);
                }
            }
        }
        return backup;
    }

    public static ITextComponent getLocalChat(String key) {
        return new TextComponentTranslation(key, new Object[0]);
    }

    public static void addChatToPlayer(EntityPlayer player, String key) {
        if (player != null) {
            player.func_145747_a(LanguageUtility.getLocalChat(key));
        } else if (ICBMClassic.runningAsDev) {
            ICBMClassic.logger().error("LanguageUtility.addChatToPlayer(Null Player, " + key + ")", (Throwable)new RuntimeException());
        }
    }

    public static List<String> splitStringPerWord(String string) {
        return Arrays.asList(LanguageUtility.toWordArray(string));
    }

    public static String[] toWordArray(String string) {
        return string.trim().split("\\W+");
    }

    public static List<String> splitByLine(String string) {
        return LanguageUtility.splitByLine(string, toolTipLineLength);
    }

    public static List<String> splitByLine(String string, int charsPerLine) {
        String[] words = string.split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        String line = "";
        int indent = 0;
        for (String word : words) {
            if (word.trim().startsWith("\\t")) {
                indent += 2;
                continue;
            }
            if (word.trim().startsWith("-\\t")) {
                indent -= 2;
                continue;
            }
            if (word.contains("\\n")) {
                if (word.trim().equals("\\n")) {
                    lines.add(LanguageUtility.addSpacesLeft(line, indent));
                    line = "";
                    continue;
                }
                line = line + word.replace("\\n", "").trim();
                continue;
            }
            if (word.length() + line.length() <= charsPerLine) {
                line = line + word + " ";
                continue;
            }
            lines.add(LanguageUtility.addSpacesLeft(line, indent));
            line = word + " ";
        }
        lines.add(LanguageUtility.addSpacesLeft(line.trim(), indent));
        return lines;
    }

    private static String addSpacesLeft(String line, int pad) {
        if (pad <= 0) {
            return line;
        }
        return String.format("%1$" + pad + "s", "") + line;
    }

    public static String capitalizeFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1, str.length());
    }

    public static String decapitalizeFirst(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1, str.length());
    }

    public static String posFormatted(Vec3d pos) {
        return String.format("%.2f, %.2f, %.2f", pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public static String posFormatted(BlockPos pos) {
        return String.format("%d, %d, %d", pos.func_177958_n(), pos.func_177958_n(), pos.func_177952_p());
    }
}

