/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.entity.explosive;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.explosion.BlastState;
import icbm.classic.api.explosion.responses.BlastResponse;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.missile.entity.EntityMissile;
import icbm.classic.content.missile.logic.TargetRangeDet;
import icbm.classic.lib.capability.ex.CapabilityExplosiveEntity;
import icbm.classic.lib.explosive.ExplosiveHandler;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.saving.NbtSaveNode;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class EntityExplosiveMissile
extends EntityMissile<EntityExplosiveMissile> {
    public final TargetRangeDet targetRangeDet = new TargetRangeDet(this);
    public final CapabilityExplosiveEntity explosive = new CapabilityExplosiveEntity(this);
    public boolean isExploding = false;
    private static final NbtSaveHandler<EntityExplosiveMissile> SAVE_LOGIC = new NbtSaveHandler().mainRoot().node(new NbtSaveNode<EntityExplosiveMissile, NBTTagCompound>("explosive", missile -> missile.explosive.serializeNBT(), (missile, data) -> missile.explosive.deserializeNBT((NBTTagCompound)data))).base();

    public EntityExplosiveMissile(World w) {
        super(w);
        this.func_70105_a(0.5f, 0.5f);
        this.inAirKillTime = 144000;
        this.field_70178_ae = true;
        this.field_70158_ak = true;
        this.setHealth(this.getMaxHealth());
    }

    @Override
    public float getMaxHealth() {
        if (this.explosive.getExplosiveData() != null) {
            switch (this.explosive.getExplosiveData().getTier()) {
                case TWO: {
                    return ConfigMissile.TIER_2_HEALTH;
                }
                case THREE: {
                    return ConfigMissile.TIER_3_HEALTH;
                }
                case FOUR: {
                    return ConfigMissile.TIER_4_HEALTH;
                }
            }
        }
        return ConfigMissile.TIER_1_HEALTH;
    }

    @Override
    protected void onDestroyedBy(DamageSource source, float damage) {
        super.onDestroyedBy(source, damage);
        if (source.func_94541_c() || source.func_76347_k()) {
            this.doExplosion(this.func_174791_d());
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY) {
            return (T)ICBMClassicAPI.EXPLOSIVE_CAPABILITY.cast((Object)this.explosive);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ICBMClassicAPI.EXPLOSIVE_CAPABILITY || super.hasCapability(capability, facing);
    }

    public String func_70005_c_() {
        IExplosiveData data = this.explosive.getExplosiveData();
        if (data != null) {
            return I18n.func_74838_a((String)("missile." + data.getRegistryName().toString() + ".name"));
        }
        return I18n.func_74838_a((String)"missile.icbmclassic:generic.name");
    }

    @Override
    public void writeSpawnData(ByteBuf additionalMissileData) {
        NBTTagCompound saveData = SAVE_LOGIC.save(this, new NBTTagCompound());
        ByteBufUtils.writeTag((ByteBuf)additionalMissileData, (NBTTagCompound)saveData);
        super.writeSpawnData(additionalMissileData);
    }

    @Override
    public void readSpawnData(ByteBuf additionalMissileData) {
        NBTTagCompound saveData = ByteBufUtils.readTag((ByteBuf)additionalMissileData);
        SAVE_LOGIC.load(this, saveData);
        super.readSpawnData(additionalMissileData);
    }

    @Override
    public void func_70071_h_() {
        this.targetRangeDet.update();
        super.func_70071_h_();
    }

    @Override
    public boolean func_184230_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (ICBMClassicAPI.EX_MISSILE_REGISTRY.onInteraction(this, player, hand)) {
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    @Override
    protected void onImpact(Vec3d impactLocation) {
        super.onImpact(impactLocation);
        this.doExplosion(impactLocation);
    }

    public BlastResponse doExplosion(Vec3d impactLocation) {
        try {
            if (!this.isExploding) {
                this.isExploding = true;
                if (!this.field_70170_p.field_72995_K) {
                    return ExplosiveHandler.createExplosion(this, this.field_70170_p, impactLocation.field_72450_a, impactLocation.field_72448_b, impactLocation.field_72449_c, this.explosive);
                }
                return BlastState.TRIGGERED_CLIENT.genericResponse;
            }
            return BlastState.ALREADY_TRIGGERED.genericResponse;
        }
        catch (Exception e) {
            return new BlastResponse(BlastState.ERROR, e.getMessage(), e);
        }
    }

    @Override
    public ItemStack toStack() {
        return this.explosive.toStack();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        SAVE_LOGIC.load(this, nbt);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        SAVE_LOGIC.save(this, nbt);
    }
}

