/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.entity.anti;

import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.missile.entity.EntityMissile;
import icbm.classic.content.missile.entity.anti.SAMTargetData;
import icbm.classic.content.missile.logic.flight.FollowTargetLogic;
import icbm.classic.content.reg.ItemReg;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class EntitySurfaceToAirMissile
extends EntityMissile<EntitySurfaceToAirMissile> {
    private ItemStack renderStackCache;
    protected final SAMTargetData scanLogic = new SAMTargetData(this);
    private boolean hasStartedFollowing = false;

    public EntitySurfaceToAirMissile(World world) {
        super(world);
        this.getMissileCapability().setTargetData(this.scanLogic);
    }

    @Override
    public float getMaxHealth() {
        return ConfigMissile.TIER_2_HEALTH;
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            double distance;
            this.scanLogic.tick();
            Entity currentTarget = this.scanLogic.getTarget();
            if (!this.hasStartedFollowing && currentTarget != null && this.getMissileCapability().getFlightLogic().canSafelyExitLogic()) {
                this.hasStartedFollowing = true;
                this.getMissileCapability().setTargetData(this.scanLogic);
                this.getMissileCapability().setFlightLogic(new FollowTargetLogic(ConfigMissile.SAM_MISSILE.FUEL));
            }
            if (currentTarget != null && (distance = (double)this.func_70032_d(currentTarget)) <= (double)ConfigMissile.SAM_MISSILE.FLIGHT_SPEED) {
                currentTarget.func_70097_a((DamageSource)new EntityDamageSource("missile", (Entity)this), ConfigMissile.SAM_MISSILE.ATTACK_DAMAGE);
                this.func_70106_y();
            }
        }
        super.func_70071_h_();
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing);
    }

    @Override
    public ItemStack toStack() {
        if (this.field_70170_p.field_72995_K) {
            if (this.renderStackCache == null) {
                this.renderStackCache = new ItemStack((Item)ItemReg.itemSAM);
            }
            return this.renderStackCache;
        }
        return new ItemStack((Item)ItemReg.itemSAM);
    }
}

