/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.items;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.events.LaserRemoteTriggerEvent;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.lib.network.packet.PacketPlayerItem;
import icbm.classic.lib.radio.RadioRegistry;
import icbm.classic.lib.radio.messages.TriggerActionTargetMessage;
import icbm.classic.prefab.FakeRadioSender;
import icbm.classic.prefab.item.ItemRadio;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ItemLaserDetonator
extends ItemRadio
implements IPacketIDReceiver {
    private static final int COOLDOWN = 20;
    private int clientCooldownTicks = 0;

    public ItemLaserDetonator() {
        this.setName("laserDetonator");
        this.func_77637_a(ICBMClassic.CREATIVE_TAB);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (world.field_72995_K && this.clientCooldownTicks <= 0) {
            TileEntity tileEntity;
            this.clientCooldownTicks = 20;
            RayTraceResult objectMouseOver = player.func_174822_a(200.0, 1.0f);
            if (objectMouseOver.field_72313_a != RayTraceResult.Type.MISS && !ICBMClassicHelpers.isLauncher(tileEntity = world.func_175625_s(objectMouseOver.func_178782_a()), null)) {
                ICBMClassic.packetHandler.sendToServer(new PacketPlayerItem(player).addData(new Object[]{objectMouseOver.field_72307_f}));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (world.field_72995_K) {
            this.clientCooldownTicks = 0;
        }
        return super.func_77654_b(stack, world, entityLiving);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K && this.clientCooldownTicks > 0) {
            --this.clientCooldownTicks;
        }
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, IPacket packet) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack.func_77973_b() == this && !player.field_70170_p.field_72995_K) {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            Vec3d target = new Vec3d(x, y, z);
            ((WorldServer)player.func_130014_f_()).func_152344_a(() -> {
                LaserRemoteTriggerEvent event = new LaserRemoteTriggerEvent(player.field_70170_p, target, player);
                if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_77667_c(stack) + ".target", new Object[]{this.formatNumber(event.getPos().field_72450_a), this.formatNumber(event.getPos().field_72448_b), this.formatNumber(event.getPos().field_72449_c)}), false);
                    RadioRegistry.popMessage(player.field_70170_p, new FakeRadioSender(player, stack, null), new TriggerActionTargetMessage(this.getRadioChannel(stack), event.getPos()));
                } else if (event.cancelReason != null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation(event.cancelReason, new Object[0]), true);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_77667_c(stack) + ".laser.canceled", new Object[0]), false);
                }
            });
        }
        return true;
    }

    private String formatNumber(double d) {
        return String.format("%.2f", d);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }
}

