/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.radarstation;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.config.ConfigMain;
import icbm.classic.content.blocks.radarstation.BlockRadarStation;
import icbm.classic.content.blocks.radarstation.EnumRadarState;
import icbm.classic.content.blocks.radarstation.RadioRadar;
import icbm.classic.content.blocks.radarstation.data.RadarRenderData;
import icbm.classic.content.blocks.radarstation.gui.ContainerRadarStation;
import icbm.classic.content.blocks.radarstation.gui.GuiRadarStation;
import icbm.classic.content.missile.entity.anti.EntitySurfaceToAirMissile;
import icbm.classic.content.reg.BlockReg;
import icbm.classic.lib.energy.storage.EnergyBuffer;
import icbm.classic.lib.energy.system.EnergySystem;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.lib.network.packet.PacketTile;
import icbm.classic.lib.radar.RadarRegistry;
import icbm.classic.lib.radio.RadioRegistry;
import icbm.classic.lib.radio.messages.IncomingMissileMessage;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.inventory.InventorySlot;
import icbm.classic.prefab.inventory.InventoryWithSlots;
import icbm.classic.prefab.tile.IGuiTile;
import icbm.classic.prefab.tile.TileMachine;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class TileRadarStation
extends TileMachine
implements IPacketIDReceiver,
IGuiTile {
    public static final int MAX_DETECTION_RANGE = 500;
    public static final int ENERGY_COST = 1000;
    public static final int ENERGY_CAPACITY = 20000;
    public static final int GUI_PACKET_ID = 1;
    public static final int SET_TRIGGER_RANGE_PACKET_ID = 2;
    public static final int SET_DETECTION_RANGE_PACKET_ID = 3;
    public static final int SET_FREQUENCY_PACKET_ID = 4;
    public static final int SET_OUTPUT_REDSTONE_ID = 5;
    public static final ITextComponent TRANSLATION_GUI_NAME = new TextComponentTranslation("gui.icbmclassic:radar.name", new Object[0]);
    public static final ITextComponent TRANSLATION_TOOLTIP_RANGE = new TextComponentTranslation("gui.icbmclassic:radar.range", new Object[0]);
    public static final ITextComponent TRANSLATION_TOOLTIP_RANGE_SHIFT = new TextComponentTranslation("gui.icbmclassic:radar.range.shift", new Object[0]);
    public static final ITextComponent TRANSLATION_TOOLTIP_REDSTONE_OFF = new TextComponentTranslation("gui.icbmclassic:radar.redstone.off", new Object[0]);
    public static final ITextComponent TRANSLATION_TOOLTIP_REDSTONE_ON = new TextComponentTranslation("gui.icbmclassic:radar.redstone.on", new Object[0]);
    public static final String NBT_DETECTION_RANGE = "detection_range";
    public static final String NBT_TRIGGER_RANGE = "safetyRadius";
    public static final String NBT_OUTPUT_REDSTONE = "emitAll";
    public static final String NBT_INVENTORY = "inventory";
    public static final String NBT_RADIO = "radio";
    private int detectionRange = 100;
    private int triggerRange = 50;
    private boolean outputRedstone = true;
    private final List<Entity> detectedThreats = new ArrayList<Entity>();
    private final List<IMissile> incomingThreats = new ArrayList<IMissile>();
    private final RadarRenderData radarRenderData = new RadarRenderData(this);
    public final EnergyBuffer energyStorage = new EnergyBuffer(() -> 20000).withOnChange((p, c, s) -> {
        this.updateClient = true;
        this.func_70296_d();
    });
    private final InventoryWithSlots inventory = new InventoryWithSlots(1).withChangeCallback((s, i) -> this.func_70296_d()).withSlot(new InventorySlot(0, EnergySystem::isEnergyItem).withTick(this.energyStorage::dischargeItem));
    private final RadioRadar radio = new RadioRadar(this);
    private EnumRadarState radarVisualState = EnumRadarState.OFF;
    private EnumRadarState preRadarVisualState = EnumRadarState.OFF;
    private static final NbtSaveHandler<TileRadarStation> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeINBTSerializable("inventory", TileRadarStation::getInventory).nodeINBTSerializable("radio", TileRadarStation::getRadio).nodeBoolean("emitAll", TileRadarStation::isOutputRedstone, TileRadarStation::setOutputRedstone).nodeInteger("detection_range", TileRadarStation::getDetectionRange, TileRadarStation::setDetectionRange).nodeInteger("safetyRadius", TileRadarStation::getTriggerRange, TileRadarStation::setTriggerRange).nodeInteger("energy", tile -> tile.energyStorage.getEnergyStored(), (tile, i) -> tile.energyStorage.setEnergyStored((int)i)).base();

    @Override
    public void provideInformation(BiConsumer<String, Object> consumer) {
        super.provideInformation(consumer);
        consumer.accept("NEEDS_POWER", ConfigMain.REQUIRES_POWER);
        consumer.accept("ENERGY_COST_TICK", this.getEnergyCost());
        consumer.accept("MAX_RANGE", 500);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.inventory.onTick();
        if (this.isServer()) {
            boolean shouldBeOn;
            boolean hasPower;
            if (this.ticks % 20 == 0) {
                this.sendDescPacket();
            }
            if (hasPower = this.energyStorage.consumePower(this.getEnergyCost(), false)) {
                this.energyStorage.consumePower(this.getEnergyCost(), true);
                if (this.ticks % 3 == 0) {
                    this.doScan();
                }
                if (this.ticks % 20 == 0 && !this.radio.getChannel().equals(RadioRegistry.EMPTY_HZ) && this.incomingThreats.size() > 0) {
                    RadioRegistry.popMessage(this.field_145850_b, this.radio, new IncomingMissileMessage(this.radio.getChannel(), this.incomingThreats.get(0)));
                }
            } else {
                this.incomingThreats.clear();
                this.detectedThreats.clear();
            }
            boolean bl = shouldBeOn = hasPower && this.hasIncomingMissiles();
            if ((Boolean)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockRadarStation.REDSTONE_PROPERTY) != shouldBeOn) {
                BlockPos selfPos = this.func_174877_v();
                ICBMClassic.logger().info("Updating redstone state " + shouldBeOn);
                this.field_145850_b.func_180501_a(selfPos, this.getBlockState().func_177226_a((IProperty)BlockRadarStation.REDSTONE_PROPERTY, (Comparable)Boolean.valueOf(shouldBeOn)), 3);
                for (EnumFacing facing : EnumFacing.values()) {
                    BlockPos targetPos = selfPos.func_177972_a(facing);
                    this.field_145850_b.func_190524_a(targetPos, this.func_145838_q(), this.func_174877_v());
                    this.field_145850_b.func_175695_a(targetPos, this.func_145838_q(), facing.func_176734_d());
                }
            }
        }
        if (this.isServer()) {
            this.radarVisualState = this.getRadarState();
        }
        if (this.preRadarVisualState != this.radarVisualState) {
            this.updateClient = true;
            this.func_70296_d();
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, null, this.getBlockState().func_177226_a((IProperty)BlockRadarStation.RADAR_STATE, (Comparable)((Object)this.preRadarVisualState)), this.getBlockState().func_177226_a((IProperty)BlockRadarStation.RADAR_STATE, (Comparable)((Object)this.radarVisualState)), 3);
            this.preRadarVisualState = this.radarVisualState;
        }
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != BlockReg.blockRadarStation || newState.func_177230_c() != BlockReg.blockRadarStation;
    }

    private void doScan() {
        this.incomingThreats.clear();
        this.detectedThreats.clear();
        this.updateClient = true;
        this.radarRenderData.clear();
        List<Entity> entities = RadarRegistry.getAllLivingObjectsWithin(this.field_145850_b, (double)this.xi() + 0.5, (double)this.yi() + 0.5, (double)this.zi() + 0.5, Math.min(this.detectionRange, 500));
        block0: for (Entity entity : entities) {
            IMissile newMissile;
            if (!TileRadarStation.isThreat(entity) || (newMissile = ICBMClassicHelpers.getMissile(entity)) == null || newMissile.getTicksInAir() <= 1) continue;
            if (this.isMissileGoingToHit(newMissile)) {
                if (this.incomingThreats.size() > 0) {
                    double dist = new Pos(this).distance(newMissile);
                    for (int i = 0; i < this.incomingThreats.size(); ++i) {
                        IMissile missile = this.incomingThreats.get(i);
                        Pos pos = new Pos(this);
                        if (dist < pos.distance(missile)) {
                            this.incomingThreats.add(i, missile);
                            continue block0;
                        }
                        if (i != this.incomingThreats.size() - 1) continue;
                        this.incomingThreats.add(missile);
                        continue block0;
                    }
                    continue;
                }
                this.incomingThreats.add(newMissile);
                continue;
            }
            this.detectedThreats.add(entity);
        }
        if (this.getPlayersUsing().size() > 0) {
            this.radarRenderData.update();
        }
    }

    public static boolean isThreat(Entity entity) {
        return entity != null && !(entity instanceof EntitySurfaceToAirMissile) && entity.hasCapability(ICBMClassicAPI.MISSILE_CAPABILITY, null) && entity.hasCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null);
    }

    public boolean isMissileGoingToHit(IMissile missile) {
        double currentDistance;
        if (missile == null || missile.getMissileEntity() == null || !missile.getMissileEntity().func_70089_S()) {
            return false;
        }
        Vec3d mpos = new Vec3d((double)missile.xf(), (double)missile.yf(), (double)missile.zf());
        Vec3d rpos = new Vec3d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
        double nextDistance = mpos.func_72441_c(missile.getMissileEntity().field_70159_w, missile.getMissileEntity().field_70181_x, missile.getMissileEntity().field_70179_y).func_72438_d(rpos);
        return nextDistance < (currentDistance = mpos.func_72438_d(rpos));
    }

    public EnumRadarState getRadarState() {
        if (this.isClient()) {
            return this.radarVisualState;
        }
        if (!this.energyStorage.consumePower(this.getEnergyCost(), false)) {
            return EnumRadarState.OFF;
        }
        if (this.incomingThreats.size() > 0) {
            return EnumRadarState.DANGER;
        }
        if (this.detectedThreats.size() > 0) {
            return EnumRadarState.WARNING;
        }
        return EnumRadarState.ON;
    }

    @Override
    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        this.radarVisualState = EnumRadarState.get(buf.readByte());
    }

    @Override
    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        buf.writeByte(this.radarVisualState.ordinal());
    }

    @Override
    public boolean read(ByteBuf data, int ID, EntityPlayer player, IPacket type) {
        if (!super.read(data, ID, player, type)) {
            if (!this.field_145850_b.field_72995_K) {
                if (ID == 2) {
                    this.triggerRange = data.readInt();
                    return true;
                }
                if (ID == 3) {
                    this.detectionRange = data.readInt();
                    return true;
                }
                if (ID == 4) {
                    this.radio.setChannel(ByteBufUtils.readUTF8String((ByteBuf)data));
                    return true;
                }
                if (ID == 5) {
                    this.outputRedstone = data.readBoolean();
                    return true;
                }
            } else if (ID == 1) {
                this.detectionRange = data.readInt();
                this.triggerRange = data.readInt();
                this.radio.setChannel(ByteBufUtils.readUTF8String((ByteBuf)data));
                this.outputRedstone = data.readBoolean();
                this.radarRenderData.readBytes(data);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    protected PacketTile getGUIPacket() {
        PacketTile packet = new PacketTile("gui", 1, this);
        packet.addData(new Object[]{this.detectionRange});
        packet.addData(new Object[]{this.triggerRange});
        packet.addData(new Object[]{this.radio.getChannel()});
        packet.addData(new Object[]{this.outputRedstone});
        packet.addData(this.radarRenderData::writeBytes);
        return packet;
    }

    public void sendHzPacket(String channel) {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("frequency_C>S", 4, this).addData(new Object[]{channel}));
        }
    }

    public void sendTriggerRangePacket(int range) {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("triggerRange_C>S", 2, this).addData(new Object[]{range}));
        }
    }

    public void sendDetectionRangePacket(int range) {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("detectionRange_C>S", 3, this).addData(new Object[]{range}));
        }
    }

    public void sendOutputRedstonePacket() {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("outputRedstone_C>S", 5, this).addData(new Object[]{!this.outputRedstone}));
        }
    }

    public int getStrongRedstonePower(EnumFacing side) {
        if (this.outputRedstone && this.incomingThreats.size() > 0) {
            return Math.min(15, this.incomingThreats.size());
        }
        return 0;
    }

    public int getEnergyCost() {
        return 1000;
    }

    public boolean hasIncomingMissiles() {
        return this.incomingThreats.size() > 0;
    }

    public ITextComponent func_145748_c_() {
        return TRANSLATION_GUI_NAME;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityEnergy.ENERGY && ConfigMain.REQUIRES_POWER;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        SAVE_LOGIC.load(this, nbt);
        if (nbt.func_74764_b("frequency")) {
            this.radio.setChannel(Integer.toString(nbt.func_74762_e("frequency")));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        SAVE_LOGIC.save(this, nbt);
        return super.func_189515_b(nbt);
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerRadarStation(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiRadarStation(player, this);
    }

    public int getDetectionRange() {
        return this.detectionRange;
    }

    public void setDetectionRange(int detectionRange) {
        this.detectionRange = detectionRange;
    }

    public int getTriggerRange() {
        return this.triggerRange;
    }

    public void setTriggerRange(int triggerRange) {
        this.triggerRange = triggerRange;
    }

    public boolean isOutputRedstone() {
        return this.outputRedstone;
    }

    public void setOutputRedstone(boolean outputRedstone) {
        this.outputRedstone = outputRedstone;
    }

    public List<Entity> getDetectedThreats() {
        return this.detectedThreats;
    }

    public List<IMissile> getIncomingThreats() {
        return this.incomingThreats;
    }

    public RadarRenderData getRadarRenderData() {
        return this.radarRenderData;
    }

    public InventoryWithSlots getInventory() {
        return this.inventory;
    }

    public RadioRadar getRadio() {
        return this.radio;
    }
}

