/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.screen;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.events.LauncherSetTargetEvent;
import icbm.classic.api.launcher.IActionStatus;
import icbm.classic.api.launcher.IMissileLauncher;
import icbm.classic.api.missiles.cause.IMissileCause;
import icbm.classic.config.ConfigMain;
import icbm.classic.config.machines.ConfigLauncher;
import icbm.classic.content.blocks.launcher.LauncherLangs;
import icbm.classic.content.blocks.launcher.network.ILauncherComponent;
import icbm.classic.content.blocks.launcher.network.LauncherEntry;
import icbm.classic.content.blocks.launcher.network.LauncherNode;
import icbm.classic.content.blocks.launcher.screen.BlockScreenCause;
import icbm.classic.content.blocks.launcher.screen.LauncherPair;
import icbm.classic.content.blocks.launcher.screen.RadioScreen;
import icbm.classic.content.blocks.launcher.screen.gui.ContainerLaunchScreen;
import icbm.classic.content.blocks.launcher.screen.gui.GuiLauncherScreen;
import icbm.classic.content.missile.logic.targeting.BasicTargetData;
import icbm.classic.lib.energy.storage.EnergyBuffer;
import icbm.classic.lib.energy.system.EnergySystem;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.lib.network.packet.PacketTile;
import icbm.classic.lib.radio.RadioRegistry;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.prefab.inventory.InventorySlot;
import icbm.classic.prefab.inventory.InventoryWithSlots;
import icbm.classic.prefab.tile.TileMachine;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileLauncherScreen
extends TileMachine
implements IPacketIDReceiver,
ILauncherComponent {
    public static final int SET_FREQUENCY_PACKET_ID = 0;
    public static final int SET_TARGET_PACKET_ID = 1;
    public static final int LAUNCH_PACKET_ID = 2;
    public static final int GUI_PACKET_ID = 3;
    public static final int RADIO_DISABLE_PACKET_ID = 4;
    private Vec3d _targetPos = Vec3d.field_186680_a;
    public final EnergyBuffer energyStorage = new EnergyBuffer(() -> ConfigLauncher.POWER_CAPACITY).withOnChange((p, c, s) -> {
        this.updateClient = true;
        this.func_70296_d();
    });
    public final InventoryWithSlots inventory = new InventoryWithSlots(1).withChangeCallback((s, i) -> this.func_70296_d()).withSlot(new InventorySlot(0, EnergySystem::isEnergyItem).withTick(this.energyStorage::dischargeItem));
    private final LauncherNode launcherNode = new LauncherNode(this, false);
    public final RadioScreen radioCap = new RadioScreen(this);
    private float launcherInaccuracy = 0.0f;
    private final List<LauncherPair> statusList = new ArrayList<LauncherPair>();
    private boolean refreshStatus = false;
    private static final NbtSaveHandler<TileLauncherScreen> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeINBTSerializable("radio", launcher -> launcher.radioCap).nodeINBTSerializable("inventory", launcher -> launcher.inventory).nodeVec3d("target", launcher -> launcher._targetPos, (launcher, pos) -> {
        launcher._targetPos = pos;
    }).base();

    @Override
    public void provideInformation(BiConsumer<String, Object> consumer) {
        super.provideInformation(consumer);
        consumer.accept("NEEDS_POWER", ConfigMain.REQUIRES_POWER);
    }

    @Override
    public LauncherNode getNetworkNode() {
        return this.launcherNode;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.inventory.onTick();
        if (this.isServer()) {
            if (this.ticks % 5 == 0 || this.refreshStatus) {
                this.refreshStatus = false;
                this.statusList.clear();
                List<LauncherEntry> launchers = this.getLaunchersInGroup();
                if (!launchers.isEmpty()) {
                    int launcherCount = launchers.size();
                    this.launcherInaccuracy = launchers.stream().map(LauncherEntry::getLauncher).map(l -> {
                        IActionStatus status = this.preCheck((IMissileLauncher)l, launcherCount);
                        this.statusList.add(new LauncherPair(l.getLauncherGroup(), l.getLaunchIndex(), status));
                        return Float.valueOf(l.getInaccuracy(this.getTarget(), launchers.size()));
                    }).max(Float::compareTo).orElse(Float.valueOf(0.0f)).floatValue();
                }
            }
            if (this.ticks % 3 == 0 && this.field_145850_b.func_175676_y(this.func_174877_v()) > 0) {
                this.fireAllLaunchers(false);
            }
        }
    }

    @Nonnull
    public List<LauncherEntry> getLaunchersInGroup() {
        if (this.getNetworkNode().getNetwork() != null) {
            return this.getNetworkNode().getLaunchers();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean read(ByteBuf data, int id, EntityPlayer player, IPacket packet) {
        if (!super.read(data, id, player, packet)) {
            if (this.isServer()) {
                switch (id) {
                    case 0: {
                        this.radioCap.setChannel(ByteBufUtils.readUTF8String((ByteBuf)data));
                        this.updateClient = true;
                        return true;
                    }
                    case 1: {
                        this.setTarget(new Vec3d(data.readDouble(), data.readDouble(), data.readDouble()));
                        this.updateClient = true;
                        return true;
                    }
                    case 2: {
                        this.fireAllLaunchers(false);
                        this.updateClient = true;
                        return true;
                    }
                    case 4: {
                        this.radioCap.setDisabled(data.readBoolean());
                        this.updateClient = true;
                        return true;
                    }
                }
            } else if (id == 3) {
                this.readGuiPacket(data);
                return true;
            }
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void readGuiPacket(ByteBuf data) {
        this.radioCap.setChannel(ByteBufUtils.readUTF8String((ByteBuf)data));
        this.radioCap.setDisabled(data.readBoolean());
        this.launcherInaccuracy = data.readFloat();
        this.setTarget(new Vec3d(data.readDouble(), data.readDouble(), data.readDouble()));
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)data);
        NBTTagList list = compound.func_150295_c("p", 10);
        ArrayList<LauncherPair> status = new ArrayList<LauncherPair>(list.func_74745_c());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound save = (NBTTagCompound)list.func_179238_g(i);
            int group = save.func_74762_e("g");
            int index = save.func_74762_e("i");
            NBTTagCompound partSave = save.func_74775_l("p");
            IActionStatus part = ICBMClassicAPI.ACTION_STATUS_REGISTRY.load(partSave);
            if (part == null) continue;
            status.add(new LauncherPair(group, index, part));
        }
        Minecraft.func_71410_x().func_152344_a(() -> {
            this.statusList.clear();
            this.statusList.addAll(status);
        });
    }

    @Override
    protected PacketTile getGUIPacket() {
        PacketTile packet = new PacketTile("gui", 3, this);
        packet.addData(new Object[]{this.radioCap.getChannel()});
        packet.addData(new Object[]{this.radioCap.isDisabled()});
        packet.addData(new Object[]{Float.valueOf(this.launcherInaccuracy)});
        packet.addData(new Object[]{this.getTarget()});
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        this.statusList.forEach(pair -> {
            NBTTagCompound save = new NBTTagCompound();
            save.func_74768_a("g", pair.getGroup().intValue());
            save.func_74768_a("i", pair.getIndex().intValue());
            save.func_74782_a("p", (NBTBase)ICBMClassicAPI.ACTION_STATUS_REGISTRY.save(pair.getStatus()));
            list.func_74742_a((NBTBase)save);
        });
        tag.func_74782_a("p", (NBTBase)list);
        packet.addData(new Object[]{tag});
        return packet;
    }

    public void sendHzPacket(String channel) {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("frequency_C>S", 0, this).addData(new Object[]{channel}));
        }
    }

    public void sendTargetPacket(Vec3d data) {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("target_C>S", 1, this).addData(new Object[]{data}));
        }
    }

    public void sendLaunchPacket() {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("launch_C>S", 2, this));
        }
    }

    public void sendRadioDisabled() {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("launch_C>S", 4, this).addData(new Object[]{!this.radioCap.isDisabled()}));
        }
    }

    public IActionStatus launch(IMissileLauncher launcher, int launcherCount, boolean simulate) {
        return launcher.launch(new BasicTargetData(this.getTarget()), this.createCause(launcherCount), simulate);
    }

    public IActionStatus preCheck(IMissileLauncher launcher, int launcherCount) {
        return launcher.preCheckLaunch(new BasicTargetData(this.getTarget()), this.createCause(launcherCount));
    }

    private IMissileCause createCause(int launcherCount) {
        return new BlockScreenCause(this.field_145850_b, this.field_174879_c, this.getBlockState(), launcherCount);
    }

    public boolean fireAllLaunchers(boolean simulate) {
        this.refreshStatus = true;
        boolean hasFired = false;
        for (LauncherEntry launcher : this.getLaunchersInGroup()) {
            IActionStatus status = this.launch(launcher.getLauncher(), this.getLaunchers().size(), simulate);
            if (status.isError()) continue;
            hasFired = true;
        }
        return hasFired;
    }

    public boolean canLaunch() {
        if (this.isClient()) {
            return !this.statusList.isEmpty() && this.statusList.stream().map(LauncherPair::getStatus).noneMatch(IActionStatus::shouldBlockInteraction);
        }
        return this.fireAllLaunchers(true);
    }

    public ITextComponent getStatusTranslation() {
        if (this.getNetworkNode().getNetwork() == null) {
            return LauncherLangs.TRANSLATION_ERROR_NO_NETWORK;
        }
        if (this.getNetworkNode().getLaunchers().isEmpty()) {
            return LauncherLangs.TRANSLATION_ERROR_NO_LAUNCHER;
        }
        if (this.statusList.isEmpty()) {
            return LauncherLangs.TRANSLATION_ERROR_NO_NETWORK_STATUS;
        }
        List errors = this.statusList.stream().filter(pair -> pair.getStatus().shouldBlockInteraction()).collect(Collectors.toList());
        if (errors.isEmpty()) {
            return LauncherLangs.TRANSLATION_READY;
        }
        if (errors.size() == 1) {
            return ((LauncherPair)errors.get(0)).getStatus().message();
        }
        return new TextComponentTranslation("info.icbmclassic:launcher.error.missile.multi", new Object[]{errors.size()});
    }

    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerLaunchScreen(player, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return new GuiLauncherScreen(player, this);
    }

    public void onLoad() {
        super.onLoad();
        this.getNetworkNode().connectToTiles();
        if (this.isServer()) {
            RadioRegistry.add(this.radioCap);
        }
    }

    @Override
    public void func_145843_s() {
        if (this.isServer()) {
            RadioRegistry.remove(this.radioCap);
        }
        this.getNetworkNode().onTileRemoved();
        super.func_145843_s();
    }

    public Vec3d getTarget() {
        return this._targetPos;
    }

    public void setTarget(Vec3d target) {
        if (target != this._targetPos) {
            if (this.isServer()) {
                LauncherSetTargetEvent event = new LauncherSetTargetEvent(this.field_145850_b, this.func_174877_v(), target);
                if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                    this._targetPos = event.target == null ? Vec3d.field_186680_a : event.target;
                    this.updateClient = true;
                }
            } else {
                this._targetPos = target;
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == ICBMClassicAPI.RADIO_CAPABILITY || Optional.ofNullable(this.getNetworkNode().getNetwork()).map(network -> network.hasCapability(capability, facing)).orElse(false) != false;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        T cap;
        if (capability == ICBMClassicAPI.RADIO_CAPABILITY) {
            return (T)this.radioCap;
        }
        if (this.getNetworkNode().getNetwork() != null && (cap = this.getNetworkNode().getNetwork().getCapability(capability, facing)) != null) {
            return cap;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        SAVE_LOGIC.load(this, nbt);
        if (nbt.func_74764_b("frequency")) {
            this.radioCap.setChannel(Integer.toString(nbt.func_74762_e("frequency")));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        SAVE_LOGIC.save(this, nbt);
        return super.func_189515_b(nbt);
    }

    public float getLauncherInaccuracy() {
        return this.launcherInaccuracy;
    }
}

