/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.network;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.content.blocks.launcher.network.LauncherNetwork;
import icbm.classic.content.blocks.launcher.network.LauncherNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class NetworkInventory
implements IItemHandler {
    private final LauncherNetwork network;
    private final List<SlotHolder> slots = new ArrayList<SlotHolder>();

    public void buildInventory() {
        this.slots.clear();
        this.network.getComponents().stream().filter(LauncherNode::isAcceptsItems).forEach(node -> {
            IItemHandler handler = this.getHandler(node.getSelf());
            if (handler != null) {
                int slotCount = handler.getSlots();
                for (int i = 0; i < slotCount; ++i) {
                    this.slots.add(new SlotHolder(handler, i));
                }
            }
        });
    }

    public int getSlots() {
        return this.slots.size();
    }

    private IItemHandler getHandler(TileEntity tile) {
        IItemHandler handler;
        if (tile.hasCapability(ICBMClassicAPI.MISSILE_LAUNCHER_CAPABILITY, null) && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            return handler;
        }
        return null;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        SlotHolder holder = this.slots.get(slot);
        return holder.handler.getStackInSlot(holder.getSlotIndex());
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        this.validateSlotIndex(slot);
        SlotHolder holder = this.slots.get(slot);
        return holder.handler.insertItem(holder.getSlotIndex(), stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.validateSlotIndex(slot);
        SlotHolder holder = this.slots.get(slot);
        return holder.handler.extractItem(holder.getSlotIndex(), amount, simulate);
    }

    public int getSlotLimit(int slot) {
        this.validateSlotIndex(slot);
        SlotHolder holder = this.slots.get(slot);
        return holder.handler.getSlotLimit(holder.getSlotIndex());
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        SlotHolder holder = this.slots.get(slot);
        return holder.handler.isItemValid(holder.getSlotIndex(), stack);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.slots.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.slots.size() + ")");
        }
    }

    public NetworkInventory(LauncherNetwork network) {
        this.network = network;
    }

    private static class SlotHolder {
        private final IItemHandler handler;
        private final int slotIndex;

        public IItemHandler getHandler() {
            return this.handler;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SlotHolder)) {
                return false;
            }
            SlotHolder other = (SlotHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSlotIndex() != other.getSlotIndex()) {
                return false;
            }
            IItemHandler this$handler = this.getHandler();
            IItemHandler other$handler = other.getHandler();
            return !(this$handler == null ? other$handler != null : !this$handler.equals(other$handler));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SlotHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSlotIndex();
            IItemHandler $handler = this.getHandler();
            result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
            return result;
        }

        public String toString() {
            return "NetworkInventory.SlotHolder(handler=" + this.getHandler() + ", slotIndex=" + this.getSlotIndex() + ")";
        }

        public SlotHolder(IItemHandler handler, int slotIndex) {
            this.handler = handler;
            this.slotIndex = slotIndex;
        }
    }
}

