/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.network;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.launcher.IMissileLauncher;
import icbm.classic.content.blocks.launcher.network.LauncherEntry;
import icbm.classic.content.blocks.launcher.network.LauncherNode;
import icbm.classic.content.blocks.launcher.network.NetworkEnergyStorage;
import icbm.classic.content.blocks.launcher.network.NetworkInventory;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;

public class LauncherNetwork
implements ICapabilityProvider {
    private final HashSet<LauncherNode> components = new HashSet();
    private final List<LauncherEntry> launchers = new LinkedList<LauncherEntry>();
    public final NetworkEnergyStorage energyStorage = new NetworkEnergyStorage(this);
    public final NetworkInventory inventory = new NetworkInventory(this);

    public void invalidate(LauncherNode source) {
        HashSet<LauncherNode> components = new HashSet<LauncherNode>(this.components);
        this.clearData();
        components.forEach(LauncherNode::onNetworkInvalidate);
        components.stream().filter(node -> node != source).forEach(LauncherNode::connectToTiles);
    }

    protected void clearData() {
        this.launchers.clear();
        this.components.clear();
        this.onNetworkUpdated();
    }

    public void mergeNetwork(LauncherNetwork otherNetwork) {
        LauncherNetwork newNetwork = new LauncherNetwork();
        this.components.forEach(newNetwork::addToNetwork);
        otherNetwork.components.forEach(newNetwork::addToNetwork);
        this.clearData();
    }

    public void addToNetwork(LauncherNode node) {
        if (!this.components.contains(node)) {
            IMissileLauncher launcher;
            this.components.add(node);
            node.setNetwork(this);
            if (node.getSelf().hasCapability(ICBMClassicAPI.MISSILE_LAUNCHER_CAPABILITY, null) && (launcher = (IMissileLauncher)node.getSelf().getCapability(ICBMClassicAPI.MISSILE_LAUNCHER_CAPABILITY, null)) != null) {
                this.launchers.add(new LauncherEntry(launcher, node.getSelf(), null));
                this.onNetworkUpdated();
            }
        }
    }

    public void onNetworkUpdated() {
        this.inventory.buildInventory();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return null;
    }

    public HashSet<LauncherNode> getComponents() {
        return this.components;
    }

    public List<LauncherEntry> getLaunchers() {
        return this.launchers;
    }
}

