/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.cruise;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.ICBMClassicHelpers;
import icbm.classic.api.events.LauncherSetTargetEvent;
import icbm.classic.config.ConfigMain;
import icbm.classic.config.machines.ConfigLauncher;
import icbm.classic.content.blocks.launcher.FiringPackage;
import icbm.classic.content.blocks.launcher.cruise.CLauncherCapability;
import icbm.classic.content.blocks.launcher.cruise.RadioCruise;
import icbm.classic.content.blocks.launcher.cruise.gui.ContainerCruiseLauncher;
import icbm.classic.content.blocks.launcher.cruise.gui.GuiCruiseLauncher;
import icbm.classic.content.blocks.launcher.network.ILauncherComponent;
import icbm.classic.content.blocks.launcher.network.LauncherNode;
import icbm.classic.content.missile.logic.source.cause.EntityCause;
import icbm.classic.content.missile.logic.source.cause.RedstoneCause;
import icbm.classic.content.missile.logic.targeting.BasicTargetData;
import icbm.classic.lib.capability.launcher.CapabilityMissileHolder;
import icbm.classic.lib.energy.storage.EnergyBuffer;
import icbm.classic.lib.energy.system.EnergySystem;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.IPacketIDReceiver;
import icbm.classic.lib.network.packet.PacketTile;
import icbm.classic.lib.radio.RadioRegistry;
import icbm.classic.lib.saving.NbtSaveHandler;
import icbm.classic.lib.transform.region.Cube;
import icbm.classic.lib.transform.rotation.EulerAngle;
import icbm.classic.lib.transform.vector.Pos;
import icbm.classic.prefab.inventory.InventorySlot;
import icbm.classic.prefab.inventory.InventoryWithSlots;
import icbm.classic.prefab.tile.IGuiTile;
import icbm.classic.prefab.tile.TileMachine;
import io.netty.buffer.ByteBuf;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileCruiseLauncher
extends TileMachine
implements IPacketIDReceiver,
IGuiTile,
ILauncherComponent {
    public static final int GUI_PACKET_ID = 0;
    public static final int SET_FREQUENCY_PACKET_ID = 1;
    public static final int SET_TARGET_PACKET_ID = 2;
    public static final int LAUNCH_PACKET_ID = 3;
    public static final int RADIO_DISABLE_PACKET_ID = 4;
    private static final int REDSTONE_CHECK_RATE = 40;
    private static final double ROTATION_SPEED = 10.0;
    public static final double MISSILE__HOLDER_Y = 2.0;
    private Vec3d _targetPos = Vec3d.field_186680_a;
    protected final EulerAngle aim = new EulerAngle(0.0, 0.0, 0.0);
    protected final EulerAngle currentAim = new EulerAngle(0.0, 0.0, 0.0);
    protected long lastRotationUpdate = System.nanoTime();
    protected double deltaTime;
    protected ItemStack cachedMissileStack = ItemStack.field_190927_a;
    public final EnergyBuffer energyStorage = new EnergyBuffer(() -> ConfigLauncher.POWER_CAPACITY).withOnChange((p, c, s) -> {
        this.updateClient = true;
        this.func_70296_d();
    });
    public final InventoryWithSlots inventory = new InventoryWithSlots(2).withChangeCallback((s, i) -> this.func_70296_d()).withSlot(new InventorySlot(0, ICBMClassicHelpers::isMissile).withChangeCallback(stack -> this.sendDescPacket())).withSlot(new InventorySlot(1, EnergySystem::isEnergyItem).withTick(this.energyStorage::dischargeItem));
    protected final CapabilityMissileHolder missileHolder = new CapabilityMissileHolder((IItemHandlerModifiable)this.inventory, 0);
    protected final CLauncherCapability launcher = new CLauncherCapability(this);
    protected FiringPackage firingPackage;
    private final LauncherNode launcherNode = new LauncherNode(this, true);
    public final RadioCruise radioCap = new RadioCruise(this);
    private static final NbtSaveHandler<TileCruiseLauncher> SAVE_LOGIC = new NbtSaveHandler().mainRoot().nodeINBTSerializable("inventory", launcher -> launcher.inventory).nodeINBTSerializable("radio", launcher -> launcher.radioCap).nodeVec3d("target", launcher -> launcher._targetPos, (launcher, pos) -> {
        launcher._targetPos = pos;
    }).nodeEulerAngle("currentAim", launcher -> launcher.currentAim, (launcher, pos) -> launcher.currentAim.set((EulerAngle)pos)).nodeINBTSerializable("firing_package", launcher -> launcher.firingPackage).nodeInteger("energy", tile -> tile.energyStorage.getEnergyStored(), (tile, i) -> tile.energyStorage.setEnergyStored((int)i)).base();

    @Override
    public void provideInformation(BiConsumer<String, Object> consumer) {
        super.provideInformation(consumer);
        consumer.accept("NEEDS_POWER", ConfigMain.REQUIRES_POWER);
        consumer.accept("ENERGY_COST_ACTION", this.getFiringCost());
    }

    public int getFiringCost() {
        return ConfigLauncher.POWER_COST;
    }

    public void onLoad() {
        super.onLoad();
        this.launcherNode.connectToTiles();
        if (this.isServer()) {
            RadioRegistry.add(this.radioCap);
        }
    }

    @Override
    public void func_145843_s() {
        if (this.isServer()) {
            RadioRegistry.remove(this.radioCap);
        }
        super.func_145843_s();
    }

    @Override
    public LauncherNode getNetworkNode() {
        return this.launcherNode;
    }

    public ITextComponent getStatusTranslation() {
        if (!this.hasChargeToFire()) {
            return new TextComponentTranslation("info.icbmclassic:launcher.error.power", new Object[0]);
        }
        if (!this.missileHolder.hasMissile()) {
            return new TextComponentTranslation("info.icbmclassic:launcher.error.missile.none", new Object[0]);
        }
        if (!this.hasTarget()) {
            return new TextComponentTranslation("info.icbmclassic:launcher.error.target.none", new Object[0]);
        }
        if (this.isTooClose(this.getTarget())) {
            return new TextComponentTranslation("info.icbmclassic:launcher.error.target.min", new Object[0]);
        }
        if (!this.canSpawnMissileWithNoCollision()) {
            return new TextComponentTranslation("info.icbmclassic:launcher.error.missile.space", new Object[0]);
        }
        return new TextComponentTranslation("info.icbmclassic:launcher.status.ready", new Object[0]);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.deltaTime = (double)(System.nanoTime() - this.lastRotationUpdate) / 1.0E8;
        this.lastRotationUpdate = System.nanoTime();
        this.inventory.onTick();
        this.currentAim.moveTowards(this.aim, 10.0, this.deltaTime).clampTo360();
        if (this.isServer()) {
            if (this.ticks % 40 == 0) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    int power = this.field_145850_b.func_175651_c(this.func_174877_v().func_177972_a(side), side);
                    if (power <= 1) continue;
                    this.firingPackage = new FiringPackage(new BasicTargetData(this.getTarget()), new RedstoneCause(this.world(), this.func_174877_v(), this.getBlockState(), side), 0);
                }
            }
            if (this.firingPackage != null && this.isAimed()) {
                this.firingPackage.setCountDown(this.firingPackage.getCountDown() - 1);
                if (this.firingPackage.getCountDown() <= 0) {
                    this.firingPackage.launch(this.launcher);
                    this.firingPackage = null;
                }
            }
        }
    }

    public void setTarget(Vec3d target) {
        if (target != this._targetPos) {
            if (this.isServer()) {
                LauncherSetTargetEvent event = new LauncherSetTargetEvent(this.field_145850_b, this.func_174877_v(), target);
                if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                    this._targetPos = event.target == null ? Vec3d.field_186680_a : event.target;
                    this.updateClient = true;
                }
            } else {
                this._targetPos = target;
            }
            this.updateAimAngle();
        }
    }

    public boolean isAimed() {
        return this.currentAim.isWithin(this.aim, 0.01);
    }

    protected void updateAimAngle() {
        if (this.hasTarget()) {
            Vec3d aimPoint = this.getTarget();
            Pos center = (Pos)new Pos((IPos3D)this).add(0.5, 2.0, 0.5);
            this.aim.set(center.toEulerAngle(aimPoint).clampTo360());
            this.aim.setYaw(EulerAngle.clampPos360(this.aim.yaw()));
        } else {
            this.aim.set(0.0, 0.0, 0.0);
        }
    }

    @Override
    public PacketTile getGUIPacket() {
        return (PacketTile)new PacketTile("gui", 0, this).addData(new Object[]{this.energyStorage.getEnergyStored(), this.radioCap.getChannel(), this.radioCap.isDisabled(), this.getTarget().field_72450_a, this.getTarget().field_72448_b, this.getTarget().field_72449_c});
    }

    @Override
    public boolean read(ByteBuf data, int id, EntityPlayer player, IPacket type) {
        if (!super.read(data, id, player, type)) {
            switch (id) {
                case 1: {
                    this.radioCap.setChannel(ByteBufUtils.readUTF8String((ByteBuf)data));
                    this.updateClient = true;
                    return true;
                }
                case 2: {
                    this.setTarget(new Vec3d(data.readDouble(), data.readDouble(), data.readDouble()));
                    this.updateClient = true;
                    return true;
                }
                case 3: {
                    EntityCause cause = new EntityCause((Entity)player);
                    this.launcher.launch(new BasicTargetData(this.getTarget()), cause, false);
                    this.updateClient = true;
                    return true;
                }
                case 4: {
                    this.radioCap.setDisabled(data.readBoolean());
                    return true;
                }
                case 0: {
                    if (this.isClient()) {
                        this.energyStorage.setEnergyStored(data.readInt());
                        this.radioCap.setChannel(ByteBufUtils.readUTF8String((ByteBuf)data));
                        this.radioCap.setDisabled(data.readBoolean());
                        this.setTarget(new Vec3d(data.readDouble(), data.readDouble(), data.readDouble()));
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.missileHolder.getMissileStack());
        buf.writeDouble(this.getTarget().field_72450_a);
        buf.writeDouble(this.getTarget().field_72448_b);
        buf.writeDouble(this.getTarget().field_72449_c);
        buf.writeDouble(this.currentAim.yaw());
        buf.writeDouble(this.currentAim.pitch());
    }

    @Override
    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        this.cachedMissileStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.setTarget(new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble()));
        this.currentAim.setYaw(buf.readDouble());
        this.currentAim.setPitch(buf.readDouble());
    }

    protected void initFromLoad() {
        this.cachedMissileStack = this.inventory.getStackInSlot(0);
        this.updateAimAngle();
        this.currentAim.set(this.aim);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.initFromLoad();
    }

    public void sendHzPacket(String channel) {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("frequency_C>S", 1, this).addData(new Object[]{channel}));
        }
    }

    public void sendTargetPacket(Vec3d data) {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("target_C>S", 2, this).addData(new Object[]{data}));
        }
    }

    public void sendFirePacket() {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("launch_C>S", 3, this));
        }
    }

    public void sendRadioDisabled() {
        if (this.isClient()) {
            ICBMClassic.packetHandler.sendToServer(new PacketTile("radioDisable_C>S", 4, this).addData(new Object[]{!this.radioCap.isDisabled()}));
        }
    }

    public boolean canLaunch() {
        return this.hasTarget() && this.isAimed() && this.missileHolder.hasMissile() && this.hasChargeToFire() && !this.isTooClose(this.getTarget()) && this.canSpawnMissileWithNoCollision();
    }

    protected boolean hasTarget() {
        return this.getTarget() != null && this.getTarget() != Vec3d.field_186680_a;
    }

    protected boolean hasChargeToFire() {
        return this.energyStorage.consumePower(this.getFiringCost(), true);
    }

    protected boolean canSpawnMissileWithNoCollision() {
        for (int y = 1; y <= 2; ++y) {
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    BlockPos pos = this.func_174877_v().func_177982_a(x, y, z);
                    IBlockState state = this.field_145850_b.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (block.isAir(state, (IBlockAccess)this.field_145850_b, pos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isTooClose(Vec3d target) {
        return ((Pos)new Pos(this.func_174877_v()).add(0.5)).distance(target) < 20.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new Cube(-2.0, 0.0, -2.0, 2.0, 3.0, 2.0).add(new Pos((IPos3D)this)).toAABB();
    }

    @Override
    public Object getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerCruiseLauncher(player, this);
    }

    @Override
    public Object getClientGuiElement(int id, EntityPlayer player) {
        return new GuiCruiseLauncher(player, this);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityEnergy.ENERGY && ConfigMain.REQUIRES_POWER || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == ICBMClassicAPI.MISSILE_HOLDER_CAPABILITY || capability == ICBMClassicAPI.MISSILE_LAUNCHER_CAPABILITY || capability == ICBMClassicAPI.RADIO_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inventory);
        }
        if (capability == ICBMClassicAPI.MISSILE_HOLDER_CAPABILITY) {
            return (T)this.missileHolder;
        }
        if (capability == ICBMClassicAPI.MISSILE_LAUNCHER_CAPABILITY) {
            return (T)this.launcher;
        }
        if (capability == ICBMClassicAPI.RADIO_CAPABILITY) {
            return (T)this.radioCap;
        }
        return (T)super.getCapability(capability, facing);
    }

    public Vec3d getTarget() {
        if (this._targetPos == null) {
            this._targetPos = Vec3d.field_186680_a;
        }
        return this._targetPos;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        SAVE_LOGIC.load(this, nbt);
        if (nbt.func_74764_b("frequency")) {
            this.radioCap.setChannel(Integer.toString(nbt.func_74762_e("frequency")));
        }
        this.initFromLoad();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        SAVE_LOGIC.save(this, nbt);
        return super.func_189515_b(nbt);
    }

    public EulerAngle getAim() {
        return this.aim;
    }

    public EulerAngle getCurrentAim() {
        return this.currentAim;
    }

    public CapabilityMissileHolder getMissileHolder() {
        return this.missileHolder;
    }

    public CLauncherCapability getLauncher() {
        return this.launcher;
    }

    public FiringPackage getFiringPackage() {
        return this.firingPackage;
    }

    public void setFiringPackage(FiringPackage firingPackage) {
        this.firingPackage = firingPackage;
    }
}

