/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.cruise;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.launcher.IActionStatus;
import icbm.classic.api.launcher.IMissileLauncher;
import icbm.classic.api.missiles.ICapabilityMissileStack;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.api.missiles.cause.IMissileCause;
import icbm.classic.api.missiles.parts.IMissileTarget;
import icbm.classic.config.missile.ConfigMissile;
import icbm.classic.content.blocks.launcher.FiringPackage;
import icbm.classic.content.blocks.launcher.cruise.TileCruiseLauncher;
import icbm.classic.content.missile.logic.flight.DirectFlightLogic;
import icbm.classic.content.missile.logic.source.MissileSource;
import icbm.classic.content.missile.logic.source.cause.BlockCause;
import icbm.classic.lib.capability.launcher.data.FiringWithDelay;
import icbm.classic.lib.capability.launcher.data.LauncherStatus;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;

public class CLauncherCapability
implements IMissileLauncher {
    private final TileCruiseLauncher host;

    @Override
    public IActionStatus getStatus() {
        if (!this.host.energyStorage.consumePower(this.host.getFiringCost(), true)) {
            return LauncherStatus.ERROR_POWER;
        }
        if (this.host.getFiringPackage() != null && !this.getHost().isAimed()) {
            return LauncherStatus.FIRING_AIMING;
        }
        if (this.host.getFiringPackage() != null && this.host.getFiringPackage().getCountDown() > 0) {
            return new FiringWithDelay(this.host.getFiringPackage().getCountDown());
        }
        if (!this.host.canLaunch()) {
            return LauncherStatus.ERROR_GENERIC;
        }
        return LauncherStatus.READY;
    }

    @Override
    public IActionStatus preCheckLaunch(IMissileTarget target, @Nullable IMissileCause cause) {
        return this.getStatus();
    }

    @Override
    public IActionStatus launch(IMissileTarget target, @Nullable IMissileCause cause, boolean simulate) {
        ICapabilityMissileStack capabilityMissileStack;
        ItemStack inventoryStack;
        IActionStatus preCheck = this.preCheckLaunch(target, cause);
        if (preCheck.shouldBlockInteraction()) {
            return preCheck;
        }
        if (simulate) {
            return LauncherStatus.FIRING_AIMING;
        }
        this.host.setTarget(target.getPosition());
        if (!this.host.isAimed()) {
            this.host.setFiringPackage(new FiringPackage(target, cause, 0));
            return LauncherStatus.FIRING_AIMING;
        }
        BlockCause selfCause = new BlockCause(this.host.world(), this.host.func_174877_v(), this.host.getBlockState());
        selfCause.setPreviousCause(cause);
        MissileSource missileSource = new MissileSource(this.getHost().world(), new Vec3d((double)this.host.xi() + 0.5, (double)this.host.yi() + 2.0, (double)this.host.zi() + 0.5), selfCause);
        if (this.host.canLaunch() && (inventoryStack = this.host.missileHolder.getMissileStack()).hasCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null) && (capabilityMissileStack = (ICapabilityMissileStack)inventoryStack.getCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null)) != null) {
            if (this.host.isServer()) {
                IMissile missile = capabilityMissileStack.newMissile(this.host.world());
                Entity entity = missile.getMissileEntity();
                entity.func_70107_b(missileSource.getPosition().field_72450_a, missileSource.getPosition().field_72448_b, missileSource.getPosition().field_72449_c);
                if (!this.host.missileHolder.consumeMissile()) {
                    return LauncherStatus.ERROR_INVALID_STACK;
                }
                if (!this.host.energyStorage.consumePower(this.host.getFiringCost(), true)) {
                    return LauncherStatus.ERROR_POWER;
                }
                this.host.energyStorage.consumePower(this.host.getFiringCost(), false);
                missile.setMissileSource(missileSource);
                missile.setTargetData(target);
                missile.setFlightLogic(new DirectFlightLogic(ConfigMissile.CRUISE_FUEL));
                missile.launch();
                if (!this.host.world().func_72838_d(entity)) {
                    return LauncherStatus.ERROR_SPAWN;
                }
            }
            return LauncherStatus.LAUNCHED;
        }
        return LauncherStatus.ERROR_GENERIC;
    }

    public TileCruiseLauncher getHost() {
        return this.host;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CLauncherCapability)) {
            return false;
        }
        CLauncherCapability other = (CLauncherCapability)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TileCruiseLauncher this$host = this.getHost();
        TileCruiseLauncher other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CLauncherCapability;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TileCruiseLauncher $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public String toString() {
        return "CLauncherCapability(host=" + this.getHost() + ")";
    }

    public CLauncherCapability(TileCruiseLauncher host) {
        this.host = host;
    }
}

