/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.launcher.base;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.events.LauncherEvent;
import icbm.classic.api.launcher.IActionStatus;
import icbm.classic.api.launcher.IMissileLauncher;
import icbm.classic.api.missiles.ICapabilityMissileStack;
import icbm.classic.api.missiles.IMissile;
import icbm.classic.api.missiles.cause.IMissileCause;
import icbm.classic.api.missiles.parts.IMissileTarget;
import icbm.classic.api.missiles.parts.IMissileTargetDelayed;
import icbm.classic.config.machines.ConfigLauncher;
import icbm.classic.content.blocks.launcher.FiringPackage;
import icbm.classic.content.blocks.launcher.base.TileLauncherBase;
import icbm.classic.content.blocks.launcher.screen.BlockScreenCause;
import icbm.classic.content.missile.logic.flight.BallisticFlightLogic;
import icbm.classic.content.missile.logic.source.MissileSource;
import icbm.classic.content.missile.logic.source.cause.BlockCause;
import icbm.classic.content.missile.logic.targeting.BallisticTargetingData;
import icbm.classic.lib.capability.launcher.data.FiringWithDelay;
import icbm.classic.lib.capability.launcher.data.LauncherStatus;
import icbm.classic.lib.transform.rotation.EulerAngle;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LauncherCapability
implements IMissileLauncher {
    private static final EulerAngle angle = new EulerAngle(0.0, 0.0, 0.0);
    private static final Vec3d SPAWN_OFFSET = new Vec3d(0.5, (double)3.1f, 0.5);
    private final TileLauncherBase host;

    @Override
    public IActionStatus getStatus() {
        if (!this.host.energyStorage.consumePower(this.host.getFiringCost(), true)) {
            return LauncherStatus.ERROR_POWER;
        }
        if (this.host.missileHolder.getMissileStack().func_190926_b()) {
            return LauncherStatus.ERROR_EMPTY_STACK;
        }
        if (this.host.getFiringPackage() != null && this.host.getFiringPackage().getCountDown() > 0) {
            return new FiringWithDelay(this.host.getFiringPackage().getCountDown());
        }
        return LauncherStatus.READY;
    }

    @Override
    public IActionStatus preCheckLaunch(IMissileTarget targetData, @Nullable IMissileCause cause) {
        if (targetData == null || targetData.getPosition() == null) {
            return LauncherStatus.ERROR_TARGET_NULL;
        }
        if (this.isTargetTooClose(targetData.getPosition())) {
            return LauncherStatus.ERROR_MIN_RANGE;
        }
        if (this.isTargetTooFar(targetData.getPosition())) {
            return LauncherStatus.ERROR_MAX_RANGE;
        }
        return this.getStatus();
    }

    @Override
    public IActionStatus launch(IMissileTarget targetData, @Nullable IMissileCause cause, boolean simulate) {
        ICapabilityMissileStack missileStack;
        IActionStatus preCheck = this.preCheckLaunch(targetData, cause);
        if (preCheck.shouldBlockInteraction()) {
            return preCheck;
        }
        BlockCause selfCause = new BlockCause(this.host.world(), this.host.func_174877_v(), this.host.getBlockState());
        selfCause.setPreviousCause(cause);
        MissileSource source = new MissileSource(this.host.world(), SPAWN_OFFSET.func_72441_c((double)this.host.func_174877_v().func_177958_n(), (double)this.host.func_174877_v().func_177956_o(), (double)this.host.func_174877_v().func_177952_p()), selfCause);
        LauncherEvent.PreLaunch event = new LauncherEvent.PreLaunch(source, this, this.host.missileHolder, targetData, simulate);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            if (event.cancelReason != null) {
                return event.cancelReason;
            }
            return LauncherStatus.CANCELED;
        }
        ItemStack stack = this.host.missileHolder.getMissileStack();
        if (stack.hasCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null) && (missileStack = (ICapabilityMissileStack)stack.getCapability(ICBMClassicAPI.MISSILE_STACK_CAPABILITY, null)) != null) {
            Vec3d target = this.applyInaccuracy(targetData.getPosition(), cause instanceof BlockScreenCause ? ((BlockScreenCause)cause).getLauncherCount() : 1);
            if (this.host.getFiringPackage() == null) {
                int delay = this.host.getFiringDelay();
                if (targetData instanceof IMissileTargetDelayed) {
                    delay += ((IMissileTargetDelayed)targetData).getFiringDelay();
                }
                if (delay > 0) {
                    if (!simulate) {
                        this.host.setFiringPackage(new FiringPackage(targetData, cause, delay));
                    }
                    return new FiringWithDelay(delay);
                }
            }
            if (!this.getHost().isServer() || simulate) {
                return LauncherStatus.LAUNCHED;
            }
            IMissile missile = missileStack.newMissile(this.host.world());
            return this.fireMissile(missile, source, target);
        }
        return LauncherStatus.ERROR_INVALID_STACK;
    }

    private IActionStatus fireMissile(IMissile missile, MissileSource source, Vec3d target) {
        if (!this.host.missileHolder.consumeMissile()) {
            return LauncherStatus.ERROR_INVALID_STACK;
        }
        Entity entity = missile.getMissileEntity();
        entity.func_70107_b(source.getPosition().field_72450_a, source.getPosition().field_72448_b, source.getPosition().field_72449_c);
        missile.setTargetData(new BallisticTargetingData(target, 1));
        missile.setFlightLogic(new BallisticFlightLogic(this.host.getLockHeight()));
        missile.setMissileSource(source);
        missile.launch();
        if (!this.host.world().func_72838_d(entity)) {
            return LauncherStatus.ERROR_SPAWN;
        }
        if (!this.host.energyStorage.consumePower(this.host.getFiringCost(), true)) {
            return LauncherStatus.ERROR_POWER;
        }
        this.host.energyStorage.consumePower(this.host.getFiringCost(), false);
        if (this.host.seat != null && !this.host.seat.func_184188_bt().isEmpty()) {
            List riders = this.host.seat.func_184188_bt();
            riders.forEach(r -> {
                entity.func_184210_p();
                r.func_184220_m(entity);
            });
        }
        return LauncherStatus.LAUNCHED;
    }

    @Override
    public float getInaccuracy(Vec3d target, int launcherCount) {
        float inaccuracy = (float)ConfigLauncher.MIN_INACCURACY;
        double distance = this.host.func_145835_a(target.field_72450_a, target.field_72448_b, target.field_72449_c);
        double scale = distance / (double)ConfigLauncher.RANGE;
        inaccuracy = (float)((double)inaccuracy + scale * ConfigLauncher.SCALED_INACCURACY_DISTANCE);
        if (launcherCount > 1) {
            inaccuracy = (float)((double)inaccuracy + (double)(launcherCount - 1) * ConfigLauncher.SCALED_INACCURACY_LAUNCHERS);
        }
        return inaccuracy;
    }

    protected Vec3d applyInaccuracy(Vec3d target, int launcherCount) {
        float inaccuracy = this.getInaccuracy(target, launcherCount) * this.host.world().field_73012_v.nextFloat();
        angle.setYaw(this.host.world().field_73012_v.nextFloat() * 360.0f);
        return new Vec3d(target.field_72450_a + angle.x() * (double)inaccuracy, 0.0, target.field_72449_c + angle.z() * (double)inaccuracy);
    }

    public boolean isTargetTooClose(Vec3d target) {
        int minDistance = 10;
        double deltaX = Math.abs(target.field_72450_a - ((double)this.host.func_174877_v().func_177958_n() + 0.5));
        double deltaZ = Math.abs(target.field_72449_c - ((double)this.host.func_174877_v().func_177952_p() + 0.5));
        return deltaX < 10.0 || deltaZ < 10.0;
    }

    public boolean isTargetTooFar(Vec3d target) {
        double deltaX = Math.abs(target.field_72450_a - ((double)this.host.func_174877_v().func_177958_n() + 0.5));
        double deltaZ = Math.abs(target.field_72449_c - ((double)this.host.func_174877_v().func_177952_p() + 0.5));
        return deltaX > (double)ConfigLauncher.RANGE || deltaZ > (double)ConfigLauncher.RANGE;
    }

    public TileLauncherBase getHost() {
        return this.host;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LauncherCapability)) {
            return false;
        }
        LauncherCapability other = (LauncherCapability)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TileLauncherBase this$host = this.getHost();
        TileLauncherBase other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LauncherCapability;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TileLauncherBase $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public String toString() {
        return "LauncherCapability(host=" + this.getHost() + ")";
    }

    public LauncherCapability(TileLauncherBase host) {
        this.host = host;
    }
}

