/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blocks.emptower.gui;

import icbm.classic.content.blocks.emptower.TileEMPTower;
import icbm.classic.content.blocks.emptower.gui.ContainerEMPTower;
import icbm.classic.content.blocks.launcher.LauncherLangs;
import icbm.classic.content.blocks.launcher.cruise.gui.LaunchButton;
import icbm.classic.lib.LanguageUtility;
import icbm.classic.prefab.gui.GuiContainerBase;
import icbm.classic.prefab.gui.TextInput;
import icbm.classic.prefab.gui.button.DisableButton;
import icbm.classic.prefab.gui.components.SlotEnergyBar;
import icbm.classic.prefab.gui.tooltip.TooltipTranslations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class GuiEMPTower
extends GuiContainerBase {
    private static final String LANG_KEY = "gui.icbmclassic:empTower";
    private static final String GUI_NAME = "gui.icbmclassic:empTower.name";
    private static final String POWER_NEEDED = "gui.icbmclassic:empTower.power";
    private static final String COOLING_NEEDED = "gui.icbmclassic:empTower.cooling";
    private static final String READY = "gui.icbmclassic:empTower.ready";
    public static final ITextComponent TRANSLATION_TOOLTIP_RANGE = new TextComponentTranslation("gui.icbmclassic:empTower.range", new Object[0]);
    public static final ResourceLocation TEXTURE = new ResourceLocation("icbmclassic", "textures/gui/gui_emp_tower.png");
    private final TileEMPTower tileEntity;

    public GuiEMPTower(EntityPlayer player, TileEMPTower tileEntity) {
        super(new ContainerEMPTower(player, tileEntity));
        this.tileEntity = tileEntity;
        this.field_147000_g = 166;
        this.field_146999_f = 175;
    }

    @Override
    public ResourceLocation getBackground() {
        return TEXTURE;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int componentID = 0;
        int n = componentID++;
        this.addComponent(TextInput.intField(n, this.field_146289_q, 18, 17, 40, 12, this.tileEntity::getRange, this.tileEntity::setRange, this.tileEntity::sendRangePacket));
        int n2 = componentID++;
        this.addComponent(TextInput.textField(n2, this.field_146289_q, 135, 17, 34, 12, this.tileEntity.radioCap::getChannel, this.tileEntity.radioCap::setChannel, this.tileEntity::sendHzPacket));
        this.func_189646_b(((LaunchButton)((LaunchButton)new LaunchButton(0, this.field_147003_i + 24, this.field_147009_r + 38).doDrawDisabledGlass().setTooltip(() -> {
            if (!this.tileEntity.isReady()) {
                if (this.tileEntity.getCooldown() > 0) {
                    return new TextComponentTranslation(COOLING_NEEDED, new Object[]{String.format("%.2f", Float.valueOf(this.tileEntity.getCooldownPercentage() * 100.0f))});
                }
                if (!this.tileEntity.energyStorage.consumePower(this.tileEntity.getFiringCost(), false)) {
                    return new TextComponentTranslation(POWER_NEEDED, new Object[]{String.format("%.2f", Float.valueOf(this.tileEntity.getChargePercentage() * 100.0f))});
                }
            }
            return new TextComponentTranslation(READY, new Object[0]);
        })).setAction(this.tileEntity::sendFirePacket)).setEnabledCheck(this.tileEntity::isReady));
        this.addComponent(new SlotEnergyBar(141, 66, this.tileEntity.energyStorage::getEnergyStored, this.tileEntity.energyStorage::getMaxEnergyStored).withTickingCost(this.tileEntity::getTickingCost).withActionCost(this.tileEntity::getFiringCost));
        this.addComponent(new DisableButton(1, this.field_147003_i + 119, this.field_147009_r + 16, this.tileEntity.radioCap::isDisabled).setAction(this.tileEntity::sendRadioDisabled));
        this.addComponent(new TooltipTranslations(119, 16, 14, 14, LauncherLangs.TRANSLATION_TOOLTIP_RADIO).withDelay(1.0f));
        this.addComponent(new TooltipTranslations(2, 16, 14, 14, TRANSLATION_TOOLTIP_RANGE).withDelay(1.0f));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b("\u00a77" + LanguageUtility.getLocal(GUI_NAME), 52, 6, 0x404040);
        this.field_146289_q.func_78276_b("/ " + this.tileEntity.getMaxRadius(), 62, 19, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }
}

