/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast.redmatter.logic;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.caps.IExplosive;
import icbm.classic.api.explosion.IBlast;
import icbm.classic.api.explosion.IBlastIgnore;
import icbm.classic.api.explosion.redmatter.IBlastVelocity;
import icbm.classic.client.ICBMSounds;
import icbm.classic.config.blast.ConfigBlast;
import icbm.classic.content.blast.helpers.BlastBlockHelpers;
import icbm.classic.content.blast.redmatter.DamageSourceRedmatter;
import icbm.classic.content.blast.redmatter.EntityRedmatter;
import icbm.classic.content.blast.redmatter.logic.RedmatterBlockCollector;
import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.lib.CalculationHelpers;
import icbm.classic.lib.explosive.ExplosiveHandler;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public class RedmatterLogic {
    public final EntityRedmatter host;
    protected int blockDestroyedThisCycle = 0;
    protected int blockDestroyedThisTick = 0;
    protected int raytracesThisTick = 0;
    protected int cyclesSinceLastBlockRemoved = -1;
    protected int currentBlockDestroyRadius = -1;
    protected final Queue<BlockPos> rayTraceTargets = new LinkedList<BlockPos>();

    public RedmatterLogic(EntityRedmatter host) {
        this.host = host;
    }

    public int getBlocksPerTick() {
        return ConfigBlast.redmatter.MAX_BLOCKS_EDITS_PER_TICK;
    }

    public void tick() {
        this.preTick();
        this.doTick();
        this.postTick();
    }

    protected void preTick() {
        this.raytracesThisTick = 0;
        this.blockDestroyedThisTick = 0;
        if (this.currentBlockDestroyRadius < 0) {
            this.currentBlockDestroyRadius = (int)Math.floor(this.host.getBlastSize());
        }
    }

    protected void doTick() {
        this.detectAndDestroyBlocks();
        this.doEntityEffects();
        if (ConfigBlast.redmatter.ENABLE_AUDIO) {
            if (this.host.field_70170_p.field_73012_v.nextInt(8) == 0) {
                double playX = this.host.field_70165_t + (double)CalculationHelpers.randFloatRange(this.host.field_70170_p.field_73012_v, this.host.getBlastSize());
                double playY = this.host.field_70163_u + (double)CalculationHelpers.randFloatRange(this.host.field_70170_p.field_73012_v, this.host.getBlastSize());
                double playZ = this.host.field_70161_v + (double)CalculationHelpers.randFloatRange(this.host.field_70170_p.field_73012_v, this.host.getBlastSize());
                float volume = CalculationHelpers.randFloatRange(this.host.field_70170_p.field_73012_v, 5.0f, 6.0f);
                float pitch = CalculationHelpers.randFloatRange(this.host.field_70170_p.field_73012_v, 0.6f, 1.0f);
                ICBMSounds.COLLAPSE.play(this.host.field_70170_p, playX, playY, playZ, volume, pitch, true);
            }
            ICBMSounds.REDMATTER.play(this.host.field_70170_p, this.host.field_70165_t, this.host.field_70163_u, this.host.field_70161_v, 3.0f, CalculationHelpers.randFloatRange(this.host.field_70170_p.field_73012_v, -0.8f, 1.2f), true);
        }
    }

    protected void postTick() {
        if (this.blockDestroyedThisCycle <= 0) {
            this.decreaseScale();
        }
    }

    protected void decreaseScale() {
        float size = this.host.getBlastSize();
        if (size <= (float)this.cyclesSinceLastBlockRemoved) {
            if (size <= ConfigBlast.redmatter.MIN_SIZE) {
                this.host.setBlastSize(0.0f);
                this.host.func_70106_y();
                ICBMClassic.logger().info("Redmatter[{}] has starved to death at {} {} {} {}", (Object)this.host.func_145782_y(), (Object)this.host.field_70165_t, (Object)this.host.field_70163_u, (Object)this.host.field_70161_v, (Object)this.host.field_70170_p.field_73011_w.getDimension());
            } else {
                float newSize = size < 1.0f ? size * 0.9f : size * ConfigBlast.redmatter.STARVE_SCALE;
                this.host.setBlastSize(newSize);
            }
        }
    }

    protected void detectAndDestroyBlocks() {
        if ((float)this.currentBlockDestroyRadius > this.host.getBlastMaxSize()) {
            this.setCurrentBlockDestroyRadius((int)Math.floor(this.host.getBlastSize()));
        }
        if (this.rayTraceTargets.isEmpty()) {
            this.startNextBlockDestroyCycle();
        }
        this.cycleDestroyBlocks();
    }

    protected void cycleDestroyBlocks() {
        Vec3d center = this.host.func_174791_d();
        while (!this.shouldStopBreakingBlocks() && !this.rayTraceTargets.isEmpty()) {
            ++this.raytracesThisTick;
            this.rayTraceTowardsBlock(center, this.rayTraceTargets.poll());
        }
    }

    protected void startNextBlockDestroyCycle() {
        if (this.cyclesSinceLastBlockRemoved > 0) {
            this.cyclesSinceLastBlockRemoved = 0;
            this.setCurrentBlockDestroyRadius(this.currentBlockDestroyRadius + 1);
        }
        this.rayTraceTargets.clear();
        RedmatterBlockCollector.collectBlocksOnWallEdges(this.currentBlockDestroyRadius, (rx, ry, rz) -> this.rayTraceTargets.offer(new BlockPos(rx, ry, rz)));
        Collections.shuffle((List)((Object)this.rayTraceTargets));
        if (this.blockDestroyedThisCycle <= 0) {
            ++this.cyclesSinceLastBlockRemoved;
        }
        this.blockDestroyedThisCycle = 0;
    }

    protected void rayTraceTowardsBlock(Vec3d center, BlockPos target) {
        double targetZ;
        double targetY;
        double targetX = (double)target.func_177958_n() + center.field_72450_a;
        Vec3d pos = new Vec3d(targetX, targetY = (double)target.func_177956_o() + center.field_72448_b, targetZ = (double)target.func_177952_p() + center.field_72449_c);
        RayTraceResult rayTrace = this.host.field_70170_p.func_147447_a(center, pos, true, false, false);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.processNextBlock(rayTrace.func_178782_a());
        }
    }

    protected boolean shouldStopBreakingBlocks() {
        return this.raytracesThisTick > ConfigBlast.redmatter.DEFAULT_BLOCK_RAYTRACE_PER_TICK || this.blockDestroyedThisTick > this.getBlocksPerTick() || this.host.field_70128_L;
    }

    protected void processNextBlock(BlockPos blockPos) {
        IBlockState blockState;
        double dist = MathHelper.func_76133_a((double)this.host.func_174831_c(blockPos));
        if (dist < (double)(this.currentBlockDestroyRadius + 1) && this.shouldRemoveBlock(blockPos, blockState = this.host.field_70170_p.func_180495_p(blockPos)) && this.host.field_70170_p.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3)) {
            if (blockState.func_177230_c() == Blocks.field_150355_j || blockState.func_177230_c() == Blocks.field_150358_i) {
                this.freezeWaterAround(blockPos);
            }
            if (this.canTurnIntoFlyingBlock(blockState) && this.host.field_70170_p.field_73012_v.nextFloat() > ConfigBlast.redmatter.CHANCE_FOR_FLYING_BLOCK) {
                this.spawnFlyingBlock(blockPos, blockState);
            }
            this.markBlockRemoved();
        }
    }

    private void freezeWaterAround(BlockPos pos) {
        for (EnumFacing side : EnumFacing.values()) {
            BlockPos blockPos = pos.func_177971_a(side.func_176730_m());
            IBlockState blockState = this.host.field_70170_p.func_180495_p(blockPos);
            if (blockState.func_177230_c() != Blocks.field_150355_j && blockState.func_177230_c() != Blocks.field_150358_i) continue;
            this.host.field_70170_p.func_180501_a(blockPos, Blocks.field_150432_aD.func_176223_P(), 3);
        }
    }

    private void markBlockRemoved() {
        ++this.blockDestroyedThisCycle;
        ++this.blockDestroyedThisTick;
        this.cyclesSinceLastBlockRemoved = 0;
    }

    protected boolean shouldRemoveBlock(BlockPos blockPos, IBlockState blockState) {
        Block block = blockState.func_177230_c();
        boolean isFluid = BlastBlockHelpers.isFluid(blockState);
        return !block.isAir(blockState, (IBlockAccess)this.host.field_70170_p, blockPos) && (BlastBlockHelpers.isFlowingWater(blockState) || !isFluid && blockState.func_185887_b(this.host.field_70170_p, blockPos) >= 0.0f);
    }

    protected boolean canTurnIntoFlyingBlock(IBlockState blockState) {
        return ConfigBlast.redmatter.SPAWN_FLYING_BLOCKS && !BlastBlockHelpers.isFluid(blockState);
    }

    protected void spawnFlyingBlock(BlockPos blockPos, IBlockState blockState) {
        EntityFlyingBlock entity = new EntityFlyingBlock(this.host.field_70170_p, blockPos, blockState);
        entity.yawChange = 50.0f * this.host.field_70170_p.field_73012_v.nextFloat();
        entity.pitchChange = 50.0f * this.host.field_70170_p.field_73012_v.nextFloat();
        entity.field_70145_X = true;
        this.host.field_70170_p.func_72838_d((Entity)entity);
        this.handleEntities(entity);
    }

    private float getEntityImpactRange() {
        return this.host.getBlastSize() * ConfigBlast.redmatter.GRAVITY_SCALE;
    }

    protected void doEntityEffects() {
        float entityRadius = this.getEntityImpactRange();
        AxisAlignedBB bounds = new AxisAlignedBB(this.host.field_70165_t - (double)entityRadius, this.host.field_70163_u - (double)entityRadius, this.host.field_70161_v - (double)entityRadius, this.host.field_70165_t + (double)entityRadius, this.host.field_70163_u + (double)entityRadius, this.host.field_70161_v + (double)entityRadius);
        this.host.field_70170_p.func_72872_a(Entity.class, bounds).stream().filter(this::shouldHandleEntity).forEach(this::handleEntities);
    }

    private boolean shouldHandleEntity(Entity entity) {
        if (entity == this.host) {
            return false;
        }
        if (entity instanceof EntityPlayer && (((EntityPlayer)entity).field_71075_bZ.field_75098_d || ((EntityPlayer)entity).field_71075_bZ.field_75102_a)) {
            return false;
        }
        return !(entity instanceof IBlastIgnore) || !((IBlastIgnore)entity).canIgnore(this.host.blastData);
    }

    protected void handleEntities(Entity entity) {
        double xDifference = this.host.field_70165_t - entity.field_70165_t;
        double yDifference = this.host.field_70163_u - entity.field_70163_u;
        double zDifference = this.host.field_70161_v - entity.field_70161_v;
        double distance = this.host.func_70032_d(entity);
        this.moveEntity(entity, xDifference, yDifference, zDifference, distance);
        this.attackEntity(entity, distance);
    }

    private boolean moveEntity(Entity entity, double xDifference, double yDifference, double zDifference, double distance) {
        IBlastVelocity cap = (IBlastVelocity)entity.getCapability(ICBMClassicAPI.BLAST_VELOCITY_CAPABILITY, null);
        if (cap != null && cap.onBlastApplyMotion(this.host, this.host.blastData, xDifference, yDifference, zDifference, distance)) {
            return true;
        }
        double distanceScale = Math.max(0.0, 1.0 - distance / (double)this.getEntityImpactRange());
        double pullPower = Math.min(1.0, distanceScale * (double)this.host.getBlastSize() * 0.01);
        double velX = xDifference / distance * pullPower;
        double velY = yDifference / distance * pullPower;
        double velZ = zDifference / distance * pullPower;
        entity.func_70024_g(velX, velY, velZ);
        entity.field_70133_I = true;
        return true;
    }

    private void attackEntity(Entity entity, double distance) {
        double attackRange = Math.max(1.0f, ConfigBlast.redmatter.KILL_SCALE * this.host.getBlastSize());
        if (distance < attackRange) {
            if (entity instanceof EntityRedmatter && !entity.field_70128_L) {
                double selfRad = Math.pow(this.host.getBlastSize(), 3.0);
                double targetRad = Math.pow(((EntityRedmatter)entity).getBlastSize(), 3.0);
                float newRad = (float)Math.cbrt(selfRad + targetRad);
                this.host.setBlastSize(newRad);
                this.host.field_70159_w = 0.0;
                this.host.field_70181_x = 0.0;
                this.host.field_70179_y = 0.0;
            } else if (entity instanceof EntityExplosion) {
                IBlast blast = ((EntityExplosion)entity).getBlast();
                blast.clearBlast();
            } else if (entity.hasCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null)) {
                IExplosive explosive = (IExplosive)entity.getCapability(ICBMClassicAPI.EXPLOSIVE_CAPABILITY, null);
                ExplosiveHandler.createExplosion(this.host, entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, explosive);
            } else if (entity instanceof EntityLiving || entity instanceof EntityPlayer) {
                entity.func_70097_a((DamageSource)new DamageSourceRedmatter(this), 2000.0f);
            } else {
                entity.func_70106_y();
                if (entity instanceof EntityFlyingBlock && this.host.getBlastSize() < this.host.getBlastMaxSize()) {
                    this.host.setBlastSize(this.host.getBlastSize() + 0.05f);
                }
            }
        }
    }

    public void setCurrentBlockDestroyRadius(int size) {
        this.currentBlockDestroyRadius = (int)Math.max(1.0f, Math.min((float)size, this.host.getBlastMaxSize()));
        this.host.setBlastSize(size);
    }
}

